<?php

function painting_company_timer( $name, $selected, $is_start = true){

 	$time_format = get_option( 'time_format' );
 	$time_start = new DateTime( '00:00:00', new DateTimeZone( 'UTC' ) );
    $time_end = new DateTime( '23:45:00', new DateTimeZone( 'UTC' ) );
    $time_interval = '+ 15 min';

    $class = $is_start ? "select_start" : "select_end";
	
	$output = '';
    $output .= "<select name='{$name}' class='medium {$class}' data-current='{$selected}'>";
    $output .= ( $is_start ) ? '<option value="">'.esc_html__('OFF', 'dt_plugins_appointment').'</option>' : '';
    while( $time_start <= $time_end ){
    	$value = $time_start->format('H:i');
    	$name = $time_start->format($time_format);
    	$s = ( $selected == $value ) ? " selected='selected' " : "";
    	$output .= "<option value='{$value}' {$s}>{$name}</option>";
    	$time_start->modify($time_interval);
    }
    $output .= '</select>';
    return $output;
}

function painting_member_timer( $name, $selected = "", $is_start = true ){

 	$time_format = get_option( 'time_format' );
 	$time_start = new DateTime( '00:00:00', new DateTimeZone( 'UTC' ) );
    $time_end = new DateTime( '23:45:00', new DateTimeZone( 'UTC' ) );
    $time_interval = '+ 15 min';

    $class = $is_start ? "select_start" : "select_end";

    $output = "<select name='{$name}' class='{$class}' data-current='{$selected}'>";
    $output .= ( $is_start ) ? '<option value="">'.esc_html__('OFF', 'dt_plugins_appointment').'</option>' : "";
    while( $time_start <= $time_end ){
    	$value = $time_start->format('H:i');
    	$name = $time_start->format($time_format);
    	$s = ( $selected == $value ) ? " selected='selected' " : "";
    	$output .= "<option value='{$value}' {$s}>{$name}</option>";
    	$time_start->modify($time_interval);
    }
    $output .= '</select>';
    return $output;
}

function painting_durationtostring( $duration ) {

    $hours   = (int)( $duration / 3600 );
    $minutes = (int)( ( $duration % 3600 ) / 60 );
    $result  = '';
    if ( $hours > 0 ) {
        $result = sprintf( esc_html__( '%d h', 'dt_plugins_appointment' ), $hours );
        if ( $minutes > 0 ) {
            $result .= ' ';
        }
    }

    if ( $minutes > 0 ) {
        $result .= sprintf( esc_html__( '%d min', 'dt_plugins_appointment' ), $minutes );
    }
 return $result;
}

function painting_dates_range( $start_date, $end_date, $days = array() ){

    $interval = new DateInterval( 'P1D' );

    $realEnd = new DateTime( $end_date );
    $realEnd->add( $interval );

    $period = new DatePeriod( new DateTime( $start_date ), $interval, $realEnd );
    $dates = array();

    foreach ( $period as $date ) {
        $dates[] = in_array( strtolower( $date->format('l')) , $days ) ? $date->format( 'Y-m-d l' ) :"" ;
    }
    
    $dates = array_filter($dates);
    return $dates;
}

function painting_replace( $content , $array ){
    $replace = array(
     '[STAFF_NAME]' => $array['staff_name'],
     '[SERVICE]' => $array['service_name'],
     '[CLIENT_NAME]' => $array['client_name'],
     '[CLIENT_PHONE]' => $array['client_phone'],
     '[CLIENT_EMAIL]' => $array['client_email'],
	 '[CLIENT_ADDRESS]' => $array['client_address'],
     '[APPOINTMENT_ID]' => $array['appointment_id'],
     '[APPOINTMENT_TIME]' => $array['appointment_time'],
     '[APPOINTMENT_DATE]' => $array['appointment_date'],
     '[APPOINTMENT_TITLE]' => $array['appointment_title'],   
     '[APPOINTMENT_BODY]' => $array['appointment_body'],
     '[COMPANY_LOGO]' => $array['company_logo'],
     '[COMPANY_NAME]' => $array['company_name'],
     '[COMPANY_PHONE]' => $array['company_phone'],
     '[COMPANY_ADDRESS]' => $array['company_address'],
     '[COMPANY_WEBSITE]' => $array['company_website']);
	 
	return str_replace( array_keys( $replace ), array_values( $replace ), $content );
}

function painting_replace_agenda( $content , $array ){
    $replace = array(
     '[STAFF_NAME]' => $array['staff_name'],
     '[TOMORROW]' => $array['tomorrow'],
     '[TOMORROW_AGENDA]' => $array['tomorrow_agenda'],
     '[COMPANY_LOGO]' => $array['company_logo'],
     '[COMPANY_NAME]' => $array['company_name'],
     '[COMPANY_PHONE]' => $array['company_phone'],
     '[COMPANY_ADDRESS]' => $array['company_address'],
     '[COMPANY_WEBSITE]' => $array['company_website']);
	 
	return str_replace( array_keys( $replace ), array_values( $replace ), $content );
}

function painting_send_mail( $to, $subject, $message ){
	$sender_name =  painting_option('appointments', 'notification_sender_name');
	$sender_name = !empty($sender_name) ? $sender_name : get_option( 'blogname' );

	$sender_email = painting_option('appointments', 'notification_sender_email');
	$sender_email = !empty( $sender_email ) ? $sender_email : get_option( 'admin_email' );

	$from = esc_html($sender_name).'<'.esc_html($sender_email).'>';

	$headers  = 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
	$headers .= 'From: '.$from.'' . "\r\n";
	
	return wp_mail( $to, $subject, $message, $headers );
}

add_action( 'wp_ajax_painting_fill_staffs', 'painting_fill_staffs' );
add_action( 'wp_ajax_nopriv_painting_fill_staffs','painting_fill_staffs');
function painting_fill_staffs() {
	if( isset($_REQUEST['service_id']) ){
		
		$service_id = $_REQUEST['service_id'];
		if( painting_is_plugin_active('sitepress-multilingual-cms/sitepress.php') ) {
			global $sitepress;
			$default_lang = $sitepress->get_default_language();
			$current_lang = ICL_LANGUAGE_CODE;
			if( $default_lang != $current_lang ) {
				$service_id =  icl_object_id(  $service_id ,'dt_services', true ,$sitepress->get_default_language());
			}
		}

		$wp_query = new WP_Query();
		$staffs = array(
			'post_type' => 'dt_staffs',
			'posts_per_page' => '-1',
			'meta_query'=>array()
			);

		if($_REQUEST['staffids'] != '') {
			$staffids = explode(',', $_REQUEST['staffids']);
			$staffs['post__in'] = $staffids;
		}

		$staffs['meta_query'][] = array(
			'key'     => '_services',
			'value'   =>  $service_id,
			'compare' => 'LIKE'
			);
		
		$wp_query->query( $staffs );
		echo '<option value="">'.esc_html__('Select','dt_plugins_appointment').'</option>';
		if( $wp_query->have_posts() ):
			while( $wp_query->have_posts() ):
				$wp_query->the_post();
				$id = get_the_ID();
				$title = get_the_title($id);
				echo '<option value="'.$id.'">'.$title.'</option>';
			endwhile;
		endif;	
		
	}
	die( '' );
}

function painting_findTimeSlot( $working_hours, $bookings, $date , $service_duration = 1800 ){

	$time_format = get_option('time_format');

	$timeslot= array();
	$dayofweek = date('l',strtotime($date));
	$dayofweek = strtolower($dayofweek);

	$is_date_today = ($date == date( 'Y-m-d', current_time( 'timestamp' ) ) );
	$current_time  = date( 'H:i:s', ceil( current_time( 'timestamp' ) / 900 ) * 900 );

	$past = ( $date <  date('Y-m-d') ) ? true : false;

	if( array_key_exists($dayofweek, $working_hours)  && !$past ){

		$working_start_time = ($is_date_today && $current_time > $working_hours[ $dayofweek ][ 'start' ]) ? $current_time : $working_hours[ $dayofweek ][ 'start' ];
		$working_end_time = $working_hours[ $dayofweek ][ 'end' ];

		$show = $is_date_today && ($current_time > $working_end_time) ? false : true;
		if( $show ) {
			
			$intersection = painting_findIntersection( $working_start_time,$working_hours[ $dayofweek ][ 'end' ],'00:00','23:59');
			
			for( $time = painting_StrToTime($intersection['start']); $time <= ( painting_StrToTime($intersection['end']) - $service_duration ); $time += $service_duration ){

				$value = $date.' '.date('G:i:s', $time);
				$end = $date.' '.date('G:i:s', ($time+$service_duration));

				if( !in_array($value, $bookings) ) { # if already booked in $time
					$object = new stdClass();
					$object->label = date( $time_format, $time );
					$object->date = $date;
					$object->start = $value;
					$object->hours = date('g:i A', $time).' - '.date('g:i A', ($time+$service_duration));
					$object->end = $end;
					$p = $date.' ('.date('l',strtotime($date)).')';
					$timeslot[$p][$time] = $object;
				}
			}
		}
	}
	return $timeslot;
}

function painting_findIntersection( $p1_start, $p1_end, $p2_start, $p2_end ) {
	$result = false;
	if ( $p1_start <= $p2_start && $p1_end >= $p2_start && $p1_end <= $p2_end ) {
		$result = array( 'start' => $p2_start, 'end' => $p1_end );
	} else if ( $p1_start <= $p2_start && $p1_end >= $p2_end ) {
		$result = array( 'start' => $p2_start, 'end' => $p2_end );
	} else if ( $p1_start >= $p2_start && $p1_start <= $p2_end && $p1_end >= $p2_end ) {
		$result = array( 'start' => $p1_start, 'end' => $p2_end );
	} else if ( $p1_start >= $p2_start && $p1_end <= $p2_end ) {
		$result = array( 'start' => $p1_start, 'end' => $p1_end );
    }
	return $result;
}

function painting_StrToTime( $str ) {
	return strtotime( sprintf( '1985-03-17 %s', $str ) );
}

add_action( 'wp_ajax_painting_generate_schedule', 'painting_generate_schedule' );
add_action( 'wp_ajax_nopriv_painting_generate_schedule','painting_generate_schedule');
function painting_generate_schedule() {

	$seldate = $_REQUEST['aptdatepicker'];
	$staffid = $_REQUEST['staffid'];
	$staff = get_the_title($staffid);
	$staffids_str = $_REQUEST['staffids'];
	$serviceid = $_REQUEST['serviceid'];
	$service = get_the_title($serviceid);
	$staffs_arr = array();
	
	if( empty( $staffid ) ) {
		$wp_query = new WP_Query();
		$staffs = array( 'post_type' => 'dt_staffs', 'orderby'=>'ID', 'order'=>'DESC', 'posts_per_page' => '-1', 'meta_query'=>array());
		
		if($staffids_str != '') {
			$staffids = explode(',', $staffids_str);
			$staffs['post__in'] = $staffids;
		}
		
		$staffs['meta_query'][] = array( 'key' => '_services', 'value' => $serviceid, 'compare' => 'LIKE');
		$wp_query->query( $staffs );
		if( $wp_query->have_posts() ):
			while( $wp_query->have_posts() ):
				$wp_query->the_post();
				$staffid = get_the_ID();
				$staff =  get_the_title($staffid);
				$staffs_arr[$staffid] = $staff;
			endwhile;
		endif;	
		wp_reset_postdata();
	} else {
		$staffs_arr = array($staffid=>$staff);
	}
	
	$serviceinfo = get_post_meta( $serviceid, "_info",true);
	$serviceinfo = is_array($serviceinfo) ? $serviceinfo : array();
	$service_duration = array_key_exists('duration', $serviceinfo) ? $serviceinfo['duration'] :  1800;
	
	$out = '';
	$out .= '<div class="dt-sc-available-times">';
		
	$seldate = new DateTime($seldate);
	$seldate = $seldate->format('Y-m-d');
		
	foreach( $staffs_arr as $sid => $sname ) {
	
		# 1. Get Staff Schedule Time
		$timer = get_post_meta( $sid, "_timer",true);
		$timer = is_array($timer) ? $timer : array();
		$timer = array_filter($timer);
		$timer = array_diff( $timer, array('00:00'));
	
		$working_hours = array();
	
		foreach ( array('monday','tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday') as $day ):
			if(  array_key_exists("{$day}_start",$timer)  ):
				$working_hours[$day] = array( 'start' => $timer["{$day}_start"] , 'end' => $timer["{$day}_end"]);
			endif;	
		endforeach;
		
		#Staff existing bookings
		$bookings = array();
		global $wpdb;
		$q = "SELECT option_value FROM $wpdb->options WHERE option_name LIKE '_dt_reservation_mid_{$sid}%' ORDER BY option_id ASC";
		$rows = $wpdb->get_results( $q );
		if( $rows ){
			foreach ($rows as $row ) {
				if( is_serialized($row->option_value ) ) {
					$data = unserialize($row->option_value);
					$data = $data['start'];
					$data = explode("(", $data);
					$data = new DateTime($data[0]);	
					$data = $data->format("Y-m-d G:i:s");
					$bookings[] = $data;
				}
			}
		}
		#Staff existing bookings
		
		$slots = array();
		
		if( count($working_hours) ){
			$slot = painting_findTimeSlot( $working_hours, $bookings, $seldate, $service_duration );
			if( !empty($slot) ){
				$slots[] = $slot;
			}
		}
		
		$out .= "<h6 class='staff-name'>";
		$out .= "{$sname}";
		$out .= "</h6>";
	
		if( !empty($slots) ) {
			
			$sinfo = get_post_meta( $sid , "_info",true);
			$sinfo = is_array($sinfo) ? $sinfo : array();
		
			$out .= '<ul class="time-table">';
			foreach( $slots as $slot ){
				
				if( is_array($slot) ){
					foreach( $slot as $date => $s  ){
						if(is_array($s)){
							$daydate = $date;
							$out .= '<ul class="time-slots">';
							foreach( $s as $time ){
								$start = new DateTime($time->start);
								$start = $start->format( 'm/d/Y H:i');
	
								$end = new DateTime($time->end);
								$end = $end->format( 'm/d/Y H:i');
	
								$date =  new DateTime($time->date);
								$date = $date->format( 'm/d/Y');
	
								$out .= '<li>';
								$out .= "<a href='#' data-staffid='{$sid}' data-staffname='{$sname}' data-serviceid='{$serviceid}' data-start='{$start}' data-end='{$end}' data-date='{$date}' data-time='{$time->hours}' data-daydate='{$daydate}' class='time-slot'>";
								$out .= $time->label;
								$out .= '</a>';
								$out .= '</li>';
							}
							$out .= '</ul>';
						}
						$out .= '</li>';
					}
				}
			}
			$out .= "</ul>";
		} else {
			$out .= '<div class="dt-sc-info-box">'.esc_html__('Time slots not available for your requested date!. Please try again by changing date.', 'dt_plugins_appointment').'</div>';	
		}
	} # Staffs loops end
	
	$out .= '</div>';
	
	echo ($out != '') ? $out : '<p class="dt-sc-info-box">'.esc_html__('No Time slots available','dt_plugins_appointment').'</p>';
	die();

}

function painting_customer( $customer ){

	$user = $customer;
	$users = array();

	$wp_query = new WP_Query();
	$customers = array('post_type'=>'dt_customers','posts_per_page'=>-1,'order_by'=>'published');
	
		$wp_query->query($customers);
		if( $wp_query->have_posts() ):
			while( $wp_query->have_posts() ):
				$wp_query->the_post();
				$the_id = get_the_ID();
				$title = get_the_title($the_id);

				$info = get_post_meta ( $the_id, "_info",true);
				$info = is_array($info) ? $info : array();
				$info['name'] = $title;
				$users[$the_id] = $info;
			endwhile;
		endif;

	$uid = array_search( $user, $users);

	if( $uid  ){
		$uid = $uid;
	} else {
		#Insert new customer
		$post_id = wp_insert_post( array('post_title' => $user['firstname'].' '.$user['lastname'], 'post_type' => 'dt_customers', 'post_status' => 'publish'));
		if( $post_id > 0 ) {
			$info['firstname'] = $user['firstname'];
			$info['lastname'] = $user['lastname'];
			$info['phone'] = $user['phone'];
			$info['emailid'] = $user['emailid'];
			$info['address'] = $user['address'];
			$info['aboutyourproject'] = $user['aboutyourproject'];
			update_post_meta ($post_id, "_info", $info);
			$uid = $post_id;
		}
	}
	return $uid;
}

add_action( 'wp_ajax_dttheme_new_reservation', 'dttheme_new_reservation' ); # For logged-in users
add_action( 'wp_ajax_nopriv_dttheme_new_reservation','dttheme_new_reservation'); # For logged-out users
function dttheme_new_reservation(){
	global $wpdb;

	#New Customer
	$firstname = $_REQUEST['firstname'];
	$lastname = $_REQUEST['lastname'];
	$phone = $_REQUEST['phone'];
	$emailid = $_REQUEST['emailid'];
	$address = $_REQUEST['address'];
	$aboutyourproject = $_REQUEST['aboutyourproject'];
	
	$customer_data = array('firstname' => $firstname, 'lastname' => $lastname, 'phone' => $phone, 'emailid' => $emailid, 'address' => $address, 'aboutyourproject' => $aboutyourproject);
	$customer = painting_customer($customer_data);
	#New Customer
	
	$id = $wpdb->get_var("SELECT max(option_id) FROM $wpdb->options");
	$title = esc_html__("New Reservation By ",'dt_plugins_appointment').$firstname;
	$body =  $aboutyourproject;

	$staffid = $_REQUEST['staffid'];
	$serviceid = $_REQUEST['serviceid'];
	if( painting_is_plugin_active('sitepress-multilingual-cms/sitepress.php') ) {
		global $sitepress;
		$default_lang = $sitepress->get_default_language();
		$current_lang = ICL_LANGUAGE_CODE;
		if( $default_lang != $current_lang ) {
			$serviceid =  icl_object_id(  $serviceid ,'dt_services', true ,$sitepress->get_default_language());
		}
	}
	
	$start = $_REQUEST['start'];
	$end = $_REQUEST['end'];
	
	$option = "_dt_reservation_mid_{$staffid}_id_{$id}";
	$data = array( 'id' => $id, 'title' => $title, 'body' => $body, 'start'=> $start, 'end'=>$end, 'service'=>$serviceid, 'user'=>$customer, 'readOnly'=>true );
	
	# Sending Mail
	$client_name = $client_phone = $client_email = $client_address = $amount = '';
	
	#Staff
	$staff_name = get_the_title($staffid);
	$service_name = get_the_title($serviceid);

	$sinfo = get_post_meta( $staffid , "_info",true);
	$sinfo = is_array($sinfo) ? $sinfo : array();

	#Client
	if( !empty($data['user']) ){
		$client_name = get_the_title($data['user']);
		$cinfo = get_post_meta( $data['user'], "_info",true);
		$cinfo = is_array($cinfo) ? $cinfo : array();

		$client_email = array_key_exists('emailid', $cinfo) ? $cinfo['emailid'] : "";
		$client_phone = array_key_exists('phone', $cinfo) ? $cinfo['phone'] : "";
		$client_address = array_key_exists('address', $cinfo) ? $cinfo['address'] : "";
	}

	$array = array(
		'staff_name' => $staff_name,
		'service_name' => $service_name,
		'appointment_id' => $data['id'],
		'appointment_time' => $_POST['time'],
		'appointment_date' => $_POST['date'],
		'appointment_title' => $data['title'],
		'appointment_body' =>  $data['body'],
		'client_name' => $client_name,
		'client_phone' => $client_phone,
		'client_email' => $client_email,
		'client_address' => $client_address,
		'company_logo' => 'Company Logo',
		'company_name' => 'Company Name',
		'company_phone' => 'Company Phone',
		'company_address' => 'Company Address',
		'company_website' => 'Company Website');
	
	$subject = painting_option('appointments', 'appointment_notification_to_staff_subject');
	$subject = painting_replace( $subject, $array);

	$message = painting_option('appointments', 'appointment_notification_to_staff_message');
	$message = painting_replace( $message, $array);
	
	#Staff Mail
	painting_send_mail( $sinfo["emailid"], $subject, $message);
	
	#Admin Mail
	painting_send_mail( get_option('admin_email'), $subject, $message);
					
	#Client Mail
	if( !empty($client_email) ) {
		$subject = painting_option('appointments', 'appointment_notification_to_client_subject');
		$subject = painting_replace( $subject, $array);

		$message = painting_option('appointments', 'appointment_notification_to_client_message');
		$message = painting_replace( $message, $array);

		painting_send_mail( $client_email, $subject, $message);
	}


	# Sending Mail
	if( update_option( $option, $data ) ){
		echo json_encode('Success');
	} else {
		echo json_encode('Failed');
	}
	die('');
	
}

if( !function_exists( 'painting_wp_kses' ) ){
	function painting_wp_kses($content) {
		
		$dt_allowed_html_tags = array(
			'a' => array('class' => array(), 'data-product_id' => array(), 'href' => array(), 'title' => array(), 'target' => array(), 'id' => array(), 'data-post-id' => array(), 'data-gal' => array(), 'data-image' => array(), 'rel' => array()),
			'abbr' => array('title' => array()),
			'address' => array(),
			'area' => array('shape' => array(), 'coords' => array(), 'href' => array(), 'alt' => array()),
			'article' => array('id' => array(), 'class' => array()),
			'aside' => array('id' => array(), 'class' => array()),
			'audio' => array('autoplay' => array(), 'controls' => array(), 'loop' => array(), 'muted' => array(), 'preload' => array(), 'src' => array()),
			'b' => array(),
			'base' => array('href' => array(), 'target' => array()),
			'bdi' => array(),
			'bdo' => array('dir' => array()), 
			'blockquote' => array('cite' => array()), 
			'br' => array(),
			'button' => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'name' => array(), 'type' => array(), 'value' => array()),
			'canvas' => array('height' => array(), 'width' => array()),
			'caption' => array('align' => array()),
			'cite' => array(),
			'code' => array(),
			'col' => array(),
			'colgroup' => array(),
			'datalist' => array('id' => array()),
			'dd' => array(),
			'del' => array('cite' => array(), 'datetime' => array()),
			'details' => array('open' => array()),
			'dfn' => array(),
			'dialog' => array('open' => array()),
			'div' => array('class' => array(), 'id' => array(), 'style' => array(), 'align' => array(), 'data-for' => array()),
			'dl' => array(),
			'dt' => array(),
			'em' => array(),
			'embed' => array('height' => array(), 'src' => array(), 'type' => array(), 'width' => array()),
			'fieldset' => array('disabled' => array(), 'form' => array(), 'name' => array()),
			'figcaption' => array(),
			'figure' => array(),
			'form' => array('accept' => array(), 'accept-charset' => array(), 'action' => array(), 'autocomplete' => array(), 'enctype' => array(), 'method' => array(), 'name' => array(), 'novalidate' => array(), 'target' => array(), 'id' => array(), 'class' => array()),
			'h1' => array('class' => array()), 'h2' => array('class' => array()), 'h3' => array('class' => array()), 'h4' => array('class' => array()), 'h5' => array('class' => array()), 'h6' => array('class' => array()),
			'hr' => array(), 
			'i' => array('class' => array(), 'id' => array()), 
			'iframe' => array('name' => array(), 'seamless' => array(), 'src' => array(), 'srcdoc' => array(), 'width' => array(), 'height' => array(), 'frameborder' => array(), 'allowfullscreen' => array(), 'mozallowfullscreen' => array(), 'webkitallowfullscreen' => array(), 'title' => array()),
			'img' => array('alt' => array(), 'crossorigin' => array(), 'height' => array(), 'ismap' => array(), 'src' => array(), 'usemap' => array(), 'width' => array(), 'title' => array(), 'data-default' => array()),
			'input' => array('align' => array(), 'alt' => array(), 'autocomplete' => array(), 'autofocus' => array(), 'checked' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'height' => array(), 'list' => array(), 'max' => array(), 'maxlength' => array(), 'min' => array(), 'multiple' => array(), 'name' => array(), 'pattern' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'size' => array(), 'src' => array(), 'step' => array(), 'type' => array(), 'value' => array(), 'width' => array(), 'id' => array(), 'class' => array()),
			'ins' => array('cite' => array(), 'datetime' => array()),
			'label' => array('for' => array(), 'form' => array(), 'class' => array()),
			'legend' => array('align' => array()), 
			'li' => array('type' => array(), 'value' => array(), 'class' => array(), 'id' => array()),
			'link' => array('crossorigin' => array(), 'href' => array(), 'hreflang' => array(), 'media' => array(), 'rel' => array(), 'sizes' => array(), 'type' => array()),
			'main' => array(), 
			'map' => array('name' => array()), 
			'mark' => array(), 
			'menu' => array('label' => array(), 'type' => array()),
			'menuitem' => array('checked' => array(), 'command' => array(), 'default' => array(), 'disabled' => array(), 'icon' => array(), 'label' => array(), 'radiogroup' => array(), 'type' => array()),
			'meta' => array('charset' => array(), 'content' => array(), 'http-equiv' => array(), 'name' => array()),
			'object' => array('form' => array(), 'height' => array(), 'name' => array(), 'type' => array(), 'usemap' => array(), 'width' => array()),
			'ol' => array('class' => array(), 'reversed' => array(), 'start' => array(), 'type' => array()),
			'option' => array('value' => array(), 'selected' => array()),
			'p' => array('class' => array()), 
			'q' => array('cite' => array()), 
			'section' => array(), 
			'select' => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'multiple' => array(), 'name' => array(), 'required' => array(), 'size' => array(), 'class' => array()),
			'small' => array(), 
			'source' => array('media' => array(), 'src' => array(), 'type' => array()),
			'span' => array('class' => array()), 
			'strong' => array(),
			'style' => array('media' => array(), 'scoped' => array(), 'type' => array()),
			'sub' => array(),
			'sup' => array(),
			'table' => array('sortable' => array()), 
			'tbody' => array(), 
			'td' => array('colspan' => array(), 'headers' => array()),
			'textarea' => array('autofocus' => array(), 'cols' => array(), 'disabled' => array(), 'form' => array(), 'maxlength' => array(), 'name' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'rows' => array(), 'wrap' => array()),
			'tfoot' => array(),
			'th' => array('abbr' => array(), 'colspan' => array(), 'headers' => array(), 'rowspan' => array(), 'scope' => array(), 'sorted' => array()),
			'thead' => array(), 
			'time' => array('datetime' => array()), 
			'title' => array(), 
			'tr' => array(), 
			'track' => array('default' => array(), 'kind' => array(), 'label' => array(), 'src' => array(), 'srclang' => array()), 
			'u' => array(), 
			'ul' => array('class' => array(), 'id' => array()), 
			'var' => array(), 
			'video' => array('autoplay' => array(), 'controls' => array(), 'height' => array(), 'loop' => array(), 'muted' => array(), 'muted' => array(), 'poster' => array(), 'preload' => array(), 'src' => array(), 'width' => array()), 
			'wbr' => array(),
		);
	
		$data = wp_kses($content, $dt_allowed_html_tags);
		return $data;
		
	}
}

if( !function_exists( 'painting_option' ) ){
	function painting_option($key1, $key2 = '') {
		$options = get_option ( 'painting-options' );
		$output = NULL;
	
		if (is_array ( $options )) {
	
			if (array_key_exists ( $key1, $options )) {
				$output = $options [$key1];
				if (is_array ( $output ) && ! empty ( $key2 )) {
					$output = (array_key_exists ( $key2, $output ) && (! empty ( $output [$key2] ))) ? $output [$key2] : NULL;
				}
			} else {
				$output = $output;
			}
		}
		return $output;
	}
}
?>