jQuery(window).on('load', function(){
	if(jQuery('#appointment-step-checker').val() != 'false') {
		jQuery('#appointment-step').val(1);
	} else {
		jQuery('#appointment-step').val(2);	
	}
});

jQuery(document).ready(function($){
	
	$('#aptdatepicker').datepicker({
		dateFormat : 'yy-mm-dd'
	}); 

	$(".dt-select-service").change(function(){
		var $id = $(this).val(),
			$staffids = $('#staffids').val();
		$.ajax({
			method:'POST',
			url: mytheme_urls.ajaxurl,
			type: 'html',
			data:{ action: 'painting_fill_staffs', service_id :$id, staffids :$staffids },
			complete: function(response){
				if( response.status === 200 ) {
					var $append = "";
					if( $.trim(response.responseText).length > 0 ) {
						$append += response.responseText;
						$(".dt-select-staff").empty().append($append);
					}
				}
			}
		});
	});

	$("body").delegate(".appointment-goback","click",function(e){
		
		$('.steps').hide();
		
		var curr_step_val = $('#appointment-step').val();
		var step_to_show = parseInt(curr_step_val, 10) - 1;
		
		$('.dt-sc-schedule-progress-wrapper .step'+curr_step_val).removeClass('dt-sc-current-step');
		$('.dt-sc-schedule-progress-wrapper .step'+step_to_show).removeClass('dt-sc-completed-step');
		$('.dt-sc-schedule-progress-wrapper .step'+step_to_show).addClass('dt-sc-current-step');
		
		$('.step' + step_to_show).fadeIn(800);
		
		$('#appointment-step').val(step_to_show);
		
		if(step_to_show == 1) {
			$('.dt-sc-goback-box').hide();
		}
		
	});
	
	function calculate_step_value() {
		
		$('.dt-sc-goback-box').show();
		
		var curr_step_val = $('#appointment-step').val();
		var updated_step_val = parseInt(curr_step_val, 10) + 1;
		
		$('.dt-sc-schedule-progress-wrapper .dt-sc-schedule-progress').removeClass('dt-sc-current-step');
		$('.dt-sc-schedule-progress-wrapper .step'+curr_step_val).addClass('dt-sc-completed-step');
		$('.dt-sc-schedule-progress-wrapper .step'+updated_step_val).addClass('dt-sc-current-step');
		
		$('#appointment-step').val(updated_step_val);
		if(updated_step_val == 4 || updated_step_val == 1) { $('.appointment-goback').hide(); }
		
	}
	
	$('form[name="dt-sc-appointment-contactdetails-form"]').on('submit', function () {	
		
		var $firstname = $('#firstname').val();
		var $lastname = $('#lastname').val();
		var $phone = $('#phone').val();
		var $emailid = $('#emailid').val();
		var $address = $('#address').val();
		
		$('#hid_firstname').val($firstname);
		$('#hid_lastname').val($lastname);
		$('#hid_phone').val($phone);
		$('#hid_emailid').val($emailid);
		$('#hid_address').val($address);
		
		var contact_details = '<ul>';
				if($firstname != '') { contact_details += '<li>' + $firstname + ' ' + $lastname + '</li>'; }
				if($phone != '') { contact_details += '<li>' + $phone + '</li>'; }
				if($emailid != '') { contact_details += '<li>' + $emailid + '</li>'; }
				if($address != '') { contact_details += '<li>' + $address + '</li>'; }
			contact_details += '</ul>';
			
		$('#dt-sc-contact-info').html(contact_details);	
		
		$('.dt-sc-contactdetails-box').hide();
		$('.dt-sc-schedule-box').fadeIn(800);
		$('.dt-sc-service-box').show();
		
		calculate_step_value();
		
		return false;

	});

	$("body").delegate(".generate-schedule","click",function(e){
		
		var $serviceid = $('#serviceid').val();
		var $staffid = $('#staffid').val();
		var $staffids = $('#staffids').val();
		var $aptdatepicker = $('#aptdatepicker').val();
		
		$.ajax({
			method:'POST',
			url: mytheme_urls.ajaxurl,
			type: 'html',
			data:{ action: 'painting_generate_schedule', serviceid :$serviceid, staffid :$staffid, staffids :$staffids, aptdatepicker :$aptdatepicker },
			beforeSend: function(){
				$(".dt-sc-timeslot-box").hide();
			},
			complete: function(response){
				$(".appointment-ajax-holder").html(response.responseText);
				$(".dt-sc-timeslot-box").fadeIn(800);
			}
		});
		
	});

	$("body").delegate("a.time-slot","click",function(e){
		
		e.preventDefault();
		
		var $daydate = $(this).data('daydate'),
			$time = $(this).data('time'),
			$service = $('*[name=serviceid] :selected').text(),
			$staff = $(this).data('staffname');
		
		var schedule_details = '<ul>';
				if($daydate != '') { schedule_details += '<li>' + $daydate + '</li>'; }
				if($time != '') { schedule_details += '<li>' + $time + '</li>'; }
				if($service != '') { schedule_details += '<li>' + $service + '</li>'; }
				if($staff != '') { schedule_details += '<li>' + $staff + '</li>'; }
			schedule_details += '</ul>';
			
		$('#dt-sc-schedule-details').html(schedule_details);	
		
		$('.dt-sc-schedule-box').hide();
		$('.dt-sc-aboutproject-box').fadeIn(800);
		
		$("a.time-slot").removeClass('selected');
		$(this).addClass('selected');
		
		$("ul.time-table").find('li,ul.time-slots').removeClass('selected'); 
 		$(this).parentsUntil("ul.time-table").addClass('selected'); 
		
		calculate_step_value();
		
	});
	
	
	$(".dt-sc-about-project-form .schedule-it").click(function(e){
		
		e.preventDefault();

		$staffid = $('a.time-slot.selected').data('staffid');
		$serviceid = $('a.time-slot.selected').data('serviceid');
		$start = $('a.time-slot.selected').data('start');
		$end = $('a.time-slot.selected').data('end');
		$date = $('a.time-slot.selected').data('date');
		$time = $('a.time-slot.selected').data('time');

		$firstname = $(".dt-sc-aboutproject-box #hid_firstname").val();
		$lastname = $(".dt-sc-aboutproject-box #hid_lastname").val();
		$phone = $(".dt-sc-aboutproject-box #hid_phone").val();
		$emailid = $(".dt-sc-aboutproject-box #hid_emailid").val();
		$address = $(".dt-sc-aboutproject-box #hid_address").val();
		
		$about_your_project = $("div.dt-sc-personal-info").find('textarea[name=about_your_project]').val();

		if( $about_your_project.length == "" ){
			alert(dtAppointmentCustom.erAboutYourProject);
			return false;
		}
		
		if($about_your_project != '') { 
			var aboutproject_details = '<ul>';
					aboutproject_details += '<li>' + $about_your_project + '</li>';
				aboutproject_details += '</ul>';
		}
		$('#dt-sc-about-project').html(aboutproject_details);	
		
		if( typeof($start) != 'undefined' ) {
			$.ajax({
				method: 'POST',
				url: 	mytheme_urls.ajaxurl,
				data: 	{ 
					action: "dttheme_new_reservation",
					staffid: $staffid,
					serviceid: $serviceid,
					start: $start,
					end: $end,
					date: $date,
					time: $time,
					
					firstname: $firstname,
					lastname: $lastname,
					phone: $phone,
					emailid: $emailid,
					address: $address,
					
					aboutyourproject: $about_your_project,
				},
				dataType: 'json',
				beforeSend: function(){
					$('#dt-sc-ajax-load-image').show();
				},
				success: function( response ){
					$('.dt-sc-aboutproject-box').hide();
					$('.dt-sc-notification-box').show();
					if(response == 'Success') {
						$('.dt-sc-apt-success-box').fadeIn(800);
					} else {
						$('.dt-sc-apt-error-box').fadeIn(800);
					}
				},
				complete: function(){
					$('#dt-sc-ajax-load-image').hide();
					calculate_step_value();
				} 
			});
		} else {
			$("a.schedule-it").hide();
		}
	});

});