<?php
if ( !class_exists( 'DTStaffPostType' ) ) {

	class DTStaffPostType {

		function __construct() {
			add_action ( 'init', array (
				$this,
				'dt_init'
			) );

			add_action( 'admin_init', array(
				$this,
				'dt_admin_init'
			) );
		}

		function dt_init() {
			$labels = array(
				'name' => esc_html__('Staffs', 'dt_plugins_appointment' ),
				'singular_name' => esc_html__('Staff', 'dt_plugins_appointment' ),
				'menu_name' => esc_html__('Staffs', 'dt_plugins_appointment' ),
				'add_new' => esc_html__('Add Staff', 'dt_plugins_appointment' ),
				'add_new_item' => esc_html__('Add New Staff', 'dt_plugins_appointment' ),
				'edit' => esc_html__('Edit Staff', 'dt_plugins_appointment' ),
				'edit_item' => esc_html__('Edit Staff', 'dt_plugins_appointment' ),
				'new_item' => esc_html__('New Staff', 'dt_plugins_appointment' ),
				'view' => esc_html__('View Staff', 'dt_plugins_appointment' ),
				'view_item' => esc_html__('View Staff', 'dt_plugins_appointment' ),
				'search_items' => esc_html__('Search Staffs', 'dt_plugins_appointment' ),
				'not_found' => esc_html__('No Staffs found', 'dt_plugins_appointment' ),
				'not_found_in_trash' => esc_html__('No Staffs found in Trash', 'dt_plugins_appointment' ),
				'parent_item_colon' => esc_html__('Parent Staff:', 'dt_plugins_appointment' ),
			);

			$args = array(
				'labels' => $labels,
				'hierarchical' => false,
				'description' => esc_html__('This is custom post type staff','dt_plugins_appointment'),
				'supports' => array('title', 'editor', 'thumbnail'),
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'menu_position' => 29,
				'menu_icon' => 'dashicons-businessman',
			);

			register_post_type('dt_staffs', $args );
		}

		function dt_admin_init() {
			add_action ( 'add_meta_boxes', array (
				$this,
				'dt_add_staff_meta_box' 
			) );

			add_action ( 'save_post', array (
				$this,
				'save_staff_post_meta' 
			) );
			
			add_action ( 'pre_post_update', array (
				$this,
				'save_staff_post_meta' 
			) );
			add_filter ( "manage_edit-dt_staffs_columns", array(
				$this,
				"dt_staffs_edit_columns"
			) );

			add_action ( "manage_posts_custom_column", array (
				$this,
				"dt_staffs_columns_display" 
			), 10, 2 );
		}
		
		function dt_staffs_edit_columns( $columns ) {

			$newcolumns = array (
					"cb" => "<input type=\"checkbox\" />",
					"title" => esc_html__("Title",'dt_plugins_appointment'),
					"staff_details" => esc_html__("Details",'dt_plugins_appointment'),
					"author" => esc_html__("Author",'dt_plugins_appointment'),
			);
			$columns = array_merge ( $newcolumns, $columns );
			return $columns;
		}

		function dt_staffs_columns_display( $columns, $id ) {
			global $post;
			switch ($columns) {
				case 'staff_details':
					$info = get_post_meta( $post->ID, "_info", true );
					$info = is_array( $info ) ? $info : array();
					
					$emailid = array_key_exists('emailid', $info) ? $info['emailid'] : "";
					$emailid = !empty($emailid) ?'<p>'. esc_html__("Email Id",'dt_plugins_appointment').' - '.$emailid.'</p>' : "";
					echo painting_wp_kses($emailid);
				break;
			}
		}

		function dt_add_staff_meta_box() {
			add_meta_box( 'dt-staff-service-metabox', esc_html__('Choose Services','dt_plugins_appointment'), array( $this, 'dt_staff_service_metabox'), 'dt_staffs', 'side', 'default'); 
			add_meta_box( 'dt-staff-metabox', esc_html__('Set Personal Information','dt_plugins_appointment'), array( $this, 'dt_staff_metabox'), 'dt_staffs', 'normal',  'default');
			add_meta_box( 'dt-staff-schedule-metabox', esc_html__('Choose Schedule','dt_plugins_appointment'), array( $this, 'dt_staff_schedule_metabox'), 'dt_staffs', 'normal', 'default');	
		}

		function dt_staff_service_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_staff_service_metabox.php';
		}

		function dt_staff_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_staff_metabox.php';
		}

		function dt_staff_schedule_metabox() {
			include_once plugin_dir_path ( __FILE__ ) . 'metaboxes/dt_staff_schedule_metabox.php';
		}

		function save_staff_post_meta( $post_id ) {
			
			if ( ! isset( $_POST['dtappointment_addon_staff_metabox_nonce'] ) || ! isset( $_POST['dtappointment_addon_staff_metabox_nonce'] ) ) {
				return;
			}
		
			if ( ! wp_verify_nonce( $_POST['dtappointment_addon_staff_metabox_nonce'], 'dtappointment_addon_staff_metabox' ) || ! wp_verify_nonce( $_POST['dtappointment_addon_staff_metabox_nonce'], 'dtappointment_addon_staff_metabox' ) ) {
				return;
			}
		
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
		
			if ( isset( $_POST['post_type'] ) && 'dt_staffs' == $_POST['post_type'] ) {
				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {
				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			if ( (key_exists('post_type', $_POST)) && ('dt_staffs' == $_POST['post_type']) ) :
			
				if ( isset($_POST['_info']) ):
					$info = painting_wp_kses(array_unique(array_filter($_POST['_info'])));
					update_post_meta ( $post_id, "_info", array_filter ( $info ) );
				endif;
	
				if (isset($_POST['_timer'])):
					$timer = $_POST['_timer'];
					update_post_meta ( $post_id, "_timer", $timer );
				endif;
	
				if (isset($_POST['_services'])):
					$services = array_unique(array_filter($_POST['_services']));
					update_post_meta ( $post_id, "_services", array_filter ( $services ) );
				endif;
			
			endif;
			
		}
	}
}?>
