<?php 
global $post;
$info = get_post_meta( $post->ID, "_info", true );
$info = is_array( $info ) ? $info : array();

$firstname = array_key_exists( 'firstname', $info ) ? $info['firstname'] : '';
$lastname = array_key_exists( 'lastname', $info ) ? $info['lastname'] : '';
$phone = array_key_exists( 'phone', $info ) ? $info['phone'] : '';
$emailid = array_key_exists( 'emailid', $info ) ? $info['emailid'] : '';
$address = array_key_exists( 'address', $info ) ? $info['address'] : '';
$aboutyourproject = array_key_exists( 'aboutyourproject', $info ) ? $info['aboutyourproject'] : '';

wp_nonce_field( 'dtappointment_addon_customer_metabox', 'dtappointment_addon_customer_metabox_nonce' );
?>
<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'First Name', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <input type="text" name="_info[firstname]" class='regular-text' value="<?php echo esc_attr($firstname);?>">
    </div>
</div>

<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'Last Name', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <input type="text" name="_info[lastname]" class='regular-text' value="<?php echo esc_attr($lastname);?>">
    </div>
</div>

<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'Phone', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <input type="text" name="_info[phone]" class='regular-text' value="<?php echo esc_attr($phone);?>">
	</div>
</div>

<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'Email', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <input type="text" name="_info[emailid]" class='regular-text' value="<?php echo esc_attr($emailid);?>">
    </div>
</div>

<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'Address', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <textarea name="_info[address]" class="large"><?php echo esc_attr($address);?></textarea>
    </div>
</div>

<div class="custom-box">
    <div class="column one-sixth"><?php esc_html_e( 'Tell Us About Your Project', 'dt_plugins_appointment' );?></div>
    <div class="column five-sixth last">
        <textarea name="_info[aboutyourproject]" class="large"><?php echo esc_attr($aboutyourproject);?></textarea>
    </div>
</div>
