<?php 
global $post;
$info = get_post_meta( $post->ID, "_info", true );
$info = is_array( $info ) ? $info : array();

wp_nonce_field( 'dtappointment_addon_services_metabox', 'dtappointment_addon_services_metabox_nonce' );
?>

<div class="custom-box">
	<div class="column one-sixth"><?php esc_html_e( 'Duration', 'dt_plugins_appointment' );?></div>
	<div class="column five-sixth last">
		<select name="_info[duration]">
			<option value=""><?php esc_html_e('Select','dt_plugins_appointment');?></option><?php
			$current = array_key_exists('duration', $info) ? $info['duration'] : "";
			for ( $i = 0; $i < 12; $i++ ) :
				for ( $j = 15; $j <= 60; $j += 15 ) :
					$duration = ( $i * 3600 ) + ( $j * 60 );
					$duration_output = painting_durationtostring( $duration );
					$selected = $current == $duration ? ' selected="selected"' : '';
					echo "<option value='{$duration}' {$selected}>{$duration_output}</option>";
				endfor;
			endfor;?>
		</select>
	</div>
</div>