<?php

global $dt_modules, $dt_animation_types, $woothemes_sensei, $dtthemes_columns;

$dt_animation_types = array("flash" => "flash", "shake" => "shake", "bounce" => "bounce", "tada" => "tada", "swing" => "swing", "wobble" => "wobble", "pulse" => "pulse", "flip" => "flip", "flipInX" => "flipInX", "flipOutX" => "flipOutX", "flipInY" => "flipInY", "flipOutY" => "flipOutY", "fadeIn" => "fadeIn", "fadeInUp" => "fadeInUp", "fadeInDown" => "fadeInDown", "fadeInLeft" => "fadeInLeft", "fadeInRight" => "fadeInRight", "fadeInUpBig" => "fadeInUpBig", "fadeInDownBig" => "fadeInDownBig", "fadeInLeftBig" => "fadeInLeftBig", "fadeInRightBig" => "fadeInRightBig", "fadeOut" => "fadeOut", "fadeOutUp" => "fadeOutUp","fadeOutDown" => "fadeOutDown", "fadeOutLeft" => "fadeOutLeft", "fadeOutRight" => "fadeOutRight", "fadeOutUpBig" => "fadeOutUpBig", "fadeOutDownBig" => "fadeOutDownBig", "fadeOutLeftBig" => "fadeOutLeftBig","fadeOutRightBig" => "fadeOutRightBig", "bounceIn" => "bounceIn", "bounceInUp" => "bounceInUp", "bounceInDown" => "bounceInDown", "bounceInLeft" => "bounceInLeft", "bounceInRight" => "bounceInRight", "bounceOut" => "bounceOut", "bounceOutUp" => "bounceOutUp", "bounceOutDown" => "bounceOutDown", "bounceOutLeft" => "bounceOutLeft", "bounceOutRight" => "bounceOutRight", "rotateIn" => "rotateIn", "rotateInUpLeft" => "rotateInUpLeft", "rotateInDownLeft" => "rotateInDownLeft", "rotateInUpRight" => "rotateInUpRight", "rotateInDownRight" => "rotateInDownRight", "rotateOut" => "rotateOut", "rotateOutUpLeft" => "rotateOutUpLeft","rotateOutDownLeft" => "rotateOutDownLeft", "rotateOutUpRight" => "rotateOutUpRight", "rotateOutDownRight" => "rotateOutDownRight", "hinge" => "hinge", "rollIn" => "rollIn", "rollOut" => "rollOut", "lightSpeedIn" => "lightSpeedIn", "lightSpeedOut" => "lightSpeedOut", "slideDown" => "slideDown", "slideUp" => "slideUp", "slideLeft" => "slideLeft", "slideRight" => "slideRight", "slideExpandUp" => "slideExpandUp", "expandUp" => "expandUp", "expandOpen" => "expandOpen", "bigEntrance" => "bigEntrance", "hatch" => "hatch", "floating" => "floating", "tossing" => "tossing", "pullUp" => "pullUp", "pullDown" => "pullDown", "stretchLeft" => "stretchLeft", "stretchRight" => "stretchRight", "zoomIn" => "zoomIn");

$variations = array('pink' => 'Pink', 'green' => 'Green', 'skyblue' => 'SkyBlue', 'red' => 'Red', 'yellow' => 'Yellow', 'blueturquoise' => 'Blueturquoise', 'blue' => 'Blue');

$accordion_types = $toggle_types = $tabtypes_vertical = array('type2' => 'Type 2');

$newsletter_section_types = $team_types = $animatenum_types = $portfolio_types = array('type2' => 'Type 2', 'type3' => 'Type 3');

$tabtypes_horizontal = $testimonial_carousel_types = array('type2' => 'Type 2', 'type3' => 'Type 3', 'type4' => 'Type 4');

$button_types = array('type2' => 'Type 2', 'type3' => 'Type 3', 'type4' => 'Type 4', 'type5' => 'Type 5', 'type6' => 'Type 6', 'type7' => 'Type 7');

$title_style_types = array('border-title' => 'Border Title', 'border-title2' => 'Border Title 2', 'border-title3' => 'Border Title 3', 'small-title' => 'Small Title', 'medium-title' => 'Medium Title', 'large-title' => 'Large Title');

$button_size = array('small' => 'Small', 'medium' => 'Medium', 'large' => 'Large', 'xlarge' => 'XLarge');

$page_targets = array('_blank' => 'Blank', '_new' => 'New', '_parent' => 'Parent', '_self' => 'Self', '_top' => 'Top');

$box_types = array('titled-box' => 'Titled Box', 'error-box' => 'Error Box', 'warning-box' => 'Warning Box', 'success-box' => 'Success Box', 'info-box' => 'Info Box');

$pullquote_types = array('pullquote1' => 'Pullquote 1', 'pullquote2' => 'Pullquote 2', 'pullquote3' => 'Pullquote 3', 'pullquote4' => 'Pullquote 4', 'pullquote5' => 'Pullquote 5', 'pullquote6' => 'Pullquote 6');

$intro_box_types = array('type2' => 'Type 2', 'type3' => 'Type 3');

$align = array('left' => 'Left', 'right' => 'Right', 'center' => 'Center');

$alignment = array('alignleft' => 'Left', 'alignright' => 'Right', 'aligncenter' => 'Center');

$fullwidthalign = $titlealign = $button_alignment = array('alignleft' => 'Left', 'alignright' => 'Right', 'aligncenter' => 'Center');

$iconbox_align = array('left' => 'Left', 'right' => 'Right');

$yesorno = array('yes' => 'Yes', 'no' => 'No');

$trueorfalse = array('true' => 'True', 'false' => 'False');

$tooltip_positions = array('top' => 'Top', 'right' => 'Right', 'bottom' => 'Bottom', 'left' => 'Left');

$tooltip_types = array('default' => 'Default', 'boxed' => 'Boxed');

$bacground_repeat = array('no-repeat' => 'No Repeat', 'repeat' => 'Repeat', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y');

$bacground_position = array('left top' => 'Left Top', 'left center' => 'Left Center', 'left bottom' => 'Left Bottom', 'right top' => 'Right Top', 'right center' => 'Right Center', 'right bottom' => 'Right Bottom', 'center top' => 'Center Top', 'center center' => 'Center Center', 'center bottom' => 'Center Bottom');

$bacground_attachments = array('scroll' => 'Scroll', 'fixed' => 'Fixed', 'local' => 'Local', 'initial' => 'Initial', 'inherit' => 'Inherit');

$background_size = range(1, 100);

$lengths = $margins = array(5 => 5, 10 => 10, 15 => 15, 20 => 20, 25 => 25, 30 => 30, 35 => 35, 40 => 40, 45 => 45, 50 => 50, 55 => 55, 60 => 60, 65 => 65, 70 => 70, 75 => 75, 80 => 80, 85 => 85, 90 => 90, 95 => 95, 100 => 100);

$post_columns = array(1 => 1, 2 => 2, 3 => 3);

$portfolio_columns = $content_carousel_columns = array(1 => 1, 2 => 2, 3 => 3, 4 => 4);

$product_columns = array(2 => 2, 3 => 3, 4 => 4);

$icon_box_types = array('type2' => 'Type 2', 'type3' => 'Type 3', 'type4' => 'Type 4', 'type5' => 'Type 5', 'type6' => 'Type 6', 'type7' => 'Type 7', 'type8' => 'Type 8', 'type9' => 'Type 9', 'type10' => 'Type 10', 'type11' => 'Type 11', 'type12' => 'Type 12');

$contact_details_type = array('email' => 'Email', 'web' => 'Web');

$oltypes = array('decimal' => 'Decimal', 'decimal-leading-zero' => 'Decimal With Leading Zero', 'lower-alpha' => 'Lower Alpha', 'lower-roman' => 'Lower Roman', 'upper-alpha' => 'Upper Alpha', 'upper-roman' => 'Upper Roman');

$ultypes = array('arrow' => 'Arrow', 'rounded-arrow' => 'Rounded Arrow', 'double-arrow' => 'Double Arrow', 'heart' => 'Heart', 'trash' => 'Trash', 'star' => 'Star', 'tick' => 'Tick', 'rounded-tick' => 'Rounded Tick', 'cross' => 'Cross', 'rounded-cross' => 'Rounded Cross', 'rounded-question' => 'Rounded Question', 'rounded-info' => 'Rounded Info', 'delete' => 'Delete', 'warning' => 'Warning', 'comment' => 'Comment', 'edit' => 'Edit', 'share' => 'Share', 'plus' => 'Plus', 'rounded-plus' => 'Rounded Plus', 'minus' => 'Minus', 'rounded-minus' => 'Rounded Minus', 'asterisk' => 'Asterisk', 'cart' => 'Cart', 'folder' => 'Folder', 'folder-open' => 'Folder Open', 'desktop' => 'Desktop', 'tablet' => 'Tablet', 'mobile' => 'Mobile', 'reply' => 'Reply', 'quote' => 'Quote', 'mail' => 'Mail', 'external-link' => 'External Link', 'adjust' => 'Adjust', 'pencil' => 'Pencil', 'print' => 'Print', 'tag' => 'Tag', 'thumbs-up' => 'Thumbs Up', 'thumbs-down' => 'Thumbs Down', 'time' => 'Time', 'globe' => 'Globe', 'pushpin' => 'Pushpin', 'map-marker' => 'Map Marker', 'link' => 'Link', 'paper-clip' => 'Paper Clip', 'download' => 'Download', 'key' => 'Key', 'search' => 'Search', 'rss' => 'Rss', 'twitter' => 'Twitter', 'facebook' => 'Facebook', 'linkedin' => 'Linkedin', 'google-plus' => 'Google Plus', 'caret-down' => 'Caret Down', 'caret-left' => 'Caret Left', 'caret-right' => 'Caret Right', 'caret-up' => 'Caret Up', 'file-text' => 'File Text', 'angle-double-right' => 'Angle Double Right', 'hand-o-right' => 'Hand O Right', 'gavel' => 'Gavel', 'book' => 'Book', 'check-circle' => 'Check Circle', 'sun-o' => 'Sun', 'slack' => 'Slack', 'circle-tick' => 'Circle Tick');

$fullwidth_types = array('color-overlay' => 'Color Overlay', 'half-overlay' => 'Gradient (Left to Right)', 'half-overlay-top-bottom' => 'Gradient (Top to Bottom)', 'diagonal-gradient' => 'Diagonal Gradient', 'radial-gradient' => 'Radial Gradient', 'skin-color-overlay' => 'Skin Color Overlay', 'grey' => 'Grey Background', 'origin-bottom-image' => 'Origin Bottom Image', 'origin-top-image' => 'Origin Top Image', 'half-overlay-bg-content' => 'Half overlay Background Content', 'bgimage-with-bgcolor' => 'Background Image With Background Color');

$title_types = array('h1' => 'H1', 'h2' => 'H2', 'h3' => 'H3', 'h4' => 'H4', 'h5' => 'H5', 'h6' => 'H6');

$sociables =  array('fa-delicious' => 'delicious', 'fa-deviantart' => 'deviantart', 'fa-digg' => 'digg', 'fa-facebook' => 'facebook', 'fa-facebook-square' => 'facebooksquare', 'fa-twitter' => 'twitter', 'fa-google-plus' => 'googleplus', 'fa-google' => 'google', 'fa-weibo' => 'weibo', 'fa-pinterest' => 'pinterest', 'fa-reddit' => 'reddit', 'fa-behance' => 'behance', 'fa-yahoo' => 'yahoo', 'fa-vimeo-square' => 'vimeosquare', 'fa-stumbleupon' => 'stumbleupon', 'fa-linkedin' => 'linkedin', 'fa-skype' => 'skype', 'fa-youtube' => 'youtube', 'fa-dribbble' => 'dribbble', 'fa-flickr' => 'flickr', 'fa-tumblr' => 'tumblr', 'fa-instagram' => 'instagram');

$popupvideo_types = array('selfhosted' => 'Self Hosted Video', 'embedvideo' => 'Embed Video');


$post_cat = array();
$cats = get_categories('hide_empty=0');
foreach($cats as $cat) {
	if(function_exists('icl_object_id')) {
		if($cat->term_id == icl_object_id($cat->term_id, 'category', false, ICL_LANGUAGE_CODE)){
			$post_cat[$cat->term_id] = esc_html ( $cat->name );
		}
	} else {
		$post_cat[$cat->term_id] = esc_html ( $cat->name );
	}
}

$orderby = array('none' => 'none', 'ID' => 'ID', 'author' => 'author', 'title' => 'title', 'name' => 'name', 'type' => 'type', 'date' => 'date', 'modified' => 'modified', 'parent' => 'parent', 'rand' => 'rand', 'comment_count' => 'comment_count', 'menu_order' => 'menu_order', 'meta_value' => 'meta_value', 'meta_value_num' => 'meta_value_num', 'post__in' => 'post__in');
$order = array('asc' => 'ASC', 'desc' => 'DESC');

$border_styles = array('solid' => 'Solid', 'dashed' => 'Dashed', 'dotted' => 'Dotted', 'inset' => 'Inset', 'outset' => 'Outset', 'groove' => 'Groove', 'ridge' => 'Ridge', 'double' => 'Double'); 

$column_types = array('' => 'Type 1 ( With Space )', 'type2' => 'Type 2 ( Without Space )');


/*  Start of Columns Definition */

$options = array(
			'type' => array(
				'title' => esc_html__('Type', 'dt_plugins'),
				'type' => 'select',
				'options' => $column_types,
				'default_value' => array(),
			),
			'bgimageurl' => array(
				'title' => esc_html__('Background Image URL', 'dt_plugins'),
				'type' => 'upload',
				'default_value' => ''
			),
			'bgimagerepeat' => array(
				'title' => esc_html__('Background Image Repeat', 'dt_plugins'),
				'type' => 'select',
				'options' => $bacground_repeat,
				'default_value' => array()
			),
			'bgimageposition' => array(
				'title' => esc_html__('Background Image Position', 'dt_plugins'),
				'type' => 'select',
				'options' => $bacground_position,
				'default_value' => array()
			),
			'bgcolor' => array(
				'title' => esc_html__('Background Color', 'dt_plugins'),
				'type' => 'colorpicker',
				'default_value' => '',
			),
			'bgcoloropacity' => array(
				'title' => esc_html__('Background Color Opacity', 'dt_plugins'),
				'type' => 'text',
				'default_value' => '',
			),
			'borderwidth' => array(
				'title' => esc_html__('Border Width (ex. 1px 2px 3px 4px)', 'dt_plugins'),
				'type' => 'text',
				'default_value' => ''
			),
			'borderstyle' => array(
				'title' => esc_html__('Border Style', 'dt_plugins'),
				'type' => 'select',
				'options' => $border_styles,
				'default_value' => array()
			),
			'bordercolor' => array(
				'title' => esc_html__('Border Color', 'dt_plugins'),
				'type' => 'colorpicker',
			),
			'borderradius' => array(
				'title' => esc_html__('Border Radius (ex. 1px 2px 3px 4px)', 'dt_plugins'),
				'type' => 'text',
				'default_value' => ''
			),
			'textcolor' => array(
				'title' => esc_html__('Text Color', 'dt_plugins'),
				'type' => 'colorpicker',
			),
			'padding' => array(
				'title' => esc_html__('Padding (ex. 1px 2px 3px 4px)', 'dt_plugins'),
				'type' => 'text',
				'default_value' => ''
			),
			'alignment' => array(
				'title' => esc_html__('Alignment', 'dt_plugins'),
				'type' => 'select',
				'options' => $fullwidthalign,
				'default_value' => array()
			),
			'animation' => array(
				'title' => esc_html__('Animation', 'dt_plugins'),
				'type' => 'select',
				'options' => $dt_animation_types,
				'default_value' => array()
			),
			'animation_delay' => array(
				'title' => esc_html__('Animation Delay', 'dt_plugins'),
				'type' => 'text',
				'default_value' => ''
			),
			'class' => array(
				'title' => esc_html__('CSS Class', 'dt_plugins'),
				'type' => 'text',
				'default_value' => ''
			)
		);

$dtthemes_columns['one_column'] = array( 
		'name' => esc_html__('1 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);

$dtthemes_columns['one_half'] = array( 
		'name' => esc_html__('1/2 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['one_third'] = array( 
		'name' => esc_html__('1/3 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['one_fourth'] = array( 
		'name' => esc_html__('1/4 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['one_fifth'] = array( 
		'name' => esc_html__('1/5 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['one_sixth'] = array( 
		'name' => esc_html__('1/6 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['two_third'] = array( 
		'name' => esc_html__('2/3 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['two_fifth'] = array( 
		'name' => esc_html__('2/5 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['two_sixth'] = array( 
		'name' => esc_html__('2/6 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['three_fourth'] = array( 
		'name' => esc_html__('3/4 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['three_fifth'] = array( 
		'name' => esc_html__('3/5 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['three_sixth'] = array( 
		'name' => esc_html__('3/6 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['four_fifth'] = array( 
		'name' => esc_html__('4/5 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['four_sixth'] = array( 
		'name' => esc_html__('4/6 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['five_sixth'] = array( 
		'name' => esc_html__('5/6 Column', 'dt_plugins'),
		'type' => 'column',
		'options' => $options,
	);
$dtthemes_columns['resizable'] = array( 
		'name' => esc_html__('Resizable Column', 'dt_plugins') ,
		'type' => 'column',
		'options' => $options,
	);
unset($dtthemes_columns['resizable']['options']['type']);


$dtthemes_columns['fullwidth_section'] = array( 
	'name' => esc_html__('Fullwidth Section', 'dt_plugins'),
	'type' => 'section',
	'separatecolumns' => 'true',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $fullwidth_types,
			'default_value' => array(),
			'depand' => 'true',
		),
		'videosrc' => array(
			'title' => esc_html__('Video Source (mp4, m4v, webm, ogv, wmv, flv)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
		),
		'videowidth' => array(
			'title' => esc_html__('Video Width', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
		),
		'videoheight' => array(
			'title' => esc_html__('Video Height', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
		),
		'backgroundimage' => array(
			'title' => esc_html__('Background Image 1', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'backgroundrepeat' => array(
			'title' => esc_html__('Background Image 1 Repeat', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_repeat,
			'default_value' => array()
		),
		'backgroundposition' => array(
			'title' => esc_html__('Background Image 1 Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_position,
			'default_value' => array()
		),
		'backgroundattachment' => array(
			'title' => esc_html__('Background Image 1 Attachment', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_attachments,
			'default_value' => array()
		),
		'backgroundsize' => array(
			'title' => esc_html__('Background Image 1 Size', 'dt_plugins'),
			'type' => 'select',
			'options' => $background_size,
			'default_value' => array()
		),
		'backgroundparallax' => array(
			'title' => esc_html__('Background Image 1 Parallax', 'dt_plugins'),
			'type' => 'select',
			'options' => $yesorno,
			'default_value' => array()
		),
		'backgroundcolor' => array(
			'title' => esc_html__('Background Color 1', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '',
			'depand_on' => array('value' => array('select', 'color-overlay', 'half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient', 'origin-bottom-image', 'origin-top-image', 'bgimage-with-bgcolor'))
		),
		'opacity' => array(
			'title' => esc_html__('Background Color 1 Opacity', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
			'depand_on' => array('value' => array('select', 'color-overlay', 'half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient', 'origin-bottom-image', 'origin-top-image', 'bgimage-with-bgcolor'))
		),
		'backgroundcolorsecondary' => array(
			'title' => esc_html__('Background Color 2', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '',
			'depand_on' => array('value' => array('half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient'))
		),
		'opacitysecondary' => array(
			'title' => esc_html__('Background Color 2 Opacity', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
			'depand_on' => array('value' => array('half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient'))
		),
		'backgroundimagesecondary' => array(
			'title' => esc_html__('Background Image 2', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'backgroundrepeatsecondary' => array(
			'title' => esc_html__('Background Image 2 Repeat', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_repeat,
			'default_value' => array()
		),
		'backgroundpositionsecondary' => array(
			'title' => esc_html__('Background Image 2 Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_position,
			'default_value' => array()
		),
		'backgroundparallaxsecondary' => array(
			'title' => esc_html__('Background Image 2 Parallax', 'dt_plugins'),
			'type' => 'select',
			'options' => $yesorno,
			'default_value' => array()
		),
		'padding' => array(
			'title' => esc_html__('Padding (ex. 1px 2px 3px 4px)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'textcolor' => array(
			'title' => esc_html__('Text Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'topbordercolor' => array(
			'title' => esc_html__('Top Border Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'bottombordercolor' => array(
			'title' => esc_html__('Bottom Border Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'gradientvalue' => array(
			'title' => esc_html__('Gradient Value (ex. 50)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
			'depand_on' => array('value' => array('half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient'))
		),
		'gradientvaluesecondary' => array(
			'title' => esc_html__('Gradient Value (Secondary) (ex. 50)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
			'depand_on' => array('value' => array('half-overlay', 'half-overlay-top-bottom', 'diagonal-gradient', 'radial-gradient'))
		),
		'gradientdegree' => array(
			'title' => esc_html__('Diagonal Gradient Degree (ex. 100)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
			'depand_on' => array('value' => array('diagonal-gradient'))
		),
		'radialgradientposition' => array(
			'title' => esc_html__('Radial Gradient Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_position,
			'default_value' => array(),
			'depand_on' => array('value' => array('radial-gradient'))
		),
		'applywhitecolor' => array(
			'title' => esc_html__('Apply White Color', 'dt_plugins'),
			'type' => 'select',
			'options' => $yesorno,
			'default_value' => array()
		),
		'align' => array(
			'title' => esc_html__('Content Alignment', 'dt_plugins'),
			'type' => 'select',
			'options' => $fullwidthalign,
			'default_value' => array()
		),
		'disablecontainer' => array(
			'title' => esc_html__('Disable Container', 'dt_plugins'),
			'type' => 'select',
			'options' => $yesorno,
			'default_value' => array()
		),
		'responsivecolumn' => array(
			'title' => esc_html__('Responsive - Fullwidth Column', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'responsivealigncenter' => array(
			'title' => esc_html__('Responsive - Aligncenter', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('CSS Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		)
	)
);

/*  End of Columns definition */


/*  Start of General Modules */

$dt_modules['general']['doshortcode_anycontent'] = array(
	'name' => esc_html__('Add Any Content', 'dt_plugins'),
	'tooltip' => 'Add any content using this module',
	'icon_class' => 'ico-anycontent',
	'options' => array(
		'acc_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.'
		)
	)
);
											 
$dt_modules['general']['accordion_group'] = array(
	'name' => esc_html__('Accordion', 'dt_plugins'),
	'tooltip' => 'Add Accordion Module',
	'icon_class' => 'ico-accordion',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $accordion_types,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'ac_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_accordion_frame title="Accordion 1"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_accordion_frame]<br>
							[dt_sc_accordion_frame title="Accordion 2"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_accordion_frame]<br>
							[dt_sc_accordion_frame title="Accordion 3"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_accordion_frame]'
		)
	)
);

$dt_modules['general']['animation'] = array(
	'name' => esc_html__('Animation', 'dt_plugins'),
	'tooltip' => 'Add Animation effect for any content',
	'icon_class' => 'ico-animation',
	'options' => array(
		'effect' => array(
			'title' => esc_html__('Choose Effect', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array('fadeInUp')
		),
		'delay' => array(
			'title' => esc_html__('Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 400
		),
		'animation_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Add any content here for animation.'
		)
	)
);

$dt_modules['general']['button'] = array(
	'name' => esc_html__('Button', 'dt_plugins'),
	'tooltip' => 'Add Button',
	'icon_class' => 'ico-button',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $button_types,
			'default_value' => array()
		),
		'icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-home'
		),
		'size' => array(
			'title' => esc_html__('Size', 'dt_plugins'),
			'type' => 'select',
			'options' => $button_size,
			'default_value' => array('medium')
		),
		'link' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'target' => array(
			'title' => esc_html__('Target', 'dt_plugins'),
			'type' => 'select',
			'options' => $page_targets,
			'default_value' => array('_blank')
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'align' => array(
			'title' => esc_html__('Alignment', 'dt_plugins'),
			'type' => 'select',
			'options' => $button_alignment,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'button_content' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'is_content' => true,
			'default_value' => 'Sample Button'
		),
	)
);

$dt_modules['general']['blockquote'] = array(
	'name' => esc_html__('Blockquote', 'dt_plugins'),
	'tooltip' => 'Add Blockquote',
	'icon_class' => 'ico-blockquote',
	'options' => array(
		'textcolor' => array(
			'title' => esc_html__('Text Color', 'dt_plugins'),
			'type' => 'colorpicker'
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'blockquote_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
		)
	)
);

$dt_modules['general']['contact_details'] = array(
	'name' => esc_html__('Contact Details', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to contact details.', 'dt_plugins'),
	'icon_class' => 'ico-address',
	'options' => array(
		'text' => array(
			'title' => esc_html__('Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'admin@wedesignthemes.com'
		),
		'icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-envelope-o'
		),
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $contact_details_type,
			'default_value' => array()
		),
	)
);

$dt_modules['general']['contact_info'] = array(
	'name' => esc_html__('Contact Info', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to contact info.', 'dt_plugins'),
	'icon_class' => 'ico-address',
	'options' => array(
		'icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-phone'
		),
		'text1' => array(
			'title' => esc_html__('Text 1', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'call us @'
		),
		'text2' => array(
			'title' => esc_html__('Text 2', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '922-weclean-3325'
		),
	)
);

$dt_modules['general']['support_info'] = array(
	'name' => esc_html__('Support Info', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to support info.', 'dt_plugins'),
	'icon_class' => 'ico-address',
	'options' => array(
		'icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-envelope'
		),
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Request a Quote'
		),
		'link' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
	)
);

$dt_modules['general']['contact_form_wrapper'] = array(
	'name' => esc_html__('Contact Form Wrapper', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to contact form wrapper.', 'dt_plugins'),
	'icon_class' => 'ico-address',
	'options' => array(
		'cf_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_title type="h3" bold="true"]SEND US A MESSAGE[/dt_sc_title]
								[contact-form-7 id="3366" title="Contact Form"]
								[dt_sc_one_third first type="type2"]
								[dt_sc_contact_info icon="fa-phone" text1="call us @" text2="922-weclean-3325" /]
								[/dt_sc_one_third]
								[dt_sc_one_third type="type2"][/dt_sc_one_third]
								[dt_sc_one_third type="type2"]
								[dt_sc_contact_info icon="fa-pencil" text1="write us @" text2="admin@enzo.com" /]
								[/dt_sc_one_third]'
		)
	)
);

$dt_modules['general']['colored_box'] = array(
	'name' => esc_html__('Colored Box', 'dt_plugins'),
	'tooltip' => 'Add the colored box',
	'icon_class' => 'ico-iconbox-colored',
	'options' => array(
		'icon' => array(
			'title' => esc_html__('Fontawesome Icons', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-home'
		),
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Well Trained Professionals'
		),
		'backgroundcolor' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'button_title' => array(
			'title' => esc_html__('Button Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Know More'
		),
		'button_link' => array(
			'title' => esc_html__('Button Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'cb_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam quis placerat urna. Nulla nulla diam, adipiscing non ornare non, commodo'
		)
	)
);

$dt_modules['general']['image'] = array(
	'name' => esc_html__('Image', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add image', 'dt_plugins'),
	'icon_class' => 'ico-image',
	'options' => array(
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'src' => array(
			'title' => esc_html__('Source', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['general']['intro_box'] = array(
	'name' => esc_html__('Intro Box', 'dt_plugins'),
	'tooltip' => 'Add the intro box here',
	'icon_class' => 'ico-callout',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $intro_box_types,
			'default_value' => array()
		),
		'background_image' => array(
			'title' => esc_html__('Background Image', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'background_position' => array(
			'title' => esc_html__('Background Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_position,
			'default_value' => array()
		),
		'background_repeat' => array(
			'title' => esc_html__('Background Repeat', 'dt_plugins'),
			'type' => 'select',
			'options' => $bacground_repeat,
			'default_value' => array()
		),
		'background_color' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'animation' => array(
			'title' => esc_html__('Animation', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Animation Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text'
		),
		'cb_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_title type="h2" bold="true"]WINNER OF GOLDEN AWARD 2015[/dt_sc_title]
								<p> <a href="#" class="dt-sc-rating"> </a> </p>
								[dt_sc_margin margin="20" /]
								[dt_sc_image title="" src="https://placeholdit.imgix.net/~text?txtsize=33&txt=260%C3%97205&w=260&h=205" class="" /]
								[dt_sc_margin margin="20" /]
								<p> Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut</p>
								<p> laoreet dolore. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam </p> 
								<p> ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. </p>'
		)
	)
);

$dt_modules['general']['fancy_ol'] = array(
	'name' => esc_html__('Ordered Lists', 'dt_plugins'),
	'tooltip' => 'Add items in ordered list',
	'icon_class' => 'ico-orderedlists',
	'options' => array(
		'style' => array(
			'title' => esc_html__('Style', 'dt_plugins'),
			'type' => 'select',
			'options' => $oltypes,
			'default_value' => array('decimal')
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'ol_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ol>
							<li>Lorem ipsum dolor sit</li>
							<li>Praesent convallis nibh</li>
							<li>Nullam ac sapien sit</li>
							<li>Phasellus auctor augue</li>
						</ol>'
		)
	)
);

$dt_modules['general']['pullquote'] = array(
	'name' => esc_html__('Pullquote', 'dt_plugins'),
	'tooltip' => 'Add different types of pullquotes',
	'icon_class' => 'ico-quote',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $pullquote_types,
			'default_value' => array('pullquote1')
		),
		'align' => array(
			'title' => esc_html__('Align', 'dt_plugins'),
			'type' => 'select',
			'options' => $align,
			'default_value' => array('left')
		),
		'textcolor' => array(
			'title' => esc_html__('Text Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'pq_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
		)
	)
);

$dt_modules['general']['pricing_table_item'] = array(
	'name' => esc_html__('Pricing Table', 'dt_plugins'),
	'tooltip' => 'Add pricing table',
	'icon_class' => 'ico-pricingtable',
	'options' => array(
		'heading' => array(
			'title' => esc_html__('Heading', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Single Visit'
		),
		'price' => array(
			'title' => esc_html__('Price', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '$50.00'
		),
		'price_text' => array(
			'title' => esc_html__('Price Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Per Visit'
		),
		'note' => array(
			'title' => esc_html__('Note', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Extra charges are based on extra &lt;br/&gt; work taken.'
		),
		'button_link' => array(
			'title' => esc_html__('Button Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'button_text' => array(
			'title' => esc_html__('Button Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Buy Service'
		),
		'button_size' => array(
			'title' => esc_html__('Button Size', 'dt_plugins'),
			'type' => 'select',
			'options' => $button_size,
			'default_value' => array()
		),
		'selected' => array(
			'title' => esc_html__('Selected', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'pt_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ul>
									<li> 4 members </li>
									<li> Equipped workforce </li>
									<li> 2 day time limit </li>
									<li> 14 hr service </li>
								</ul>'
		)
	)
);


$dt_modules['general']['progressbar'] = array(
	'name' => esc_html__('Progress Bar', 'dt_plugins'),
	'tooltip' => 'Add different types of progres bar',
	'icon_class' => 'ico-progressbar',
	'options' => array(
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'House hold cleaning'
		),
		'value' => array(
			'title' => esc_html__('Value', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 80
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'animation' => array(
			'title' => esc_html__('Animation', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Animation Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['general']['patners_carousel'] = array(
	'name' => esc_html__('Patners Carousel', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add patners carousel', 'dt_plugins'),
	'icon_class' => 'ico-clients',
	'options' => array(
		'pc_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ul>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 1" title="Patner 1"/></a></li>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 2" title="Patner 2"/></a></li>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 3" title="Patner 3"/></a></li>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 4" title="Patner 4"/></a></li>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 5" title="Patner 5"/></a></li>
									<li><a href="#"><img src="https://placeholdit.imgix.net/~text?txtsize=33&txt=155%C3%97121&w=155&h=121" alt="Patner 6" title="Patner 6"/></a></li>
								</ul>'
		)
	)
);


$dt_modules['general']['titled_box'] = array(
	'name' => esc_html__('Titled Box', 'dt_plugins'),
	'tooltip' => 'Add titled box and different types of message box',
	'icon_class' => 'ico-box',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $box_types,
			'default_value' => array('titled-box')
		),
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Title Comes Here'
		),
		'icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-cogs'
		),
		'bgcolor' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker'
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'textcolor' => array(
			'title' => esc_html__('Text Color', 'dt_plugins'),
			'type' => 'colorpicker'
		),
		'box_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra per inceptos himenaeos.,'
		)
	)
);

$dt_modules['general']['tooltip'] = array(
	'name' => esc_html__('Tooltip', 'dt_plugins'),
	'tooltip' => 'Add tooltip with different positions',
	'icon_class' => 'ico-tooltip',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $tooltip_types,
			'default_value' => array('default')
		),
		'position' => array(
			'title' => esc_html__('Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $tooltip_positions,
			'default_value' => array('top')
		),
		'bgcolor' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker'
		),
		'textcolor' => array(
			'title' => esc_html__('Text Color', 'dt_plugins'),
			'type' => 'colorpicker'
		),
		'tooltip' => array(
			'title' => esc_html__('Tooltip Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Consectetur adipisicing elit'
		),
		'href' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'target' => array(
			'title' => esc_html__('Target', 'dt_plugins'),
			'type' => 'select',
			'options' => $page_targets,
			'default_value' => array('_blank')
		),
		'tp_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'text',
			'is_content' => true,
			'default_value' => 'Lorem ipsum'
		)
	)
);

$dt_modules['general']['team'] = array(
	'name' => esc_html__('Team', 'dt_plugins'),
	'tooltip' => 'Add team module here.',
	'icon_class' => 'ico-team',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $team_types,
			'default_value' => array()
		),
		'image' => array(
			'title' => esc_html__('Image', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'name' => array(
			'title' => esc_html__('Name', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Marc Coppolo'
		),
		'role' => array(
			'title' => esc_html__('Role', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Plumper'
		),
		'link' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'tm_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one.'
		)
	)
);

$sel_sociables =  array('fa-deviantart', 'fa-facebook-square', 'fa-google-plus', 'fa-pinterest', 'fa-behance');
foreach ( $sociables as $sociable_key => $sociable ) {
	if(in_array($sociable_key, $sel_sociables)) $default_value = '#'; else $default_value = '';
	$dt_modules['general']['team']['options'][$sociable] = array(
			'title' => ucfirst($sociable),
			'type' => 'text',
			'default_value' => $default_value
		);
}

$dt_modules['general']['team_carousel'] = array(
	'name' => esc_html__('Team Carousel', 'dt_plugins'),
	'tooltip' => 'Add team carousel module here.',
	'icon_class' => 'ico-team',
	'options' => array(
		'tc_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_one_fourth type =" type1"]<br>
								[dt_sc_team type="" image="" name="Marc Coppolo " role="Plumper" link="#" delicious="" deviantart="#" digg="" facebook="" facebooksquare="#" twitter="" googleplus="#" google="" weibo="" pinterest="#" reddit="" behance="#" yahoo="" vimeosquare="" stumbleupon="" linkedin="" skype="" youtube="" dribbble="" flickr="" tumblr=""]Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one. It was popularised in the 1960s with the release of Letraset sheets Lorem.[/dt_sc_team]<br>
								[/dt_sc_one_fourth]<br>
								[dt_sc_one_fourth type =" type1"]<br>
								[dt_sc_team type="" image="" name="Marc Coppolo " role="Plumper" link="#" delicious="" deviantart="#" digg="" facebook="" facebooksquare="#" twitter="" googleplus="#" google="" weibo="" pinterest="#" reddit="" behance="#" yahoo="" vimeosquare="" stumbleupon="" linkedin="" skype="" youtube="" dribbble="" flickr="" tumblr=""]Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one. It was popularised in the 1960s with the release of Letraset sheets Lorem.[/dt_sc_team]<br>
								[/dt_sc_one_fourth]<br>
								[dt_sc_one_fourth type =" type1"]<br>
								[dt_sc_team type="" image="" name="Marc Coppolo " role="Plumper" link="#" delicious="" deviantart="#" digg="" facebook="" facebooksquare="#" twitter="" googleplus="#" google="" weibo="" pinterest="#" reddit="" behance="#" yahoo="" vimeosquare="" stumbleupon="" linkedin="" skype="" youtube="" dribbble="" flickr="" tumblr=""]Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one. It was popularised in the 1960s with the release of Letraset sheets Lorem.[/dt_sc_team]<br>
								[/dt_sc_one_fourth]<br>
								[dt_sc_one_fourth type =" type1"]<br>
								[dt_sc_team type="" image="" name="Marc Coppolo " role="Plumper" link="#" delicious="" deviantart="#" digg="" facebook="" facebooksquare="#" twitter="" googleplus="#" google="" weibo="" pinterest="#" reddit="" behance="#" yahoo="" vimeosquare="" stumbleupon="" linkedin="" skype="" youtube="" dribbble="" flickr="" tumblr=""]Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one. It was popularised in the 1960s with the release of Letraset sheets Lorem.[/dt_sc_team]<br>
								[/dt_sc_one_fourth]<br>
								[dt_sc_one_fourth type =" type1"]<br>
								[dt_sc_team type="" image="" name="Marc Coppolo " role="Plumper" link="#" delicious="" deviantart="#" digg="" facebook="" facebooksquare="#" twitter="" googleplus="#" google="" weibo="" pinterest="#" reddit="" behance="#" yahoo="" vimeosquare="" stumbleupon="" linkedin="" skype="" youtube="" dribbble="" flickr="" tumblr=""]Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old this is the larger one. It was popularised in the 1960s with the release of Letraset sheets Lorem.[/dt_sc_team]<br>
								[/dt_sc_one_fourth]<br>'
		)
	)
);

$dt_modules['general']['tabs_horizontal'] = array(
	'name' => esc_html__('Tabs - Horizontal', 'dt_plugins'),
	'tooltip' => 'Add horizontal tabs',
	'icon_class' => 'ico-tabs',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $tabtypes_horizontal,
			'default_value' => array()
		),
		'animation' => array(
			'title' => esc_html__('Animation Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'th_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_tab title="Tab 1" icon="fa-home"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]<br>
							[dt_sc_tab title="Tab 2" icon="fa-eye"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]<br>
							[dt_sc_tab title="Tab 3" icon="fa-bolt"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]'
		)
	)
);

$dt_modules['general']['tabs_vertical'] = array(
	'name' => esc_html__('Tabs Vertical', 'dt_plugins'),
	'tooltip' => 'Add vertical tabs',
	'icon_class' => 'ico-tabs',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $tabtypes_vertical,
			'default_value' => array()
		),
		'animation' => array(
			'title' => esc_html__('Animation Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'tv_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_tab title="Tab 1"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]<br>
							[dt_sc_tab title="Tab 2"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]<br>
							[dt_sc_tab title="Tab 3"]<br>
							
							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.<br>
							
							[/dt_sc_tab]'
		)
	)
);

$dt_modules['general']['toggle_group'] = array(
	'name' => esc_html__('Toggle', 'dt_plugins'),
	'tooltip' => 'Add Toggle Module',
	'icon_class' => 'ico-toggle',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $toggle_types,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'tg_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_toggle_frame title="Toggle 1"]<br>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora  torquent per conubia nostra, per inceptos himenaeos.<br>[/dt_sc_toggle_frame]<br>
								[dt_sc_toggle_frame title="Toggle 1"]<br>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora  torquent per conubia nostra, per inceptos himenaeos.<br>[/dt_sc_toggle_frame]<br>
								[dt_sc_toggle_frame title="Toggle 1"]<br>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi hendrerit elit turpis, a porttitor tellus sollicitudin at. Class aptent taciti sociosqu ad litora  torquent per conubia nostra, per inceptos himenaeos.<br>[/dt_sc_toggle_frame]<br>'
		)
	)
);

$dt_modules['general']['testimonial'] = array(
	'name' => esc_html__('Testimonial', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add testimonial', 'dt_plugins'),
	'icon_class' => 'ico-testimonial',
	'options' => array(
		'name' => array(
			'title' => esc_html__('Name', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Name Comes Here'
		),
		'image' => array(
			'title' => esc_html__('Image', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'cite' => array(
			'title' => esc_html__('Cite', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Business'
		),
		'cite2' => array(
			'title' => esc_html__('Cite2', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Prime Industry'
		),
		'tm_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore. Phasellus viverra nulla ut metus varius laoreet rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. sem quam semper libero, sit amet adipiscing sem neque sed ipsum.'
		)
	)
);

$dt_modules['general']['testimonial_carousel'] = array(
	'name' => esc_html__('Testimonial Carousel', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add testimonial carousel', 'dt_plugins'),
	'icon_class' => 'ico-testimonial',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $testimonial_carousel_types,
			'default_value' => array()
		),
		'tmc_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ul>
									<li>[dt_sc_testimonial name="Sarah Mitchell" image="" cite="Business" cite2="Prime Industry"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore. Phasellus viverra nulla ut metus varius laoreet rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. sem quam semper libero, sit amet adipiscing sem neque sed ipsum.[/dt_sc_testimonial]</li>
									<li>[dt_sc_testimonial name="Sarah Mitchell" image="" cite="Business" cite2="Prime Industry"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore. Phasellus viverra nulla ut metus varius laoreet rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. sem quam semper libero, sit amet adipiscing sem neque sed ipsum.[/dt_sc_testimonial]</li>
									<li>[dt_sc_testimonial name="Sarah Mitchell" image="" cite="Business" cite2="Prime Industry"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore. Phasellus viverra nulla ut metus varius laoreet rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. sem quam semper libero, sit amet adipiscing sem neque sed ipsum.[/dt_sc_testimonial]</li>
								</ul>'
		)
	)
);

$dt_modules['general']['fancy_ul'] = array(
	'name' => esc_html__('Unordered Lists', 'dt_plugins'),
	'tooltip' => 'Add items in unordered lists',
	'icon_class' => 'ico-unorderedlists',
	'options' => array(
		'style' => array(
			'title' => esc_html__('Style', 'dt_plugins'),
			'type' => 'select',
			'options' => $ultypes,
			'default_value' => array('arrow')
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text'
		),
		'ul_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ul>
									<li>Lorem ipsum dolor sit</li>
									<li>Praesent convallis nibh</li>
									<li>Nullam ac sapien sit</li>
									<li>Phasellus auctor augue</li>
								</ul>'
		)
	)
);

/*  End of General Modules */


/*  Start of Unique Modules */

$dt_modules['unique']['animate_number'] = array(
	'name' => esc_html__('Animate Number', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add number animation box.', 'dt_plugins'),
	'icon_class' => 'ico-number',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $animatenum_types,
			'default_value' => array()
		),
		'fontawesome_icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'stroke_icon' => array(
			'title' => esc_html__('Stoke Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'custom_image' => array(
			'title' => esc_html__('Custom Icon URL', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'number' => array(
			'title' => esc_html__('Number', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '4538'
		),
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Hostings Done'
		),
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
	)
);

$dt_modules['unique']['schedule_appointment'] = array(
	'name' => esc_html__('Appointment Scheduler', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add appointment scheduler module.', 'dt_plugins'),
	'icon_class' => 'ico-appointment',
	'options' => array(
		'serviceids' => array(
			'title' => esc_html__('Service Ids (separeted by commas)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'staffids' => array(
			'title' => esc_html__('Staff Ids (separeted by commas)', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '',
		),
	)
);

$dt_modules['unique']['content_carousel'] = array(
	'name' => esc_html__('Content Carousel', 'dt_plugins'),
	'tooltip' => 'Add Content Carousel Module',
	'icon_class' => 'ico-carousel',
	'options' => array(
		'columns' => array(
			'title' => esc_html__('Columns', 'dt_plugins'),
			'type' => 'select',
			'options' => $content_carousel_columns,
			'default_value' => array()
		),
		'disable_arrows' => array(
			'title' => esc_html__('Disable Arrows', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'ac_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<ul>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
									<li>[dt_sc_icon_box type="type5" fontawesome_icon="fa-anchor" title="Awesome Features" link="#"]Donec sodales sagittis magna.[/dt_sc_icon_box]</li>
								</ul>'
		)
	)
);

$dt_modules['unique']['custom_menus'] = array(
	'name' => esc_html__('Custom Menus', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add custom menus', 'dt_plugins'),
	'icon_class' => 'ico-custommenus',
	'options' => array(
		'cm_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_custom_menu_item fontawesome_icon="fa-phone" span_text="+ 3326 225 FC" /]
								[dt_sc_custom_menu_item fontawesome_icon="fa-envelope-o" link_text="support@fc.com" link="#" link_type="mail" /]
								[dt_sc_custom_menu_location title="Our Locations" title_icon="fa-globe" bgimage="" title_secondary="Check our Locations" phone_icon="fa-phone" phone_text="+ 3326 225 FC" text="Call us our Agent will help you" ]Aenean dignissim pellentesque felis niakm sed. <br/> Morbi in sem quis dui placerat ornare.[/dt_sc_custom_menu_location]'
		)
	)
);

$dt_modules['unique']['donutchart_small'] = array(
	'name' => esc_html__('Donut Chart - Small', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add small donutchart', 'dt_plugins'),
	'icon_class' => 'ico-donutchart',
	'options' => array(
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Lorem'
		),
		'notes' => array(
			'title' => esc_html__('Notes', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Ipsum has been the industry\'s standard dummy text ever.'
		),
		'bgcolor' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '#808080'
		),
		'fgcolor' => array(
			'title' => esc_html__('Foreground Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '#4bbcd7'
		),
		'percent' => array(
			'title' => esc_html__('Percent', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '40'
		),
	)
);

$dt_modules['unique']['donutchart_medium'] = array(
	'name' => esc_html__('Donut Chart - Medium', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add medium donutchart', 'dt_plugins'),
	'icon_class' => 'ico-donutchart',
	'options' => array(
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Lorem'
		),
		'notes' => array(
			'title' => esc_html__('Notes', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Ipsum has been the industry\'s standard dummy text ever.'
		),
		'bgcolor' => array(
			'title' => esc_html__('Background Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '#808080'
		),
		'fgcolor' => array(
			'title' => esc_html__('Foreground Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => '#4bbcd7'
		),
		'percent' => array(
			'title' => esc_html__('Percent', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '40'
		),
	)
);

$dt_modules['unique']['icon_box'] = array(
	'name' => esc_html__('Icon Box', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add icon box from type 1 - type 5', 'dt_plugins'),
	'icon_class' => 'ico-iconbox',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Types', 'dt_plugins'),
			'type' => 'select',
			'options' => $icon_box_types,
			'default_value' => array()
		),
		'fontawesome_icon' => array(
			'title' => esc_html__('Fontawesome Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-anchor'
		),
		'stroke_icon' => array(
			'title' => esc_html__('Stroke Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'icon-Heart'
		),
		'custom_icon' => array(
			'title' => esc_html__('Custom Icon', 'dt_plugins'),
			'type' => 'upload',
			'default_value' => ''
		),
		'title_icon' => array(
			'title' => esc_html__('Title Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'title' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Awesome Features'
		),		
		'link' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '#'
		),
		'span_text' => array(
			'title' => esc_html__('Span Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),		
		'readmore_title' => array(
			'title' => esc_html__('Read More Title', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),		
		'variation' => array(
			'title' => esc_html__('Variation', 'dt_plugins'),
			'type' => 'select',
			'options' => $variations,
			'default_value' => array()
		),
		'alignright' => array(
			'title' => esc_html__('Align Right (type5)', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'alignment' => array(
			'title' => esc_html__('Alignment', 'dt_plugins'),
			'type' => 'select',
			'options' => $alignment,
			'default_value' => array()
		),
		'animation' => array(
			'title' => esc_html__('Animation', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Animation Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'ib_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => 'Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.Donec sodales sagittis magna.'
		)
	)
);

$dt_modules['unique']['icon_box_wrapper'] = array(
	'name' => esc_html__('Icon Box Special', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add special icon box type 9', 'dt_plugins'),
	'icon_class' => 'ico-iconbox',
	'options' => array(
		'ib_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_icon_box type="type9" fontawesome_icon="fa-home" stroke_icon="" custom_icon="" title_icon="" title="Plumbing" link="#" span_text="" readmore_title="" variation="blue" alignright="" alignment="aligncenter" animation="" animation_delay="" class=""]
								Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede. Donec nec justo eget felis facilisis fermentum.
								[/dt_sc_icon_box]
								[dt_sc_icon_box type="type9" fontawesome_icon="fa-hand-paper-o" stroke_icon="" custom_icon="" title_icon="" title="Painting" link="#" span_text="" readmore_title="" variation="blue" alignright="" alignment="aligncenter" animation="" animation_delay="" class=""]
								Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede. Donec nec justo eget felis facilisis fermentum.
								[/dt_sc_icon_box]
								[dt_sc_icon_box type="type9" fontawesome_icon="fa-arrows-v" stroke_icon="" custom_icon="" title_icon="" title="Wiring" link="#" span_text="" readmore_title="" variation="blue" alignright="" alignment="aligncenter" animation="" animation_delay="" class=""]
								Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede. Donec nec justo eget felis facilisis fermentum.
								[/dt_sc_icon_box]
								[dt_sc_icon_box type="type9" fontawesome_icon="fa-soccer-ball-o" stroke_icon="" custom_icon="" title_icon="" title="Fitting" link="#" span_text="" readmore_title="" variation="blue" alignright="" alignment="aligncenter" animation="" animation_delay="" class=""]
								Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede. Donec nec justo eget felis facilisis fermentum.
								[/dt_sc_icon_box]
								[dt_sc_icon_box type="type9" fontawesome_icon="fa-flash" stroke_icon="" custom_icon="" title_icon="" title="Electrician" link="#" span_text="" readmore_title="" variation="blue" alignright="" alignment="aligncenter" animation="" animation_delay="" class=""]
								Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede. Donec nec justo eget felis facilisis fermentum.
								[/dt_sc_icon_box]'
		)
	)
);

$dt_modules['unique']['map_address_wrapper'] = array(
	'name' => esc_html__('Map Address Wrapper', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add map address wrapper', 'dt_plugins'),
	'icon_class' => 'ico-map',
	'options' => array(
		'ib_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '<span>Buddha Themes, Coimbatore,<br>Tamil Nadu,<br>India.</span>'
		)
	)
);

$dt_modules['unique']['newsletter_section'] = array(
	'name' => esc_html__('Newletter Section', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add newsletter section with mailchip api', 'dt_plugins'),
	'icon_class' => 'ico-newsletter',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $newsletter_section_types,
			'default_value' => array()
		),
		'title_text1' => array(
			'title' => esc_html__('Title Text 1', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Subscribe to our'
		),
		'title_text2' => array(
			'title' => esc_html__('Title Text 2', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Newsletter'
		),
	)
);

$dt_modules['unique']['portfolio_item'] = array(
	'name' => esc_html__('Portfolio Item', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add individual portfolio items', 'dt_plugins'),
	'icon_class' => 'ico-portfolio-item',
	'options' => array(
		'id' => array(
			'title' => esc_html__('Item Id', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'portfolio_type' => array(
			'title' => esc_html__('Portfolio Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $portfolio_types,
			'default_value' => array()
		),
	)
);

$dt_modules['unique']['portfolios'] = array(
	'name' => esc_html__('Portfolio Items From Category', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add portfolio items from category', 'dt_plugins'),
	'icon_class' => 'ico-portfolio-item',
	'options' => array(
		'category_id' => array(
			'title' => esc_html__('Category Id', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'column' => array(
			'title' => esc_html__('Columns', 'dt_plugins'),
			'type' => 'select',
			'options' => $portfolio_columns,
			'default_value' => array(3)
		),
		'count' => array(
			'title' => 'Count',
			'type' => 'text',
			'default_value' => ''
		),
		'show_filter' => array(
			'title' => esc_html__('Show Filter', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'disable_isotope' => array(
			'title' => esc_html__('Disable Isotope', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'show_ajaxpagination' => array(
			'title' => esc_html__('Show Ajax Pagination', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'portfolio_type' => array(
			'title' => esc_html__('Portfolio Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $portfolio_types,
			'default_value' => array()
		),
	)
);

$dt_modules['unique']['post'] = array(
	'name' => esc_html__('Post Item', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to display any single post', 'dt_plugins'),
	'icon_class' => 'ico-singlepost',
	'options' => array(
		'id' => array(
			'title' => esc_html__('Post Id', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '1'
		),
		'excerpt_length' => array(
			'title' => esc_html__('Excerpt Length', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '10'
		),
	)
);

$dt_modules['unique']['recent_post'] = array(
	'name' => esc_html__('Posts From Categories', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to display recent posts', 'dt_plugins'),
	'icon_class' => 'ico-recentposts',
	'options' => array(
		'columns' => array(
			'title' => esc_html__('Columns', 'dt_plugins'),
			'type' => 'select',
			'options' => $post_columns,
			'default_value' => array()
		),
		'count' => array(
			'title' => esc_html__('Limit', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '3'
		),
		'excerpt_length' => array(
			'title' => esc_html__('Excerpt Length', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '10'
		),
		'categories' => array(
			'title' => esc_html__('Categories', 'dt_plugins'),
			'type' => 'select',
			'options' => $post_cat,
			'multiple' => true,
			'default_value' => array()
		),
		'grid_layout' => array(
			'title' => esc_html__('Grid Layout', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'animation' => array(
			'title' => esc_html__('Animation', 'dt_plugins'),
			'type' => 'select',
			'options' => $dt_animation_types,
			'default_value' => array()
		),
		'animation_delay' => array(
			'title' => esc_html__('Animation Delay', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['unique']['post_carousel'] = array(
	'name' => esc_html__('Post Carousel', 'dt_plugins'),
	'tooltip' => 'Add post carousel module here.',
	'icon_class' => 'ico-carousel',
	'options' => array(
		'tc_content' => array(
			'title' => esc_html__('Content', 'dt_plugins'),
			'type' => 'wp_editor',
			'is_content' => true,
			'default_value' => '[dt_sc_one_half type="type1"]<br>
								[dt_sc_post id="1" excerpt_length="10" /]<br>
								[/dt_sc_one_half]<br>
								[dt_sc_one_half type="type1"]<br>
								[dt_sc_post id="1" excerpt_length="10" /]<br>
								[/dt_sc_one_half]<br>
								[dt_sc_one_half type="type1"]<br>
								[dt_sc_post id="1" excerpt_length="10" /]<br>
								[/dt_sc_one_half]<br>
								[dt_sc_one_half type="type1"]<br>
								[dt_sc_post id="1" excerpt_length="10" /]<br>
								[/dt_sc_one_half]'
		)
	)
);

$dt_modules['unique']['woo_products'] = array(
	'name' => esc_html__('Products', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to display woocommerce products', 'dt_plugins'),
	'icon_class' => 'ico-products',
	'options' => array(
		'column' => array(
			'title' => esc_html__('Columns', 'dt_plugins'),
			'type' => 'select',
			'options' => $product_columns,
			'default_value' => array(4)
		),
		'posts_per_page' => array(
			'title' => esc_html__('Posts Per Page', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '-1'
		),
		'orderby' => array(
			'title' => esc_html__('Order By', 'dt_plugins'),
			'type' => 'select',
			'options' => $orderby,
			'default_value' => array('date')
		),
		'order' => array(
			'title' => esc_html__('Order', 'dt_plugins'),
			'type' => 'select',
			'options' => $order,
			'default_value' => array('desc')
		),
		'carousel' => array(
			'title' => esc_html__('Carousel', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'category_ids' => array(
			'title' => esc_html__('Category Ids', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['unique']['woo_featured_product'] = array(
	'name' => esc_html__('Product Single Item', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to display single wooocommerce product.', 'dt_plugins'),
	'icon_class' => 'ico-products',
	'options' => array(
		'product_id' => array(
			'title' => esc_html__('Product Id', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['unique']['popup_video'] = array(
	'name' => esc_html__('Popup Video', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add video in popup.', 'dt_plugins'),
	'icon_class' => 'ico-video',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $popupvideo_types,
			'default_value' => array()
		),
		'video_url' => array(
			'title' => esc_html__('Popup Video URL', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$dt_modules['unique']['social_links'] = array(
	'name' => esc_html__('Social Links', 'dt_plugins'),
	'tooltip' => 'Add social links module',
	'icon_class' => 'ico-social',
	'options' => array(
		'show_tooltip' => array(
			'title' => esc_html__('Show Tooltip', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'tooltip_position' => array(
			'title' => esc_html__('Tooltip Position', 'dt_plugins'),
			'type' => 'select',
			'options' => $tooltip_positions,
			'default_value' => array('top')
		),
		'align' => array(
			'title' => esc_html__('Align', 'dt_plugins'),
			'type' => 'select',
			'options' => $align,
			'default_value' => array()
		),
		'target' => array(
			'title' => esc_html__('Target', 'dt_plugins'),
			'type' => 'text',
			'default_value' => '_blank'
		),

		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
	)
);

$sel_sociables =  array('fa-deviantart', 'fa-facebook-square', 'fa-google-plus', 'fa-pinterest', 'fa-behance');
foreach ( $sociables as $sociable_key => $sociable ) {
	if(in_array($sociable_key, $sel_sociables)) $default_value = '#'; else $default_value = '';
	$dt_modules['unique']['social_links']['options'][$sociable] = array(
			'title' => ucfirst($sociable),
			'type' => 'text',
			'default_value' => $default_value
		);
}

$dt_modules['unique']['search_cart'] = array(
	'name' => esc_html__('Search & Cart Link', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add search and/or link', 'dt_plugins'),
	'icon_class' => 'ico-search',
	'options' => array(
		'enable_search' => array(
			'title' => esc_html__('Enable Search', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('true')
		),
		'search_icon' => array(
			'title' => esc_html__('Search Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-search'
		),
		'enable_cart' => array(
			'title' => esc_html__('Enable Cart', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array('false')
		),
		'cart_icon' => array(
			'title' => esc_html__('Cart Icon', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'fa-shopping-cart'
		),
	)
);

$dt_modules['unique']['title'] = array(
	'name' => esc_html__('Title', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add title', 'dt_plugins'),
	'icon_class' => 'ico-headings',
	'options' => array(
		'type' => array(
			'title' => esc_html__('Type', 'dt_plugins'),
			'type' => 'select',
			'options' => $title_types,
			'default_value' => array('h4')
		),
		'style' => array(
			'title' => esc_html__('Style', 'dt_plugins'),
			'type' => 'select',
			'options' => $title_style_types,
			'default_value' => array()
		),
		'link' => array(
			'title' => esc_html__('Link', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'align' => array(
			'title' => esc_html__('Alignment', 'dt_plugins'),
			'type' => 'select',
			'options' => $titlealign,
			'default_value' => array()
		),
		'bold' => array(
			'title' => esc_html__('Bold', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'disable_margin' => array(
			'title' => esc_html__('Disable Margin', 'dt_plugins'),
			'type' => 'select',
			'options' => $trueorfalse,
			'default_value' => array()
		),
		'color' => array(
			'title' => esc_html__('Color', 'dt_plugins'),
			'type' => 'colorpicker',
			'default_value' => ''
		),
		'link_class' => array(
			'title' => esc_html__('Link Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'class' => array(
			'title' => esc_html__('Class', 'dt_plugins'),
			'type' => 'text',
			'default_value' => ''
		),
		'title_content' => array(
			'title' => esc_html__('Title', 'dt_plugins'),
			'type' => 'text',
			'is_content' => true,
			'default_value' => 'Lorem'
		),
		'span_text' => array(
			'title' => esc_html__('Span Text', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 'Ipsum'
		),
	)
);

/*  End of Unique Modules */

/*  Start of Others Modules */

$dt_modules['others']['hr_border'] = array(
	'name' => esc_html__('Bordered Horizontal Rule', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add bordered horizontal rule', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['clear'] = array(
	'name' => esc_html__('Clear', 'dt_plugins'),
	'tooltip' => esc_html__('Add this module to add space between contents', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['space'] = array(
	'name' => esc_html__('Custom Space', 'dt_plugins'),
	'tooltip' => esc_html__('Add this module to add custom space between contents', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
	'options' => array(
		'space' => array(
			'title' => esc_html__('Space', 'dt_plugins'),
			'type' => 'text',
			'default_value' => 20
		),
	)
);

$dt_modules['others']['hr_line'] = array(
	'name' => esc_html__('Horizontal Line', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add horizontal line', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_line_white'] = array(
	'name' => esc_html__('Horizontal Line - White', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add white horizontal line', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr'] = array(
	'name' => esc_html__('Horizontal Rule', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add horizontal rule', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_medium'] = array(
	'name' => esc_html__('Horizontal Rule Medium', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add medium horizontal rule', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_large'] = array(
	'name' => esc_html__('Horizontal Rule Large', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add large horizontal rule', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_top'] = array(
	'name' => esc_html__('Horizontal Rule With Top Link', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add horizontal rule with top link', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_invisible'] = array(
	'name' => esc_html__('Whitespace', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add whitespace', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_invisible_very_small'] = array(
	'name' => esc_html__('Whitespace Very Small', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add very small whitespace', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['hr_invisible_small'] = array(
	'name' => esc_html__('Whitespace Small', 'dt_plugins'),
	'tooltip' => esc_html__('Use this module to add small whitespace', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
);

$dt_modules['others']['margin'] = array(
	'name' => esc_html__('Margin', 'dt_plugins'),
	'tooltip' => esc_html__('Add this module to add margin between contents', 'dt_plugins'),
	'icon_class' => 'ico-divider',
	'disable_resize' => true,
	'options' => array(
		'margin' => array(
			'title' => esc_html__('Margin', 'dt_plugins'),
			'type' => 'select',
			'options' => $margins,
			'default_value' => array('20')
		),
	)
);
/*  End of Others Modules */
?>