jQuery.noConflict();
jQuery(document).ready(function($) {
	
	"use strict";
  
	//Accordion & Toggle
	$('.dt-sc-toggle').toggle(function(){ $(this).addClass('active'); },function(){ $(this).removeClass('active'); });
	$('.dt-sc-toggle').on('click', function(){ $(this).next().slideToggle(); });
	
	$('.dt-sc-toggle-frame-set').each(function(){
		var $this = $(this),
		    $toggle = $this.find('.dt-sc-toggle-accordion');
			
			$toggle.on('click', function(){
				if( $(this).next().is(':hidden') ) {
					$this.find('.dt-sc-toggle-accordion').removeClass('active').next().slideUp();
					$(this).toggleClass('active').next().slideDown();
				}
				return false;
			});
			
			//Activate First Item always
			$this.find('.dt-sc-toggle-accordion:first').addClass("active");
			$this.find('.dt-sc-toggle-accordion:first').next().slideDown();
  	});//Accordion & Toggle
	
	// Tabs Shortcodes
	if ($("ul.dt-sc-tabs").length > 0) {
		$("ul.dt-sc-tabs").tabs("> .dt-sc-tabs-content", {effect: 'fade'})
	}
	if ($("ul.dt-sc-tabs-frame").length > 0) {
		$("ul.dt-sc-tabs-frame").tabs("> .dt-sc-tabs-frame-content", {effect: 'fade'})
	}
	if ($(".dt-sc-tabs-vertical-frame").length > 0) {
		$(".dt-sc-tabs-vertical-frame").tabs("> .dt-sc-tabs-vertical-frame-content", {effect: 'fade'});
		$(".dt-sc-tabs-vertical-frame").each(function() {
			$(this).find("li:first").addClass("first").addClass("current");
			$(this).find("li:last").addClass("last")
		});
		$(".dt-sc-tabs-vertical-frame li").click(function() {
			$(this).parent().children().removeClass("current");
			$(this).addClass("current")
		})
	} /*Tabs Shortcodes Ends*/
	
	/*Tooltip*/
	 if($(".dt-sc-tooltip-bottom").length){
		$(".dt-sc-tooltip-bottom").each(function(){ $(this).tipTip({maxWidth: "auto"}); });
	 }
	  
	 if($(".dt-sc-tooltip-top").length){
		$(".dt-sc-tooltip-top").each(function(){ $(this).tipTip({maxWidth: "auto",defaultPosition: "top"}); });
	 }
	  
	 if($(".dt-sc-tooltip-left").length){
		$(".dt-sc-tooltip-left").each(function(){ $(this).tipTip({maxWidth: "auto",defaultPosition: "left"}); });
	 }
	  
	 if($(".dt-sc-tooltip-right").length){
		$(".dt-sc-tooltip-right").each(function(){ $(this).tipTip({maxWidth: "auto",defaultPosition: "right"}); });
	 }/*Tooltip End*/

	/* Parallax Section */
	$('.dt-sc-parallax').each(function(){
		$(this).bind('inview', function (event, visible) {
			var $bgposition = (typeof( $(this).attr('data-position') ) != 'undefined' && $(this).attr('data-position') != '') ? $(this).attr('data-position') : "50%";
			if($bgposition == 'center center') { $bgposition = "50%"; }
			if(visible == true) {
				$(this).parallax($bgposition, 0.3);
			} else {
				$(this).css('background-position','');
			}
		});
	});
	
	$('.dt-sc-parallax-second').each(function(){
		$(this).bind('inview', function (event, visible) {
			var $bgposition = (typeof( $(this).attr('data-position') ) != 'undefined' && $(this).attr('data-position') != '') ? $(this).attr('data-position') : "50%";
			if($bgposition == 'center center') { $bgposition = "50%"; }
			if(visible == true) {
				$(this).parallax($bgposition, 0.2);
			} else {
				$(this).css('background-position','');
			}
		});
	});
	

	//Donutchart
  	$(".dt-sc-donutchart").each(function(){
		var $this = $(this);
	 	var $bgColor =  ( $this.data("bgcolor") !== undefined ) ? $this.data("bgcolor") : "#f5f5f5";
	 	var $fgColor =  ( $this.data("fgcolor") !== undefined ) ? $this.data("fgcolor") : "#000000";
	 	var $size = ( $this.data("size") !== undefined ) ? $this.data("size") : "120";
	 
	 	$this.donutchart({'size': $size, 'fgColor': $fgColor, 'bgColor': $bgColor , 'donutwidth' : 10 });
	 	$this.donutchart('animate');
	});
	
	$(window).on('load', function(){	
	
		// Testimonial Carousel
		if( jQuery('.dt-sc-testimonial-carousel').length ) {
			jQuery('.dt-sc-testimonial-carousel').each(function(){
				var pagger = jQuery(this).parents(".dt-sc-testimonial-wrapper").find("div.carousel-arrows"),
				next = pagger.find("a.testimonial-next"),
				prev = pagger.find("a.testimonial-prev"),
				auto_val;
				
				if(jQuery(this).parents(".dt-sc-testimonial-wrapper").hasClass('type4')) { auto_val = true; }
				else { auto_val = false; }
				
				jQuery(this).carouFredSel({
					responsive:true,
					auto:auto_val,
					width:'100%',
					prev:prev,
					next:next,
					scroll:1,
					items:{visible: {min: 1}, height: 'variable'}
				});
			});
		}
		
		// Blog Carousel
		if(jQuery('.blog-carousel').length) {
			jQuery('.blog-carousel').each(function(){
				var pagger = jQuery(this).parents(".blog-carousel-wrapper").find("div.blog-carousel-arrows"),
				next = pagger.find("a.next"),
				prev = pagger.find("a.prev");
				jQuery(this).carouFredSel({
					responsive: true,
					auto: false,
					width: '100%',
					height: 'variable',
					prev:prev,
					next:next,
					scroll: 1,
					items: { 
					width: $(this).find('.column').width(),
					height: 'variable',
					visible: {
					  min: 1,
					  max: 3 }
					}
				});
			});
		}
		
		// Team Carousel
		if( jQuery('.dt-sc-team-carousel').length ) {
			jQuery('.dt-sc-team-carousel').each(function(){
				var column = jQuery(this).data('column');
				if(column != '') column = column; else column = 1;
				jQuery(this).carouFredSel({
					responsive:true,
					auto:false,
					width:'100%',
					prev:'.prev',
					next:'.next',
					scroll:1,
					items: { 
						width: $(this).find('.column').width(),
						height: 'variable',
						visible: {
						  min: 1,
						  max: 4 }
						}
				});
			});
		}
		
		// Partner Carousel
		if( jQuery('.dt-sc-partner-carousel').length ) {
			jQuery('.dt-sc-partner-carousel').each(function(){
				jQuery(this).carouFredSel({
					responsive:true,
					auto:true,
					width:'100%',
					height: 'variable',
					prev: 'prev',
					next: 'next',
					scroll:1,
					items:{visible: {min: 1, max: 4}, height: 'variable'}
				});
			});
		}

		// Product Carousel
		if(jQuery('.feature-product-carousel').length) {
			jQuery('.feature-product-carousel').each(function() {
			
				var pagger = jQuery(this).parents(".product-carousel-wrapper").find("div.product-carousel"),
				next = pagger.find("a.next"),
				prev = pagger.find("a.prev"),
				column = jQuery(this).parents(".product-carousel-wrapper").attr('data-column');
				
				if(column == '') column = 4;
				
				if(column == 1) {
					jQuery(this).carouFredSel({ 
						responsive: true, auto: false, width: '100%', height: 'variable', prev: prev, next: next, scroll: 1, swipe: {onMouse: true, onTouch: true}, 
						items: { width: jQuery(this).find('.column').width(), height: 'variable', visible: { min: 1, max: 1 } } 
					});
				} else if(column == 2) {
					jQuery(this).carouFredSel({ 
						responsive: true, auto: false, width: '100%', height: 'variable', prev: prev, next: next, scroll: 1, swipe: {onMouse: true, onTouch: true}, 
						items: { width: jQuery(this).find('.column').width(), height: 'variable', visible: { min: 1, max: 2 } } 
					});
				} else if(column == 3) {
					jQuery(this).carouFredSel({ 
						responsive: true, auto: false, width: '100%', height: 'variable', prev: prev, next: next, scroll: 1, swipe: {onMouse: true, onTouch: true}, 
						items: { width: jQuery(this).find('.column').width(), height: 'variable', visible: { min: 1, max: 3 } } 
					});
				} else if(column == 4) {
					jQuery(this).carouFredSel({ 
						responsive: true, auto: false, width: '100%', height: 'variable', prev: prev, next: next, scroll: 1, swipe: {onMouse: true, onTouch: true}, 
						items: { width: jQuery(this).find('.column').width(), height: 'variable', visible: { min: 1, max: 4 } } 
					});
				}
			
			});
		}
		
		// Content Carousel
		if(jQuery('.content-carousel').length) {
			jQuery('.content-carousel').each(function(){
				var pagger = jQuery(this).parents(".content-carousel-wrapper").find(".content-carousel-arrows"),
				next = pagger.find("a.next"),
				prev = pagger.find("a.prev"),
				column = jQuery(this).attr('data-columns'),
				auto_carousel = jQuery(this).parents(".content-carousel-wrapper").attr('data-arrows');
				
				if(auto_carousel == 'true') { auto_carousel = true; }
				else { auto_carousel = false; }
				
				if(column == '') column = 4;
				
				if(column == 1) {
					jQuery(this).carouFredSel({
						responsive: true, auto: auto_carousel, width: '100%', height: 'variable', prev:prev, next:next, scroll: 1, items: { height: 'variable', visible: { min: 1, max: 1 } }
					});
				} else if(column == 2) {
					jQuery(this).carouFredSel({
						responsive: true, auto: auto_carousel, width: '100%', height: 'variable', prev:prev, next:next, scroll: 1, items: { height: 'variable', visible: { min: 1, max: 2 } }
					});
				} else if(column == 3) {
					jQuery(this).carouFredSel({
						responsive: true, auto: auto_carousel, width: '100%', height: 'variable', prev:prev, next:next, scroll: 1, items: { height: 'variable', visible: { min: 1, max: 3 } }
					});
				} else if(column == 4) {
					jQuery(this).carouFredSel({
						responsive: true, auto: auto_carousel, width: '100%', height: 'variable', prev:prev, next:next, scroll: 1, items: { height: 'variable', visible: { min: 1, max: 4 } }
					});
				}
				
			});
		}

	});
	
	// Progress Bar & Custom Animation
	 animateSkillBars();
	 animateSection();
	 $(window).on('scroll', function(){ 
		animateSkillBars();
		animateSection();
	 });

	 function animateSection(){
		 var applyViewPort = ( jQuery("html").hasClass('csstransforms') ) ? ":in-viewport" : "";
		 jQuery('.animate'+applyViewPort).each(function(){
			var $this = jQuery(this),
				$animation = ( $this.data("animation") !== undefined ) ? $this.data("animation") : "slideUp";
			var	$delay = ( $this.data("delay") !== undefined ) ? $this.data("delay") : 300;

			if( !$this.hasClass($animation) ){
				setTimeout(function() { $this.addClass($animation);	},$delay);
			}
		 });
	 }
	 
	 function animateSkillBars(){
		 var applyViewPort = ( jQuery("html").hasClass('csstransforms') ) ? ":in-viewport" : "";
		 jQuery('.dt-sc-progress'+applyViewPort).each(function(){
			 var progressBar = jQuery(this),
				 progressValue = progressBar.find('.dt-sc-bar').attr('data-value');
				 
				 if (!progressBar.hasClass('animated')) {
						progressBar.addClass('animated');
						progressBar.find('.dt-sc-bar').animate({width: progressValue + "%"},600,function(){ progressBar.find('.dt-sc-bar-text').fadeIn(400); });
				 }
		 });
	}
	
	//Animate Number...
	$('.dt-sc-num-count').each(function(){
	  $(this).one('inview', function (event, visible) {
		  if(visible === true) {
			  var val = $(this).attr('data-value');
			  $(this).animateNumber({ number: val	}, 2000);
		  }
	  });
	});
		
	//Divider Scroll to top
	$("a.scrollTop").each(function(){
		$(this).on('click', function(e){
			$("html, body").animate({ scrollTop: 0 }, 600);
			e.preventDefault();
		});
	});
	
	//Video Popup
	if($(".popupVideo").length)
		$(".popupVideo").prettyPhoto({default_width: 560,animation_speed:'normal',autoplay_slideshow: false,social_tools: false,deeplinking:false});
		
		
	// Script For Search Enable / Disable
	if($(".show-box").length) {
		$(".show-box").on('click', function() {
			$(this).parent().find('.search-form-box').slideDown();
			if($(this).parents().hasClass('header2') || $(this).parents().hasClass('header5') || $(this).parents().hasClass('header6')) $(this).parents('#menu-container').find('#main-menu').slideUp();
		});
	}
	
	if($(".dt-searchform-close").length) {
		$(".dt-searchform-close").on('click', function() {
			$(this).parent().slideUp();
			$(this).parents('#menu-container').find('#main-menu').slideDown();
		});
	}
	
});