scnShortcodeMeta = {
	attributes : [ 
		{
			label : "Style",
			id : "type",
			help : "Select which type of pricing table you would like to use.",
			controlType : "select-control",
			selectValues : [ 'type1', 'type2' ],
			defaultValue : 'type1',
			defaultText : 'type1'
		},
		{
			label : "Columns",
			id : "content",
			controlType : "column-control"
		},
		{
			label : "Background Color",
			id : "bgcolor",
			help : 'You can choose background color for column here.',
			controlType : "color-control"
		},
		{
			label : "Background Color Opacity",
			id : "bgcoloropacity",
			help : "You can add opacity for background color here.",
		},
		{
			label : "Border Radius",
			id : "borderradius",
			help : "You can add border radius here. ex. 5px or 5px 10px or 5px 10px 15px or 5px 10px 15px 20px.",
		},
		{
			label : "Background Image URL",
			id : "bgimageurl",
			help : 'You can add background image for column here.',
			controlType : "text-control"
		},
		{
			label : "Background Image Position",
			id : 'bgimageposition',
			help : '',
			controlType : "select-control",
			selectValues : [ '', 'left top', 'left center', 'left bottom', 'right top', 'right center','right bottom', 'center top', 'center center','center bottom'],
			defaultValue : '',
			defaultText : ''
		},
		{
			label : "Background Image Repeat",
			id : 'bgimagerepeat',
			help : '',
			controlType : "select-control",
			selectValues : [ '', 'no-repeat', 'repeat', 'repeat-x', 'repeat-y' ],
			defaultValue : '',
			defaultText : ''
		},
		{
			label : "Text Color",
			id : "textcolor",
			help : 'You can choose text color for column here.',
			controlType : "color-control"
		},
		{
			label : "Padding",
			id : "padding",
			help : "You can add padding here. ex. 5px or 5px 10px or 5px 10px 15px or 5px 10px 15px 20px.",
		},
		{
			label : "Border Width (ex. 1px 2px 3px 4px)",
			id : "borderwidth",
			help : 'Add border width for your content',
			controlType : "text-control"
		},
		{
			label : "Border Style",
			id : "borderstyle",
			help : 'Add border style for your content',
			controlType : "select-control",
			selectValues : [ '', 'solid', 'dashed', 'dotted', 'inset', 'outset', 'groove', 'ridge', 'double' ],
			defaultValue : '',
			defaultText : ''
		},
		{
			label : "Border Color",
			id : "bordercolor",
			help : 'Add border color for your content',
			controlType : "color-control"
		},
		{
			label : "Alignment",
			id : "alignment",
			help : "Select column content alignment.",
			controlType : "select-control",
			selectValues : [ '', 'alignleft', 'alignright', 'aligncenter' ],
			defaultValue : '',
			defaultText : 'Default'
		},
		 {
			label : "Animation",
			id : "animation",
			help : "Select which type of animation you would like to use.",
			controlType : "select-control",
			selectValues : [ "None","flash","shake","bounce","tada","swing","wobble","pulse","flip","flipInX","flipOutX","flipInY","flipOutY","fadeIn","fadeInUp","fadeInDown","fadeInLeft","fadeInRight","fadeInUpBig","fadeInDownBig","fadeInLeftBig","fadeInRightBig","fadeOut","fadeOutUp","fadeOutDown","fadeOutLeft","fadeOutRight","fadeOutUpBig","fadeOutDownBig","fadeOutLeftBig","fadeOutRightBig","bounceIn","bounceInUp","bounceInDown","bounceInLeft","bounceInRight","bounceOut","bounceOutUp","bounceOutDown","bounceOutLeft","bounceOutRight","rotateIn","rotateInUpLeft","rotateInDownLeft","rotateInUpRight","rotateInDownRight","rotateOut","rotateOutUpLeft","rotateOutDownLeft","rotateOutUpRight","rotateOutDownRight","hinge","rollIn","rollOut","lightSpeedIn","lightSpeedOut","slideDown","slideUp","slideLeft","slideRight","slideExpandUp","expandUp","expandOpen","bigEntrance","hatch","floating","tossing","pullUp","pullDown","stretchLeft","stretchRight","zoomIn" ],
			defaultValue : 'None',
			defaultText : 'None'
		},
		{
			label : "Animation Delay",
			id : "animation_delay",
			help : "You can add animation delay here.",
		},
		{
			label : "Region",
			id : "region",
			help : "Change this option to inner only if you need column inside another column ",
			controlType : "select-control",
			selectValues : [ "Outer", "Inner" ],
			defaultValue : 'Outer',
			defaultText : 'Outer'
		},
		{
			label : "Class",
			id : "class",
			help : "You can specify additional class here.",
		},
	],

	customMakeShortcode : function(b) {
		var a = b.data;
		var region = b.region;
		var type = b.type;
		var bgcolor = b.bgcolor;
		var bgcoloropacity = b.bgcoloropacity;
		var borderradius = b.borderradius;
		
		var bgimageurl = b.bgimageurl;
		var bgimageposition = b.bgimageposition;
		var bgimagerepeat = b.bgimagerepeat;
		
		var textcolor = b.textcolor;
		var padding = b.padding;
		
		var borderwidth = b.borderwidth;
		var borderstyle = b.borderstyle;
		var bordercolor = b.bordercolor;
		
		var alignment = b.alignment;
		var animation = b.animation;
		var animation_delay = b.animation_delay;

		type = ' type="'+type+'"';
		bgcolor = ' bgcolor="'+bgcolor+'"';
		bgcoloropacity = ' bgcoloropacity="'+bgcoloropacity+'"';
		borderradius = ' borderradius="'+borderradius+'"';
		
		bgimageurl = ' bgimageurl="'+bgimageurl+'"';
		bgimageposition = ' bgimageposition="'+bgimageposition+'"';
		bgimagerepeat = ' bgimagerepeat="'+bgimagerepeat+'"';
		
		textcolor = ' textcolor="'+textcolor+'"';
		padding = ' padding="'+padding+'"';
		
		borderwidth = ' borderwidth="'+borderwidth+'"';
		borderstyle = ' borderstyle="'+borderstyle+'"';
		bordercolor = ' bordercolor="'+bordercolor+'"';
		
		alignment = ' alignment="'+alignment+'"';
		animation = ' animation ="'+animation+'"';
		animation_delay = ' animation_delay ="'+animation_delay+'"';

		if (!a)
			return "";
		b = a.numColumns;
		var c = a.content;
		a = [ "0", "one", "two", "three", "four", "five",'six' ];
		var x = [ "0", "0", "half", "third", "fourth", "fifth",'sixth' ];
		var f = x[b];
		c = c.split("|");
		var g = "";
		for ( var h in c) {
			var d = jQuery.trim(c[h]);
			if (d.length > 0) {
				var e = a[d.length] + '_' + f;
				if (b == 4 && d.length == 2)
					e = "one_half";
					
				if(region == 'Inner') {
					e += "_inner";
				}

				var z = e;
				if (h == 0)
					e += " first";
				g += "[dt_sc_" + e + type + bgcolor + bgcoloropacity + borderradius + bgimageurl + bgimageposition + bgimagerepeat + textcolor + padding + borderwidth + borderstyle + bordercolor + alignment + " " + animation + " " + animation_delay + "]Content for " + d.length + "/" + b
						+ " Column here[/dt_sc_" + z + "]<br />";
			}
		}
		return g;
	}
};