<?php 
get_header();

$page_layout 	= painting_option('pageoptions','post-archives-page-layout');
if($GLOBALS['force_enable'] == true) {
	$page_layout = painting_option('general', 'global-page-layout');
	$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
}

$show_sidebar = $show_left_sidebar = $show_right_sidebar =  false;
$sidebar_class = $thumbnail_sidebar = $post_thumbnail = "";

switch ( $page_layout ) {
	case 'with-left-sidebar':
		$page_class = "page-with-sidebar with-left-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-left-sidebar";
		$thumbnail_sidebar = "-with-sidebar";
		$sidebar_id = "left";
	break;

	case 'with-right-sidebar':
		$page_class = "page-with-sidebar with-right-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-right-sidebar";
		$thumbnail_sidebar = "-with-sidebar";
		$sidebar_id = "right";
	break;

	case 'content-full-width':
	default:
		$page_class = "content-full-width";
		$thumbnail_sidebar = "";
	break;
}

$post_layout_type = painting_option('pageoptions','archives-layout-type');
?>

<section id="primary" class="<?php echo esc_attr($page_class);?>">

    <?php
    $post_layout = painting_option('pageoptions','post-archives-post-layout'); 
    $post_layout = !empty($post_layout) ? $post_layout : "one-column";
    $post_class = $container_class = "";

    switch($post_layout):
        case 'one-column':
            $post_class = $show_sidebar ? " column dt-sc-one-column with-sidebar blog-fullwidth" : " column dt-sc-one-column blog-fullwidth";
            $columns = 1;
        break;

        case 'one-half-column';
            $post_class = $show_sidebar ? " column dt-sc-one-half with-sidebar" : " column dt-sc-one-half";
            $columns = 2;
            $container_class = "apply-isotope";
        break;

        case 'one-third-column':
            $post_class = $show_sidebar ? " column dt-sc-one-third with-sidebar" : " column dt-sc-one-third";
            $columns = 3;
            $container_class = "apply-isotope";
        break;

    endswitch;
    
    if( have_posts() ):
	
		echo '<div class="blog-items '.$container_class.'">';
			$i = 1;
			while( have_posts() ):
				the_post();
				$temp_class = "";
				if($i == 1) $temp_class = $post_class." first"; else $temp_class = $post_class;
				if($i == $columns) $i = 1; else $i = $i + 1;
				$format = get_post_format(  get_the_id() );?>
				<div class="<?php echo esc_attr($temp_class);?>"><?php  get_template_part( 'framework/loops/content', 'archive');?></div>
				<?php 		
			endwhile;
		echo '</div>';
		
		painting_post_navigation();
		
	else: ?>
    
		<h2><?php esc_html_e('Nothing Found.', 'painting'); ?></h2>
		<p><?php esc_html_e('Apologies, no results were found for the requested archive.', 'painting'); ?></p><?php
		
    endif;
    ?>

</section>
    
<?php if ( $show_sidebar ): ?>
    <section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class);?>"><?php get_sidebar($sidebar_id); ?></section>
<?php endif; ?>

<?php get_footer(); ?>