<?php
$hide_format_meta = (painting_option('pageoptions','post-format-meta') != '')? 'hidden' : '';
$hide_author_meta = (painting_option('pageoptions','post-author-meta') != '')? 'hidden' : '';
$hide_date_meta = (painting_option('pageoptions','post-date-meta') != '') ? 'hidden' : '';	
$hide_comment_meta = (painting_option('pageoptions','post-comment-meta') != '') ? 'hidden' : '';
$hide_tag_meta = (painting_option('pageoptions','post-tag-meta') != '') ? 'hidden' : '';
$hide_category_meta = (painting_option('pageoptions','post-category-meta') != '') ? 'hidden' : '';

$format = get_post_format(get_the_id());
$blog_overlay = '<div class="blog-overlay '.$hide_format_meta.'"><a href="'.get_permalink().'" title="'.get_the_title().'" class="entry_format"></a></div>';

$post_meta = get_post_meta(get_the_id() ,'_dt_post_settings',TRUE);
$post_meta = is_array( $post_meta ) ? $post_meta  : array(); 

$category_color = array_key_exists('categories-variation', $post_meta) ? $post_meta['categories-variation'] : '';

if(get_the_title() == '') {
	$single_page_link_start = '<a href="'.get_permalink().'">';
	$single_page_link_end = '</a>';
} else {
	$single_page_link_start = '';
	$single_page_link_end = '';
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(array('blog-post')); ?>>

    <div class="entry-thumb-meta">
        <?php 
        if($format === "image" || empty($format)) {
            if(has_post_thumbnail()) { ?>
                <div class="entry-thumb">
                    <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>"><?php the_post_thumbnail('painting-1170x800'); ?></a>
                    <?php echo painting_wp_kses($blog_overlay); ?>
                </div>
            <?php 
            } 
        } elseif($format === "gallery" && array_key_exists("items", $post_meta)) {
            echo '<div class="entry-thumb">';
                echo '<ul class="recent-gallery">';
                    foreach ( $post_meta['items'] as $key => $item ) {
                        $attachment_id = $post_meta['items_id'][$key];
                        $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
                        echo '<li><img src="'.esc_url($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
                    }
                echo '</ul>';	
            echo '</div>';
        } elseif( $format === "video" && ( array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta) ) ) {
            echo '<div class="entry-thumb">';
                if(array_key_exists('oembed-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_oembed_get($post_meta['oembed-url']).'</div>';
                elseif(array_key_exists('self-hosted-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_video_shortcode( array('src' => $post_meta['self-hosted-url']) ).'</div>';
            echo '</div>';
        } elseif( $format === "audio" && (array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta)) ) {
            echo '<div class="entry-thumb">';
                if(array_key_exists('oembed-url', $post_meta)) echo wp_oembed_get($post_meta['oembed-url']);
                elseif(array_key_exists('self-hosted-url', $post_meta)) echo wp_audio_shortcode( array('src' => $post_meta['self-hosted-url']) );
            echo '</div>';
        } else { 
            if( has_post_thumbnail() ) { ?>
                <div class="entry-thumb">
                    <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>"><?php the_post_thumbnail('painting-1170x800'); ?></a>
                    <?php echo painting_wp_kses($blog_overlay); ?>
                </div>
            <?php 
            }
        }
        ?>
    </div>

    <div class="entry-detail">
		<?php if(is_sticky()) { ?>
            <div class="featured-post"> <span class="fa fa-trophy"> </span> <span class="text"> <?php esc_html_e('Featured','painting');?> </span></div>
        <?php } ?>
        <div class="entry-title">
            <h4><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( '%s', 'painting'), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h4>
        </div>
        <div class="entry-body">
            <?php echo painting_excerpt(20);?>
        </div>
        <div class="entry-meta">
            <div class="category <?php echo esc_attr($hide_category_meta.' '.$category_color); ?>">
                <?php the_category(', '); ?>
            </div>
            <div class="date <?php echo esc_attr($hide_date_meta); ?>">
            	<?php echo painting_wp_kses($single_page_link_start); ?>
                    <?php echo get_the_date('d M Y');?>
                <?php echo painting_wp_kses($single_page_link_end); ?>
            </div>
            <div class="post-comments <?php echo esc_attr($hide_comment_meta); ?>">
				<?php comments_popup_link('0 '.esc_html__('Comment', 'painting'), '1 '.esc_html__('Comment', 'painting'), '% '.esc_html__('Comment(s)', 'painting'),'','0 '.esc_html__('Comment', 'painting')); ?>
            </div>
        </div> 
    </div> 
    
</article>