<?php 
$tpl_pageid = $post->ID;
$tpl_default_settings = get_post_meta( $post->ID, '_tpl_default_settings', TRUE );
$tpl_default_settings = is_array( $tpl_default_settings ) ? $tpl_default_settings  : array();

$post_layout = isset( $tpl_default_settings['blog-post-layout'] ) ? $tpl_default_settings['blog-post-layout'] : "one-column";
$post_per_page = isset($tpl_default_settings['blog-post-per-page']) ? $tpl_default_settings['blog-post-per-page'] : -1;
$categories = isset($tpl_default_settings['blog-post-categories']) ? array_filter($tpl_default_settings['blog-post-categories']) : NULL;

$hide_format_meta = isset( $tpl_default_settings['disable-format-info'] ) ? 'hidden' : '';
$hide_date_meta = isset( $tpl_default_settings['disable-date-info'] ) ? 'hidden' : '';
$hide_comment_meta = isset( $tpl_default_settings['disable-comment-info'] ) ? 'hidden' : '';
$hide_category_meta = isset( $tpl_default_settings['disable-category-info'] ) ? 'hidden' : '';

$isotope_class = "";

switch($post_layout):
    case 'one-column':
        $post_class = 'column dt-sc-one-column blog-fullwidth';
        $columns = 1;
    break;

    case 'one-half-column';
        $post_class = 'column dt-sc-one-half';
        $columns = 2;
        $isotope_class = 'apply-isotope';
    break;
	
    case 'one-third-column':
        $post_class = "column dt-sc-one-third";
        $columns = 3;
        $isotope_class = "apply-isotope";
    break;
endswitch;

if(empty($categories)):
    $args = array( 'paged'=>get_query_var( 'paged' ), 'posts_per_page'=>$post_per_page, 'post_type'=> 'post' );
else:
    $include_cats = array_unique( $categories );
    $args = array( 'paged'=>get_query_var( 'paged' ), 'posts_per_page'=>$post_per_page, 'category__in'=>$include_cats, 'post_type'=>'post' );
endif;


$blog_query = new WP_Query($args);
if($blog_query->have_posts()): 
    $i = 1;  $init = 0;
	if(!array_key_exists('blog-post-gridlayout',$tpl_default_settings)) { echo '<div class="blog-items '.esc_attr($isotope_class).'">'; }
    while($blog_query->have_posts()): 
        $blog_query->the_post();

        $temp_class = '';
        if($i == 1) { 
			$temp_class = $post_class.' first'; 
			if(array_key_exists('blog-post-gridlayout',$tpl_default_settings) && $init != 0) echo '<div class="dt-sc-clear"></div>';
		} else $temp_class = $post_class;
        if($i == $columns) $i = 1; else $i = $i + 1;
		$init++;
		
        $format = get_post_format(get_the_id());
		$blog_overlay = '<div class="blog-overlay '.$hide_format_meta.'"><a href="'.get_permalink().'" title="'.get_the_title().'" class="entry_format"></a></div>';
		
		$post_meta = get_post_meta(get_the_id() ,'_dt_post_settings',TRUE);
		$post_meta = is_array( $post_meta ) ? $post_meta  : array(); 
		
		$category_color = array_key_exists('categories-variation', $post_meta) ? $post_meta['categories-variation'] : '';
		
		if(get_the_title() == '') {
			$single_page_link_start = '<a href="'.get_permalink().'">';
			$single_page_link_end = '</a>';
		} else {
			$single_page_link_start = '';
			$single_page_link_end = '';
		}
		?>

        <div class="<?php echo esc_attr($temp_class); ?>">
            <article id="post-<?php the_ID(); ?>" <?php post_class(array('blog-post')); ?>>
            
                <div class="entry-thumb-meta">
					<?php 
                    if($format === "image" || empty($format)) {
                    	if(has_post_thumbnail()) { ?>
                            <div class="entry-thumb">
                                <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>"><?php the_post_thumbnail('painting-1170x800'); ?></a>
                                <?php echo painting_wp_kses($blog_overlay); ?>
                            </div>
                    	<?php 
                        }
					} elseif($format === "gallery" && array_key_exists("items", $post_meta)) {
						echo '<div class="entry-thumb">';
							echo '<ul class="recent-gallery">';
								foreach ( $post_meta['items'] as $key => $item ) {
									$attachment_id = $post_meta['items_id'][$key];
									$img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1170x800');
									echo '<li><img src="'.esc_url($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" /></li>';
								}
							echo '</ul>';	
						echo '</div>';
					} elseif( $format === "video" && ( array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta) ) ) {
						echo '<div class="entry-thumb">';
							if(array_key_exists('oembed-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_oembed_get($post_meta['oembed-url']).'</div>';
							elseif(array_key_exists('self-hosted-url', $post_meta)) echo '<div class="dt-video-wrap">'.wp_video_shortcode( array('src' => $post_meta['self-hosted-url']) ).'</div>';
						echo '</div>';
					} elseif( $format === "audio" && (array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta)) ) {
						echo '<div class="entry-thumb">';
							if(array_key_exists('oembed-url', $post_meta)) echo wp_oembed_get($post_meta['oembed-url']);
							elseif(array_key_exists('self-hosted-url', $post_meta)) echo wp_audio_shortcode( array('src' => $post_meta['self-hosted-url']) );
						echo '</div>';
					} else { 
						if( has_post_thumbnail() ) { ?>
                            <div class="entry-thumb">
                                <a href="<?php the_permalink();?>" title="<?php printf(esc_attr__('%s', 'painting'),the_title_attribute('echo=0'));?>"><?php the_post_thumbnail('painting-1170x800'); ?></a>
                                <?php echo painting_wp_kses($blog_overlay); ?>
                            </div>
						<?php 
						}
					}
					?>
                </div>
            
                <div class="entry-detail">
					<?php if(is_sticky()) { ?>
                        <div class="featured-post"> <span class="fa fa-trophy"> </span> <span class="text"> <?php esc_html_e('Featured','painting');?> </span></div>
                    <?php } ?>
                    <div class="entry-title">
                        <h4><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( '%s', 'painting'), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h4>
                    </div>
                    <div class="entry-body">
                        <?php 
						if(array_key_exists('blog-post-excerpt',$tpl_default_settings)) { echo painting_excerpt($tpl_default_settings['blog-post-excerpt-length']); }
						else {echo painting_excerpt(20); }
						?>
                    </div>
                    <div class="entry-meta">
                        <div class="category <?php echo esc_attr($hide_category_meta.' '.$category_color); ?>">
                            <?php the_category(', '); ?>
                        </div>
                        <div class="date <?php echo esc_attr($hide_date_meta); ?>">
                        	<?php echo painting_wp_kses($single_page_link_start); ?>
                                <?php echo get_the_date('d M Y');?>
                            <?php echo painting_wp_kses($single_page_link_end); ?>
                        </div>
                        <div class="post-comments <?php echo esc_attr($hide_comment_meta); ?>">
                            <?php comments_popup_link('0 '.esc_html__('Comment', 'painting'), '1 '.esc_html__('Comment', 'painting'), '% '.esc_html__('Comment(s)', 'painting'),'','0 '.esc_html__('Comment', 'painting')); ?>
                        </div>
                    </div> 
                </div> 
                
            </article>
        </div>

    <?php
	endwhile;
	
    if(!array_key_exists('blog-post-gridlayout',$tpl_default_settings)) { echo '</div>'; }

	if($blog_query->max_num_pages > 1) {
		?>
		<div class="pagination <?php echo painting_get_pagination_position(); ?>">
			<?php
			$pages = ($blog_query->max_num_pages) ? $blog_query->max_num_pages : 1;
			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			if($paged > 1) echo '<div class="prev-post"><a href="'.get_pagenum_link($paged - 1).'"><span class="fa fa-caret-left"></span>&nbsp;'.esc_html__('Prev', 'painting').'</a></div>';
			echo paginate_links( array(
			  'base' 		 => add_query_arg('paged','%#%'),
			  'format' 		 => '',
			  'current' 	 => $paged,
			  'type'     	 => 'list',
			  'end_size'     => 2,
			  'mid_size'     => 3,
			  'prev_next'    => false,
			  'total' 		 => $blog_query->max_num_pages )
			);
			if ($paged < $pages) echo '<div class="next-post"><a href="'.get_pagenum_link($paged + 1).'">'.esc_html__('Next', 'painting').'&nbsp;<span class="fa fa-caret-right"></span></a></div>';
			?>
		</div>
	<?php 
	}
	?>
    
<?php 
else: ?>
    <h2><?php esc_html_e('Nothing Found.', 'painting'); ?></h2>
    <p><?php esc_html_e('Apologies, no results were found for the requested archive.', 'painting'); ?></p><?php
endif;
wp_reset_postdata();
?>