<?php
/* ---------------------------------------------------------------------------
 * Function to get the template page settings
 * --------------------------------------------------------------------------- */
if ( ! function_exists( 'painting_template_page' ) ) {
	function painting_template_page() {
		global $dt_template;
		
		$page_id = painting_ID();
		$tpl_default_settings = get_post_meta($page_id,'_tpl_default_settings',TRUE);
		$dt_template = isset($tpl_default_settings['template']) ? $tpl_default_settings['template'] : 0;
		
		if($dt_template > 0) {
			global $dttemplate_general_settings, $dtenable_general_settings;
			
			$dttemplate_general_settings = get_post_meta ($dt_template, '_template_general_settings', TRUE);
			$dtenable_general_settings = (isset($dttemplate_general_settings['enable-general-settings']) && $dttemplate_general_settings['enable-general-settings'] != '') ? true : false;
		}

	}
	add_action( 'wp_enqueue_scripts', 'painting_template_page' );
}

/* ---------------------------------------------------------------------------
 * Loading Theme Scripts
 * --------------------------------------------------------------------------- */
add_action('wp_enqueue_scripts', 'painting_enqueue_scripts');
if (!function_exists('painting_enqueue_scripts')) {
function painting_enqueue_scripts() {

	$library_uri = PAINTING_URI.'/framework';

	// Load the html5 shiv
	wp_enqueue_script( 'painting-html5', $library_uri.'/js/html5.js', array(), '3.7.3' );
	wp_script_add_data( 'painting-html5', 'conditional', 'lt IE 9' );

	global $is_IE;
	if( $is_IE ):
		wp_enqueue_script('jq-html5');
	endif;

	// comment reply script ------------------------------------------------------
	if (is_singular() && comments_open()):
		 wp_enqueue_script( 'comment-reply' );
	endif;

	// variable
	if ( function_exists('icl_object_id') ) { global $sitepress; $current_lang = $sitepress->get_current_language(); }
	else $current_lang = '';
		
	$preloader = painting_option("general","enable-preloader") ? "enable" : "disable";
	$nicescroll = painting_option('general', 'enable-nicescroll') ? "enable" : "disable";
	$stickynav = painting_option("layout","enable-stickynav") ? "enable" : "disable";
	$isResponsive = painting_option ( "general", "enable-responsive" ) ? "enable" : "disable";
	
	if(is_rtl()) $rtl = true; else $rtl = false;
	$pluginURL =  plugin_dir_url ( 'buddhathemes-core-features' );
	if( is_page_template('tpl-onepage.php') ) $onepage = 'true'; else $onepage = 'false';

	echo "\n <script type='text/javascript'>\n\t";
	echo "var mytheme_urls = {\n";
	echo "\t\t theme_base_url:'".esc_js(PAINTING_URI)."'";
	echo "\n \t\t,ajaxurl:'".admin_url('admin-ajax.php')."'";
	echo "\n \t\t,url:'".get_site_url()."'";
	echo "\n \t\t,nicescroll:'".esc_js($nicescroll)."'";
	echo "\n \t\t,stickynav:'".esc_js($stickynav)."'";
	echo "\n \t\t,is_admin:'".current_user_can('level_10') ."'";
	echo "\n \t\t,wooIsotope:'".painting_option('woo','shop-apply-isotope')."'";
	echo "\n \t\t,isOnePage:'".esc_js($onepage)."'";
	echo "\n \t\t,preloader:'".esc_js($preloader)."'";
	echo "\n \t\t,isRTL:'".esc_js($rtl)."'";
	echo "\n \t\t,pluginURL:'".esc_js($pluginURL)."'";
	echo "\n \t\t,currentLang:'".esc_js($current_lang)."'";
	echo "\n \t\t,isResponsive:'".esc_js($isResponsive)."'";
	echo "\n\t};\n";
	echo " </script>\n";
	
	wp_enqueue_script('painting-plugins', $library_uri.'/js/jsplugins.js',array('jquery'),false,true);

	$cookiebar = painting_option('privacy', 'enable-cookie-msgbar');
		if( isset($cookiebar) ) {
			wp_enqueue_script('jq-cookie-js', $library_uri.'/js/cookieconsent.js', array(jquery), false, true);
		}

		wp_enqueue_script('jq-popup-js', $library_uri.'/js/magnific/jquery.magnific-popup.min.js', array(jquery), false, true);


	#Theme Picker 		
	if(!is_user_logged_in()) {
		$stylepicker = painting_option('general', 'enable-stylepicker') ? "enable" : "disable";
		if($stylepicker == 'enable') {
			wp_enqueue_script('painting-cookies', $library_uri.'/js/jquery.cookie.min.js',array('jquery'),false,true);
			wp_enqueue_script('painting-picker', $library_uri.'/js/picker.js',array('jquery'),false,true);
		}
	}
	
   	wp_enqueue_script('painting-custom', $library_uri.'/js/custom.js',array('jquery'),false,true);
}
}

/* ---------------------------------------------------------------------------
 * Scripts of Custom JS from Theme Back-End
* --------------------------------------------------------------------------- */
if (!function_exists('painting_scripts_custom')) {
function painting_scripts_custom()
{
	if( ($custom_js = painting_option('layout', 'customjs-content')) && painting_option('layout','enable-customjs') ){
		echo '<script>'."\n";
			echo '//<![CDATA['."\n";
				echo stripslashes($custom_js) ."\n";
			echo '//]]>'."\n";
		echo '</script>'."\n";
	}
}
}
add_action('wp_footer', 'painting_scripts_custom', 100);

/* ---------------------------------------------------------------------------
 * Loading Theme Styles
 * --------------------------------------------------------------------------- */
add_action( 'wp_enqueue_scripts', 'painting_enqueue_styles' );
if (!function_exists('painting_enqueue_styles')) {
function painting_enqueue_styles() {

	global $dtenable_general_settings, $dttemplate_general_settings;
	$layout_opts = (painting_option('layout') != '') ?painting_option('layout') : array();
	$general_opts = (painting_option('general') != '') ? painting_option('general') : array();
	$colors_opts = (painting_option('colors') != '') ? painting_option('colors') : array();

	if (!function_exists('has_site_icon') || ! has_site_icon()) {
		
		$url = ! empty ( $layout_opts ['favicon-url'] ) ? $layout_opts ['favicon-url'] : PAINTING_URI . "/images/favicon.png";
		echo "<link href='$url' rel='shortcut icon' type='image/x-icon' />\n";
	
		$phone_url = ! empty ( $layout_opts ['apple-favicon'] ) ? $layout_opts ['apple-favicon'] : PAINTING_URI . "/images/apple-touch-icon.png";
		echo "<link href='$phone_url' rel='apple-touch-icon-precomposed'/>\n";
	
		$phone_retina_url = ! empty ( $layout_opts ['apple-retina-favicon'] ) ? $layout_opts ['apple-retina-favicon'] : PAINTING_URI. "/images/apple-touch-icon-114x114.png";
		echo "<link href='$phone_retina_url' sizes='114x114' rel='apple-touch-icon-precomposed'/>\n";
	
		$ipad_url = ! empty ( $layout_opts ['apple-ipad-favicon'] ) ? $layout_opts ['apple-ipad-favicon'] : PAINTING_URI . "/images/apple-touch-icon-72x72.png";
		echo "<link href='$ipad_url' sizes='72x72' rel='apple-touch-icon-precomposed'/>\n";
	
		$ipad_retina_url = ! empty ( $layout_opts ['apple-ipad-retina-favicon'] ) ? $layout_opts ['apple-ipad-retina-favicon'] : PAINTING_URI . "/images/apple-touch-icon-144x144.png";
		echo "<link href='$ipad_retina_url' sizes='144x144' rel='apple-touch-icon-precomposed'/>\n";
	
	}

	// wp_enqueue_style ---------------------------------------------------------------
	wp_enqueue_style( 'painting-style', get_stylesheet_uri(), false, PAINTING_VERSION, 'all' );

	wp_enqueue_style ( 'painting-custom-font-awesome', PAINTING_URI . '/css/font-awesome.min.css' );
	
	wp_enqueue_style ( 'painting-strokegap-icons', PAINTING_URI . '/css/stroke-gap-icons.min.css' );

	if(class_exists('woocommerce')) { wp_enqueue_style( 'painting-woocommerce', PAINTING_URI .'/css/woocommerce.css', 'woocommerce-general-css', PAINTING_VERSION, 'all' ); }

	wp_enqueue_style("skin", 	PAINTING_URI .'/css/skins/default/style.css');
	
	if(array_key_exists('enable-responsive', $general_opts)) { wp_enqueue_style("painting-responsive",  	PAINTING_URI . "/responsive.css", false, PAINTING_VERSION, 'all' ); }
	
	// disable slider for mobile devices --------------------------------------------
	if(isset($general_opts['disable-mobileslider'])):
		echo '<style type="text/css">';
		echo '@media only screen and (max-width:320px), (max-width: 479px), (min-width: 480px) and (max-width: 767px), (min-width: 768px) and (max-width: 959px),
		 (max-width:1200px) { .dt-sc-main-slider { display:none !important; } }';
		echo '</style>';
	endif;

	// google fonts -----------------------------------------------------------------
	wp_enqueue_style( 'painting-google-fonts', painting_load_fonts_url(), array(), '1.0.0' );
	
	// custom css
	wp_enqueue_style( 'painting-custom', PAINTING_URI .'/css/custom.css', false, PAINTING_VERSION, 'all' );

	// jquery scripts --------------------------------------------
	wp_enqueue_script('painting-modernizr', PAINTING_URI . '/framework/js/modernizr.min.js', array('jquery'));

	// cookie-consent -----------------------------------------------------------------
		$cookie_bar = painting_option('privacy', 'enable-cookie-msgbar');
		if( isset($cookie_bar) ) {
			wp_enqueue_style( 'painting-cookie-css', PAINTING_URI .'/css/cookieconsent.css', false, PAINTING_VERSION, 'all' );
		}

		wp_enqueue_style( 'painting-popup-css', PAINTING_URI .'/framework/js/magnific/magnific-popup.css', false, PAINTING_VERSION, 'all' );
	
}
}
/* ---------------------------------------------------------------------------
 * Styles of Custom Font
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_styles_custom_font')) {
function painting_styles_custom_font()
{
	$fonts 		  = painting_fonts_selected();
	$font_custom  = painting_option('fonts','customfont-name');
	$font_custom2 = painting_option('fonts','customfont2-name');

	if( $font_custom && in_array( $font_custom, $fonts ) ){
		echo '<style>'."\n";
			echo '@font-face {';
				echo 'font-family: "'. $font_custom .'";';
				echo 'src: url("'. painting_option('fonts','customfont-eot') .'");';
				echo 'src: url("'. painting_option('fonts','customfont-eot') .'#iefix") format("embedded-opentype"),';
					echo 'url("'. painting_option('fonts','customfont-woff') .'") format("woff"),';
					echo 'url("'. painting_option('fonts','customfont-ttf') .'") format("truetype"),';
					echo 'url("'. painting_option('fonts','customfont-svg') .'#'. $font_custom .'") format("svg");';
				echo 'font-weight: normal;';
				echo 'font-style: normal;';
			echo '}'."\n";
		echo '</style>'."\n";
	}
	
	if( $font_custom2 && in_array( $font_custom2, $fonts ) ){
		echo '<style>'."\n";
			echo '@font-face {';
				echo 'font-family: "'. $font_custom2 .'";';
				echo 'src: url("'. painting_option('fonts','customfont2-eot') .'");';
				echo 'src: url("'. painting_option('fonts','customfont2-eot') .'#iefix") format("embedded-opentype"),';
					echo 'url("'. painting_option('fonts','customfont2-woff') .'") format("woff"),';
					echo 'url("'. painting_option('fonts','customfont2-ttf') .'") format("truetype"),';
					echo 'url("'. painting_option('fonts','customfont2-svg') .'#'. $font_custom2 .'") format("svg");';
				echo 'font-weight: normal;';
				echo 'font-style: normal;';
			echo '}'."\n";
		echo '</style>'."\n";
	}
}
}
add_action('wp_head', 'painting_styles_custom_font');

/* ---------------------------------------------------------------------------
 * Fonts Selected in Theme Options Panel
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_fonts_selected')) {
function painting_fonts_selected(){
	$fonts = array();
	
	$font_opts = painting_option('fonts');
	$fonts['content'] 		= !empty ( $font_opts['content-font'] ) 	? 	$font_opts['content-font'] 		: 'Lato';
	$fonts['menu'] 			= !empty ( $font_opts['menu-font'] ) 		? 	$font_opts['menu-font'] 		: 'Lato';
	$fonts['submenu'] 		= !empty ( $font_opts['submenu-font'] ) 	? 	$font_opts['submenu-font'] 		: 'Lato';
	$fonts['title'] 		= !empty ( $font_opts['pagetitle-font'] ) 	? 	$font_opts['pagetitle-font'] 	: 'Lato';
	$fonts['h1'] 			= !empty ( $font_opts['h1-font'] ) 			? 	$font_opts['h1-font'] 			: 'Lato';
	$fonts['h2'] 			= !empty ( $font_opts['h2-font'] ) 			? 	$font_opts['h2-font'] 			: 'Lato';
	$fonts['h3'] 			= !empty ( $font_opts['h3-font'] ) 			? 	$font_opts['h3-font'] 			: 'Lato';
	$fonts['h4'] 			= !empty ( $font_opts['h4-font'] ) 			? 	$font_opts['h4-font'] 			: 'Lato';
	$fonts['h5'] 			= !empty ( $font_opts['h5-font'] ) 			? 	$font_opts['h5-font'] 			: 'Lato';
	$fonts['h6'] 			= !empty ( $font_opts['h6-font'] ) 			? 	$font_opts['h6-font'] 			: 'Lato';

	return $fonts;
}
}


/* ---------------------------------------------------------------------------
 * Including Google Fonts
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_load_fonts_url')) {
function painting_load_fonts_url() {
	
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
    */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'painting' ) ) {
		
		if(painting_option('fonts','font-subset') != '') $subset = str_replace(' ', '', painting_option('fonts','font-subset'));
		else $subset = '';
		if(painting_option('fonts','font-style') != '') $weight = ':'. implode( ',', painting_option('fonts','font-style') );
		else $weight = '';
		
		// Default fonts used by theme
		$font_families = array('Lato:100,300,400,700,900,100italic,300italic,400italic,700italic,900italic', 'Roboto:400,300,700,400italic,300italic,500,500italic,700italic', 'Muli:400,300,300italic,400italic', 'Playfair Display:400,700,900', 'Open Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800', 'Open Sans Condensed:300,300italic,700');	
		
		// Fonts chosen by user
		$google_fonts = painting_fonts();
		$google_fonts = $google_fonts['all'];
		$fonts = painting_fonts_selected();
		$selected_fonts = array_intersect($fonts, $google_fonts);
		foreach($selected_fonts as $selected_font) {
			$font_families[] = $selected_font.$weight;
		}

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( $subset ),
		);
		
		$font_url = add_query_arg( $query_args, 'http'. painting_ssl() .'://fonts.googleapis.com/css' );
		
    }
	
    return $font_url;
}		
}

/* ---------------------------------------------------------------------------
 * Styles of Custom Styles & Page Styles
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_styles_custom')) {
function painting_styles_custom()
{
	// Theme Options > Layout > Custom CSS
	if( ($custom_css = painting_option('layout','customcss-content')) &&  painting_option('layout','enable-customcss')){
		echo '<style>'."\n";
			echo str_replace('&gt;', '>', $custom_css)."\n";
		echo '</style>'."\n";
	}

	// Page Options > Custom CSS
	$page_id = painting_ID();
	if( ($custom_css = get_post_meta( $page_id, '_tpl_default_settings', true )) && array_key_exists('custom-css', $custom_css) ){
		echo '<style>'."\n";
			echo str_replace('&gt;', '>', $custom_css['custom-css'])."\n";
		echo '</style>'."\n";;
	}

}
}
add_action('wp_head', 'painting_styles_custom');

/* ---------------------------------------------------------------------------
 * Site SSL Compatibility
 * --------------------------------------------------------------------------- */
if( ! function_exists( 'painting_ssl' ) )
{
	function painting_ssl( $echo = false ){
		$ssl = '';
		if( is_ssl() ) $ssl = 's';
		if( $echo ){
			echo esc_html($ssl);
		}
		return $ssl;
	}
}

/* ---------------------------------------------------------------------------
 * SSL | Attachments
 * --------------------------------------------------------------------------- */
if( ! function_exists( 'painting_ssl_attachments' ) )
{
	function painting_ssl_attachments( $url ){
		if( is_ssl() ){
			return str_replace('http://', 'https://', $url);
		}
		return $url;
	}
}
add_filter( 'wp_get_attachment_url', 'painting_ssl_attachments' );

/* ---------------------------------------------------------------------------
 * Blog Title
 * --------------------------------------------------------------------------- */
if (!function_exists('painting_blog_title')) {
function painting_blog_title() {
	$the_content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', get_option('blogname'));
	return $the_content;
}
}

/* ---------------------------------------------------------------------------
 * Function to apply buddha panel css options
 * --------------------------------------------------------------------------- */
if ( ! function_exists( 'painting_buddha_panel_css_options' ) ) {
	function painting_buddha_panel_css_options() {

		$output = NULL;
	
		global $dttemplate_general_settings, $dtenable_general_settings;
		$layout_opts = (painting_option('layout') != '') ? painting_option('layout') : array();	
			
		$site_layout =  array_key_exists('site-layout', $layout_opts) ? $layout_opts['site-layout'] : ''; 
		$bg_type =  array_key_exists('bg-type', $layout_opts) ? $layout_opts['bg-type'] : ''; 
		
		$pattern =  array_key_exists('boxed-layout-pattern', $layout_opts) ? $layout_opts['boxed-layout-pattern'] : ''; 
		$pattern_repeat =  array_key_exists('boxed-layout-pattern-repeat', $layout_opts) ? $layout_opts['boxed-layout-pattern-repeat'] : ''; 
		$disable_color =  array_key_exists('disable-boxed-layout-pattern-color', $layout_opts) ? $layout_opts['disable-boxed-layout-pattern-color'] : ''; 
		$pattern_color =  array_key_exists('boxed-layout-pattern-color', $layout_opts) ? $layout_opts['boxed-layout-pattern-color'] : ''; 
		$pattern_opacity =  array_key_exists('boxed-layout-pattern-opacity', $layout_opts) ? $layout_opts['boxed-layout-pattern-opacity'] : ''; 

		$bg =  array_key_exists('boxed-layout-bg', $layout_opts) ? $layout_opts['boxed-layout-bg'] : ''; 
		$bg_repeat =  array_key_exists('boxed-layout-bg-repeat', $layout_opts) ? $layout_opts['boxed-layout-bg-repeat'] : ''; 
		$bg_opacity =  array_key_exists('boxed-layout-bg-opacity', $layout_opts) ? $layout_opts['boxed-layout-bg-opacity'] : ''; 
		$bg_color =  array_key_exists('boxed-layout-bg-color', $layout_opts) ? $layout_opts['boxed-layout-bg-color'] : ''; 
		$bg_disable_color =  array_key_exists('disable-boxed-layout-bg-color', $layout_opts) ? $layout_opts['disable-boxed-layout-bg-color'] : ''; 
		$bg_position =  array_key_exists('boxed-layout-bg-position', $layout_opts) ? $layout_opts['boxed-layout-bg-position'] : ''; 
					
		#Site Layout Section
		if ($site_layout == "boxed") {
	
			if ($bg_type == "bg-patterns") {
				
				$output .= 'body { ';
	
				if(!empty($pattern)) $output .= 'background-image:url("'.PAINTING_URI.'/images/patterns/'.$pattern.'");';
				if(!empty($pattern_repeat)) $output .= 'background-repeat:'.$pattern_repeat.';';
				
				if(empty($disable_color)) {
					if (!empty($pattern_opacity)) {
						$color = painting_hex2rgb($pattern_color);
						$output .= 'background-color:rgba('.$color[0].', '.$color[1].', '.$color[2].', '.$pattern_opacity.');';
					} else {
						$output .= 'background-color:'.$pattern_color.';';
					}
				}
				$output .= '}\r\t';
	
			} elseif ($bg_type == "bg-custom") {
			
				$output .= 'body { ';
	
				if(!empty($bg)) {
					$output .= 'background-image:url('.$bg.');';
					$output .= 'background-repeat:'.$bg_repeat.';';
					$output .= 'background-position:'.$bg_position.';';
				}
	
				if(empty($bg_disable_color)) {
					if(!empty($bg_opacity)) {
						$color = painting_hex2rgb($bg_color);
						$output .= 'background-color:rgba('.$color[0].', '.$color[1].', '.$color[2].', '.$bg_opacity.');';
					} else {
						$output .= 'background-color:'.$bg_color.';';
					}
				}
				$output .= '}\r\t';
	
			}
		}
		
		if(!empty($output)) {
			echo "\r".'<style type="text/css">'."\r\t".$output."\r".'</style>'."\r";
		}

	}
	add_action( 'wp_head', 'painting_buddha_panel_css_options' );
}

?>