<?php 

// WooCommerce Theme Support And Actions -------------------------------------------------
add_theme_support( 'woocommerce' );
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

remove_action( 'woocommerce_pagination', 'woocommerce_catalog_ordering', 20 );
remove_action( 'woocommerce_pagination', 'woocommerce_pagination', 10 );

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 25 );

add_filter( 'woocommerce_show_page_title', create_function( false, 'return false;' ) );

// Disable WooCommerce Styles ------------------------------------------------
if ( version_compare( get_option('woocommerce_version'), "2.1" ) >= 0 ) {
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );
} else {
	define( 'WOOCOMMERCE_USE_CSS', false );
}

// Before main content -------------------------------------------------------
add_action( 'woocommerce_before_main_content', 'painting_woo_before_main_content', 10);
if( !function_exists('painting_woo_before_main_content') ) {
	function painting_woo_before_main_content() {
		
		if( is_shop() ):
			$tpl_default_settings = get_post_meta( get_option('woocommerce_shop_page_id') ,'_tpl_default_settings',TRUE);
			$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
			$page_layout  = array_key_exists("layout",$tpl_default_settings) ? $tpl_default_settings['layout'] : "content-full-width";
		elseif( is_product() ):
			$page_layout = painting_option('woo',"product-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		elseif( is_product_category() ):
			$page_layout = painting_option('woo',"product-category-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		elseif( is_product_tag() ):
			$page_layout = painting_option('woo',"product-tag-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		endif;

		if($page_layout != 'content-full-width'):
			echo '<section id="primary" class="page-with-sidebar '.$page_layout.'">';
		else:
			echo '<section id="primary" class="content-full-width">';
		endif;
		
	}
}

// After main content -------------------------------------------------------
add_action( 'woocommerce_after_main_content', 'painting_woo_after_main_content', 20);
if( !function_exists('painting_woo_after_main_content') ) {
	function painting_woo_after_main_content() {

		echo "</section>";

		if( is_shop() ):
			$tpl_default_settings = get_post_meta( get_option('woocommerce_shop_page_id') ,'_tpl_default_settings',TRUE);
			$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
			$page_layout  = array_key_exists("layout",$tpl_default_settings) ? $tpl_default_settings['layout'] : "content-full-width";
		elseif( is_product() ):
			$page_layout = painting_option('woo',"product-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		elseif( is_product_category() ):
			$page_layout = painting_option('woo',"product-category-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		elseif( is_product_tag() ):
			$page_layout = painting_option('woo',"product-tag-layout");
			$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		endif;
		
		if($GLOBALS['force_enable'] == true) {
			$page_layout = painting_option('general', 'global-page-layout');			
		}

		$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
		
		$show_sidebar = false;
		$sidebar_class = $sidebar_id = "";
	
		switch ( $page_layout ) {
			case 'with-left-sidebar':
				$show_sidebar = true;
				$sidebar_class = "secondary-has-left-sidebar";
				$sidebar_id = "left";
			break;
	
			case 'with-right-sidebar':
				$show_sidebar = true;
				$sidebar_class = "secondary-has-right-sidebar";
				$sidebar_id = "right";
			break;
		}

		if($show_sidebar) {
			echo '<section id="secondary-'.$sidebar_id.'" class="secondary-sidebar '.$sidebar_class.'">';
			get_sidebar($sidebar_id);
			echo '</section>';
		}
		
		echo '<div class="dt-sc-margin45"></div>';

	}
}

// Shop Columns -------------------------------------------------------
add_action( 'loop_shop_columns', 'painting_shop_columns', 20);
if( !function_exists('painting_shop_columns') ) {
	function painting_shop_columns() {
		if(is_post_type_archive('product')) {
			$column = painting_option('woo', 'shop-page-product-layout'); 
		} else {
			$column = painting_option('woo', 'shop-other-product-layout');
		}
		if($column == 'one-half-column') $shop_column = 2;
		elseif($column == 'one-third-column') $shop_column = 3;
		elseif($column == 'one-fourth-column') $shop_column = 4;
		else $shop_column = 4;
		return $shop_column;
	}
}

// Products Per Page -------------------------------------------------------
add_filter( 'loop_shop_per_page', 'painting_shop_per_page' );
if (!function_exists('painting_shop_per_page')) {
	function painting_shop_per_page() {
		$shop_product_per_page = trim(stripslashes(painting_option('woo','shop-product-per-page')));
		$shop_product_per_page = !empty($shop_product_per_page)  ? $shop_product_per_page : get_option('posts_per_page');
		return $shop_product_per_page;
	}
}

// Additional Class For Secondary Flip Image -------------------------------------------------------
if(!is_admin()) {
	add_filter( 'post_class', 'painting_shop_product_has_secondary_image' );
	if (!function_exists('painting_shop_product_has_secondary_image')) {
		function painting_shop_product_has_secondary_image( $classes ) {
			global $product;
			$post_type = get_post_type( get_the_ID() );
			if ( $post_type == 'product' ) {
				$attachment_ids = $product->get_gallery_image_ids();
				if ( $attachment_ids ) {
					$classes[] = 'product-has-secondary-image';
				}
			}
			return $classes;
		}
	}
}

// Wishlist In Product Detail Page  -------------------------------------------------------
add_action( 'woocommerce_single_product_summary', 'painting_shop_product_detail_wishlist', 35 );
if( !function_exists('painting_shop_product_detail_wishlist') ) {
	function painting_shop_product_detail_wishlist() {
		$position = get_option( 'yith_wcwl_button_position' );
		if (shortcode_exists('yith_wcwl_add_to_wishlist') && $position == 'shortcode') echo do_shortcode('[yith_wcwl_add_to_wishlist /]');
	}
}


// Before Product Details  -------------------------------------------------------
add_action( 'woocommerce_product_meta_start', 'painting_shop_product_meta_start');
if( !function_exists('painting_shop_product_meta_start') ) {
	function painting_shop_product_meta_start() {
		echo '<h6>'.esc_html__('Product Details', 'painting').'</h6>';
	}
}

// Customize Tabs In Product Single Page
add_filter( 'woocommerce_product_tabs', 'painting_shop_product_tabs' );
if( !function_exists('painting_shop_product_tabs') ) {
	function painting_shop_product_tabs($tabs = array()) {
		global $product;

		$tabs = array();
		
		if(painting_option('woo','disable-tabs-section') != 'true') {
			
			// Reviews tab - shows comments
			if ( comments_open() ) {
				$tabs['reviews'] = array(
					'title'    => sprintf( esc_html__( 'Reviews (%d)', 'painting' ), $product->get_review_count() ),
					'priority' => 20,
					'callback' => 'comments_template'
				);
			}
			
			// About tab - shows product content
			$tabs['about'] = array(
				'title'    => esc_html__( 'About', 'painting' ).' '.$product->get_name(),
				'priority' => 30,
				'callback' => 'painting_shop_about_tab'
			);
		
		}
		
		return $tabs;
	}
}

if (!function_exists('painting_shop_about_tab')) {
function painting_shop_about_tab() {
	global $product;
	echo '<h4>'.esc_html__( 'About', 'painting' ).' '.$product->get_name().'</h4>';
	echo nl2br($product->get_description());
}
}

// Customize UpSell Products In Product Single Page
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product', 'woocommerce_upsell_display', 10 );

if(painting_option('woo','show-upsell-products') == 'true') {
	add_action( 'woocommerce_after_single_product_summary', 'painting_shop_upsell_product_display', 15);
	if( !function_exists('painting_shop_upsell_product_display') ){
		function painting_shop_upsell_product_display() {
			
			$product_layout = painting_option('woo',"shop-other-product-layout");
			$product_layout = !empty($product_layout) ? $product_layout : 'one-third-column';
	
			if($product_layout == 'one-half-column') $upsell_column = 2;
			elseif($product_layout == 'one-third-column') $upsell_column = 3;
			elseif($product_layout == 'one-fourth-column') $upsell_column = 4;
			else $upsell_column = 3;
			
			woocommerce_upsell_display( $posts_per_page = $upsell_column, $columns = $upsell_column, $orderby = 'rand' );
						
		}
	}
}

// Customize Related Products In Product Single Page
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
remove_action( 'woocommerce_after_single_product', 'woocommerce_output_related_products', 10 );

if(painting_option('woo','show-related-products') == 'true') {
	add_action( 'woocommerce_after_single_product_summary', 'painting_shop_related_product_display', 15);
	if( !function_exists('painting_shop_related_product_display') ){
		function painting_shop_related_product_display() {
			
			$product_layout = painting_option('woo',"shop-other-product-layout");
			$product_layout = !empty($product_layout) ? $product_layout : 'one-third-column';
	
			if($product_layout == 'one-half-column') $related_column = 2;
			elseif($product_layout == 'one-third-column') $related_column = 3;
			elseif($product_layout == 'one-fourth-column') $related_column = 4;
			else $related_column = 3;
			
			woocommerce_related_products( array('posts_per_page' => $related_column, 'columns' => $related_column, 'orderby' => 'rand') );
						
		}
	}
}

// Separate Table For Coupon Code Entry  -------------------------------------------------------
add_action( 'woocommerce_cart_contents', 'painting_shop_cart_contents');
if( !function_exists('painting_shop_cart_contents') ) {
	function painting_shop_cart_contents() {
		echo '
	</tbody>
</table>
<table class="shop_table_coupon cart">
    <tbody>
		';
	}
}

// Proceed To Checkout Button HTML Changes  -------------------------------------------------------
remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20 );
add_action( 'woocommerce_proceed_to_checkout', 'painting_shop_proceed_to_checkout');
if( !function_exists('painting_shop_proceed_to_checkout') ) {
	function painting_shop_proceed_to_checkout() {
		$checkout_url = WC()->cart->get_checkout_url();
		?>
		<a href="<?php echo esc_url($checkout_url); ?>" class="checkout-button alt wc-forward dt-sc-button medium"><?php esc_html_e( 'Proceed to Checkout', 'painting' ); ?><span class="fa fa-shopping-cart"></span></a>
		<?php
	}
}

// Customize Cross Sell Products In Product Single Page
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_cart_collaterals', 'painting_shop_cross_sell_display', 30 );
if( !function_exists('painting_shop_cross_sell_display') ){
	function painting_shop_cross_sell_display() {
		
		$product_layout = painting_option('woo',"shop-other-product-layout");
		$product_layout = !empty($product_layout) ? $product_layout : 'one-third-column';

		if($product_layout == 'one-half-column') $related_column = 2;
		elseif($product_layout == 'one-third-column') $related_column = 3;
		elseif($product_layout == 'one-fourth-column') $related_column = 4;
		else $related_column = 3;
		
		woocommerce_cross_sell_display( $posts_per_page = $related_column, $columns = $related_column, $orderby = 'rand' );
							
	}
}


// Customize Cross Sell Products In Product Single Page
add_action( 'pre_get_posts', 'painting_shop_custom_loop_query' );
if( !function_exists('painting_shop_custom_loop_query') ){
	function painting_shop_custom_loop_query( $q ) {
	
		if ( ! $q->is_main_query() ) return;
		if ( ! $q->is_post_type_archive() ) return;
		
		if ( ! is_admin() && is_shop() ) {
			
			$woo = (painting_option('woo') != '') ? painting_option('woo') : array();
			if(array_key_exists('shop-include-categories', $woo)) {
				$cats = priority_option('woo','shop-include-categories');
			} else {
				$pcats = get_categories('taxonomy=product_cat&hide_empty=0');
				$cats = array();
				foreach($pcats as $pcat) $cats[] = $pcat->term_id;
			}

			$q->set( 'tax_query', array(array(
				'taxonomy' => 'product_cat',
				'field' => 'id',
				'terms' => $cats,
				'operator' => 'IN'
			)));
		
		}
	
		remove_action( 'pre_get_posts', 'custom_pre_get_posts_query' );
	
	}
}

// Customize Sale, Out Of Stock and Featured notices
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action('woocommerce_before_single_product_summary','painting_shop_notices_flash',10);
if (!function_exists('painting_shop_notices_flash')) {
function painting_shop_notices_flash() {
	global $product, $post;
	if($product->is_featured()) echo apply_filters( 'woocommerce_sale_flash', '<div class="featured-tag"><div><i class="fa fa-thumb-tack"></i><span>'.esc_html__( 'Featured', 'painting' ).'</span></div></div>', $post, $product ); 
	if($product->is_on_sale() and $product->is_in_stock()) echo apply_filters('woocommerce_sale_flash', '<span class="onsale"><span>'.esc_html__( 'Sale!', 'painting' ).'</span></span>', $post, $product);
	elseif(!$product->is_in_stock()) echo apply_filters( 'woocommerce_sale_flash', '<span class="out-of-stock"><span>'.esc_html__( 'Out of Stock', 'painting' ).'</span></span>', $post, $product );
}
}

//	WooCommerce - Ensure cart contents updated when products are added to the cart via AJAX
add_filter('woocommerce_add_to_cart_fragments', 'painting_header_add_to_cart_fragment'); // WooCommerce 2.3 +
if (!function_exists('painting_header_add_to_cart_fragment')) {
function painting_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	
	ob_start();

	$out = '<div class="shopping-cart">';
		$woo_cart_list = WC()->cart->get_cart();
		if(!empty($woo_cart_list)) {
			$out .= '<ul class="product_cart_list">';
			foreach($woo_cart_list as $cart_key => $cart_item) {
				$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_key );
				$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_key );
				$product_title = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_key );
				$product_permalink = $_product->get_permalink();
				$thumnail_id = get_post_thumbnail_id( $product_id );
				$thumbnail_attrs = wp_get_attachment_image_src($thumnail_id, 'shop_thumbnail');
				$out .= '<li>
							<a href="'.$product_permalink.'"><img src="'.$thumbnail_attrs[0].'" alt="'.$product_title.'" title="'.$product_title.'" class="primary-image" />'.$product_title.'</a>
							'.apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" title="%s"><span class="remove fa fa-times"></span></a>', esc_url( WC()->cart->get_remove_url( $cart_key ) ), esc_html__( 'Remove this item', 'painting' ) ), $cart_key ).'
							<div class="product-details">
								'.esc_html__('Quantity', 'painting').' <span>'.apply_filters( 'woocommerce_cart_item_quantity', $cart_item['quantity'], $cart_key ).'</span>
								<p class="quantity"><span class="amount">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_key ).'</span> '.$_product->get_sku().'</p>
							</div>
						</li>';
			}
			$out .= '</ul>';
			$out .= '<p class="total">'.esc_html__('Total', 'painting').'<span class="amount">'.WC()->cart->get_cart_subtotal().'</span></p>';
			$checkout_url = WC()->cart->get_checkout_url();
			$cart_url = WC()->cart->get_cart_url();
			$out .= '<p class="buttons"><a href="'.esc_url($checkout_url).'">'.esc_html__('Checkout', 'painting').'</a><a href="'.esc_url($cart_url).'">'.esc_html__('View Cart', 'painting').'</a></p>';
		} else {
			$out .= '<p>'.esc_html__('No product(s) in your cart!', 'painting').'</p>';
		}
	$out .= '</div>';
	
	echo painting_wp_kses($out);
	$fragments['div.shopping-cart'] = ob_get_clean();
	
	return $fragments;
}
}

// Customize lost password message
add_filter( 'woocommerce_lost_password_message', 'painting_lost_password_message' );
if( !function_exists('painting_lost_password_message') ) {
	function painting_lost_password_message() {
		return '<div class="dt-sc-info-box">'.esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'painting' ).'</div>';
	}
}

// Customize order received text
add_filter( 'woocommerce_thankyou_order_received_text', 'painting_thankyou_order_received_text' );
if( !function_exists('painting_thankyou_order_received_text') ) {
	function painting_thankyou_order_received_text() {
		return '<div class="dt-sc-success-box">'.esc_html__( 'Thank you. Your order has been received.', 'painting' ).'</div>';
	}
}
?>