<?php 
add_action("add_meta_boxes", "painting_page_metabox");
add_action('save_post','painting_page_meta_save');
function painting_page_metabox(){
	add_meta_box("page-template-slider-meta-container", esc_html__('Slider Options','painting'), "painting_page_slider_settings", "page", "normal", "default");	
	add_meta_box("page-template-breadcrumb-meta-container", esc_html__('Brreadcrumb Options','painting'), "painting_page_breadcrumb_settings", "page", "normal", "default");	
	add_meta_box("page-template-meta-container", esc_html__('Default page Options','painting'), "painting_page_settings", "page", "normal", "low");
}

	#Slider Meta Box
	function painting_page_slider_settings($args){	
		global $post; 
		$tpl_default_settings = get_post_meta($post->ID,'_tpl_default_settings',TRUE);
		$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
		
		wp_nonce_field( 'dttheme_page_slider_meta_box', 'dttheme_page_slider_meta_box_nonce' );
		?>

		<!-- Show Slider -->        
        <div class="custom-box">
        	<div class="column one-sixth">
                <label><?php esc_html_e('Show Slider','painting');?> </label>
            </div>
            <div class="column four-sixth last">
				<?php $switchclass = array_key_exists("show_slider",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                      $checked = array_key_exists("show_slider",$tpl_default_settings) ? ' checked="checked"' : '';?>
                <div data-for="dttheme-show-slider" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                <input id="dttheme-show-slider" class="hidden" type="checkbox" name="dttheme-show-slider" value="true"  <?php echo esc_attr($checked);?>/>
                <p class="note"> <?php esc_html_e('YES! to show slider on this page.','painting');?> </p>
            </div>
        </div><!-- Show Slider End-->

        <!-- Slider Types -->
        <div class="custom-box">
        	<div class="column one-sixth">
                <label><?php esc_html_e('Choose Slider','painting');?></label>
            </div>
            <div class="column four-sixth last">
	            <?php $slider_types = array( '' => esc_html__("Select",'painting'),
											 'layerslider' => esc_html__("Layer Slider",'painting'),
											 'revolutionslider' => esc_html__("Revolution Responsive",'painting'),
											 'imageonly' => esc_html__( "Image Only", 'painting') );
											 
	 				  $v =  array_key_exists("slider_type",$tpl_default_settings) ?  $tpl_default_settings['slider_type'] : '';
					  
					  echo "<select class='slider-type' name='dttheme-slider-type'>";
					  foreach($slider_types as $key => $value):
					  	$rs = selected($key,$v,false);
						echo "<option value='{$key}' {$rs}>{$value}</option>";
					  endforeach;
	 				 echo "</select>";?>
            <p class="note"> <?php esc_html_e("Choose which slider you wish to use ( eg: Layer or Revolution )",'painting');?> </p>
            </div>
        </div><!-- Slider Types End-->
        
        <!-- slier-container starts-->
    	<div id="slider-conainer">
        <?php $layerslider = $revolutionslider = $imageonly = 'display:none';
			  if(isset($tpl_default_settings['slider_type'])&& $tpl_default_settings['slider_type'] == "layerslider"):
			  	$layerslider = 'display:block';
			  elseif(isset($tpl_default_settings['slider_type'])&& $tpl_default_settings['slider_type'] == "revolutionslider"):
			  	$revolutionslider = 'display:block';
              elseif(isset($tpl_default_settings['slider_type'])&& $tpl_default_settings['slider_type'] == "imageonly"):
                $imageonly = 'display:block';
			  endif;?>
              
          
              <!-- Layered Slider -->
              <div id="layerslider" class="custom-box" <?php echo 'style="'.$layerslider.'"';?>>
              	<h3><?php esc_html_e('Layer Slider','painting');?></h3>
				<?php
				# Check layer slider active
				if(painting_is_plugin_active('LayerSlider/layerslider.php')):
					$sliders = LS_Sliders::find(array('limit' => 50));
					if(!empty($sliders)):
						echo '<div class="one-half-content">';
						echo '	<div class="bpanel-option-set">';
						echo ' <div class="column one-sixth">';
						echo '	<label>'.esc_html__('Select LayerSlider','painting').'</label>';
						echo ' 	</div>';
						echo ' <div class="column two-sixth">';
						echo '	<select name="layerslider_id" class="dt-chosen-select">';
							echo '		<option value="0">'.esc_html__("Select Slider",'painting').'</option>';
							foreach($sliders as $key => $item):
								$id = $item['id'];
								$name = $item['name'];
								$rs = isset($tpl_default_settings['layerslider_id']) ? $tpl_default_settings['layerslider_id']:'';
								$rs = selected($id,$rs,false);
								echo "	<option value='{$id}' {$rs}>{$name}</option>";
							endforeach;
						echo '	</select>';
						echo '<p class="note">'.esc_html__("Choose Which LayerSlider you would like to use..",'painting').'</p>';
						echo ' 	</div>';
						echo '	</div>';
						echo '</div>';
					else:
						echo '<p id="j-no-images-container">'.esc_html__('Please add atleat one layer slider','painting').'</p>';
					endif;
				else:
					echo '<p id="j-no-images-container">'.esc_html__('Please activate Layered Slider','painting').'</p>';
				endif; ?>
              </div><!-- Layered Slider End-->

              <!-- Revolution Slider -->
              <div id="revolutionslider" class="custom-box" <?php echo 'style="'.$revolutionslider.'"';?>>
	            <h3><?php esc_html_e('Revolution Slider','painting');?></h3>
                <?php
				# Check revolution slider active
				if(painting_is_plugin_active('revslider/revslider.php')):
					$sld = new RevSlider();
					$sliders = $sld->getArrSliders();
					if(!empty($sliders)):
						echo '<div class="one-half-content">';
						echo '	<div class="bpanel-option-set">';
						echo ' <div class="column one-sixth">';
						echo '	<label>'.esc_html__('Select Slider','painting').'</label>';
						echo ' 	</div>';
						echo ' <div class="column three-sixth">';
						echo '	<select name="revolutionslider_id" class="dt-chosen-select">';
							echo '		<option value="0">'.esc_html__("Select Slider",'painting').'</option>';
							foreach($sliders as $key => $item):
								$alias = $item->getAlias();
								$title = $item->getTitle();
								$rs = isset($tpl_default_settings['revolutionslider_id']) ? $tpl_default_settings['revolutionslider_id']:'';
								$rs = selected($alias,$rs,false);
								echo "	<option value='{$alias}' {$rs}>{$title}</option>";
							endforeach;
						echo '	</select>';
						echo '<p class="note">'.esc_html__("Choose which Revolution slider would you like to use!",'painting').'</p>';
						echo ' 	</div>';
						echo '	</div>';
						echo '</div>';
					else:
						echo '<p id="j-no-images-container">'.esc_html__('Please add atleat one revolution slider','painting').'</p>';
					endif;
				else:
					echo '<p id="j-no-images-container">'.esc_html__('Please activate Revolution Slider , and add at least one slider.','painting').'</p>';
				endif; ?>
              </div><!-- Revolution Slider End-->
              
                <!-- Image Only -->
                <div id="imageonly" <?php echo 'style="'.$imageonly.'"';?>>
                    
                    <div class="custom-box">
                        <div class="column one-sixth"><?php esc_html_e( 'Choose Image','painting');?></div>
                        <div class="column five-sixth last">
                            <div class="image-preview-container">
                                <?php $slider_image = array_key_exists ( "slider_image", $tpl_default_settings ) ? $tpl_default_settings ['slider_image'] : '';?>
                                <input name="slider_image" type="text" class="uploadfield large" readonly="readonly" value="<?php echo esc_url($slider_image);?>"/>
                                <input type="button" value="<?php esc_html_e('Upload','painting');?>" class="upload_image_button show_preview" />
                                <input type="button" value="<?php esc_html_e('Remove','painting');?>" class="upload_image_reset" />
                                <p class="note"><?php esc_html_e("Upload an image instead of slider",'painting');?></p>
                            </div>    
                        </div>
                    </div>
                    
                </div><!-- Image Only -->
                              
        </div><!-- slier-container ends-->
        
<?php  wp_reset_postdata();
	}
	
	function painting_page_breadcrumb_settings($args){	
		global $post; 
		$tpl_default_settings = get_post_meta($post->ID,'_tpl_default_settings',TRUE);
		$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
		
		wp_nonce_field( 'dttheme_page_breadcrumb_meta_box', 'dttheme_page_breadcrumb_meta_box_nonce' );
		?>
        
        <div class="custom-box">
            <div class="column one-fourth">
                <label><?php esc_html_e('Disable Breadcrumb Section','painting');?> </label>
            </div>
            <div class="column three-fourth last">
                <?php $switchclass = array_key_exists('disable-breadcrumb-section',$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                      $checked = array_key_exists('disable-breadcrumb-section',$tpl_default_settings) ? ' checked="checked"' : '';?>
                <div data-for="dttheme-disable-breadcrumb-section" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                <input id="dttheme-disable-breadcrumb-section" class="hidden" type="checkbox" name="dttheme-disable-breadcrumb-section" value="true"  <?php echo esc_attr($checked);?>/>
                <p class="note"> <?php esc_html_e('YES! to disable breadcrumb section completely from this page.','painting');?> </p>
            </div>
        </div>
        

        <div class="custom-box">
        	<div class="column one-fourth">
                <label><?php esc_html_e('Enable Beadcrumb Settings','painting');?> </label>
            </div>
            <div class="column three-fourth last">
				<?php $switchclass = array_key_exists('enable-breadcrumb-settings',$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                      $checked = array_key_exists('enable-breadcrumb-settings',$tpl_default_settings) ? ' checked="checked"' : '';?>
                <div data-for="dttheme-enable-breadcrumb-settings" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                <input id="dttheme-enable-breadcrumb-settings" class="hidden" type="checkbox" name="dttheme-enable-breadcrumb-settings" value="true"  <?php echo esc_attr($checked);?>/>
                <p class="note"> <?php esc_html_e('To enable breadcrumb settings configured below for this page','painting');?> </p>
            </div>
        </div>
        
        <div class="custom-box">
        
        	<div class="column one-half">
                <div class="column one-fourth"><?php esc_html_e('Enable Color Overlay','painting');?></div>
                <div class="column three-fourth last">
                    <select id="dttheme-breadcrumb-overlay" name="dttheme-breadcrumb-overlay" class="dt-chosen-select">
                        <?php
                        $breadcrumb_overlay = array_key_exists('breadcrumb-overlay', $tpl_default_settings) ? $tpl_default_settings['breadcrumb-overlay'] : '';
                        $breadcrumb_overlays = array('' => 'None', 'color-overlay' => 'Color Overlay');
                        foreach($breadcrumb_overlays as $breadcrumb_overlays_key => $breadcrumb_overlay_item):
                            $s = selected($breadcrumb_overlay, $breadcrumb_overlays_key, false);
                            echo '<option value="'.$breadcrumb_overlays_key.'" '.$s.' >'.$breadcrumb_overlay_item.'</option>';
                        endforeach;
                        ?>
                    </select>
                    <p class="note"><?php esc_html_e('You can enable overlay for your breadcrumb here. Make sure you have choosen background image and background color for breadcrumb.', 'painting');?></p>
                </div>
            </div>
            
        	<div class="column one-half last">
                <div class="column one-fourth"><?php esc_html_e('Background Image','painting');?></div>
                <div class="column three-fourth last">
                    <div class="image-preview-container">
                        <?php $breadcrumb_background_image = array_key_exists('breadcrumb-background-image', $tpl_default_settings) ? $tpl_default_settings ['breadcrumb-background-image'] : '';?>
                        <input name="dttheme-breadcrumb-background-image" type="text" class="uploadfield large" readonly="readonly" value="<?php echo esc_url($breadcrumb_background_image);?>"/>
                        <input type="button" value="<?php esc_html_e('Upload','painting');?>" class="upload_image_button show_preview" />
                        <input type="button" value="<?php esc_html_e('Remove','painting');?>" class="upload_image_reset" />
                        <p class="note"><?php esc_html_e('Upload an background image for your breadcrumb', 'painting');?></p>
                    </div>    
                </div>
            </div>
         
         </div>
         
         <div class="custom-box">   
            
        	<div class="column one-half">
                <div class="column one-fourth"><?php esc_html_e('Background Image Position','painting');?></div>
                <div class="column three-fourth last">
                    <select id="dttheme-breadcrumb-background-image-position" name="dttheme-breadcrumb-background-image-position" class="dt-chosen-select">
                        <?php
                        $breadcrumb_background_image_position = array_key_exists('breadcrumb-background-image-position', $tpl_default_settings) ? $tpl_default_settings['breadcrumb-background-image-position'] : '';
                        $bgimage_positions = array('' => 'None', 'left top' => 'Left Top', 'left center' => 'Left Center', 'left bottom' => 'Left Bottom', 'right top' => 'Right Top', 'right center' => 'Right Center', 'right bottom' => 'Right Bottom', 'center top' => 'Center Top', 'center center' => 'Center Center', 'center bottom' => 'Center Bottom');
                        foreach($bgimage_positions as $bgimage_position_key => $bgimage_position):
                            $s = selected($breadcrumb_background_image_position, $bgimage_position_key, false);
                            echo '<option value="'.$bgimage_position_key.'" '.$s.' >'.$bgimage_position.'</option>';
                        endforeach;
                        ?>
                    </select>
                    <p class="note"><?php esc_html_e('Choose breadcrumb background image posistion', 'painting');?></p>
                </div>
            </div>
            
        	<div class="column one-half last">
                <div class="column one-fourth"><?php esc_html_e('Background Image Repeat','painting');?></div>
                <div class="column three-fourth last">
                    <select id="dttheme-breadcrumb-background-image-repeat" name="dttheme-breadcrumb-background-image-repeat" class="dt-chosen-select">
                        <?php
                        $breadcrumb_background_image_repeat = array_key_exists('breadcrumb-background-image-repeat', $tpl_default_settings) ? $tpl_default_settings['breadcrumb-background-image-repeat'] : '';
                        $bgimage_repeats = array('' => 'None', 'no-repeat' => 'No Repeat', 'repeat' => 'Repeat', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y');
                        foreach($bgimage_repeats as $bgimage_repeat_key => $bgimage_repeat):
                            $s = selected($breadcrumb_background_image_repeat, $bgimage_repeat_key, false);
                            echo '<option value="'.$bgimage_repeat_key.'" '.$s.' >'.$bgimage_repeat.'</option>';
                        endforeach;
                        ?>
                    </select>
                    <p class="note"><?php esc_html_e('Choose breadcrumb background image posistion', 'painting');?></p>
                </div>
            </div>
            
        </div>
        
        <div class="custom-box">
        
        	<div class="column one-half">
                <div class="column one-fourth"><?php esc_html_e('Background Color','painting');?></div>
                <div class="column three-fourth last">
					<?php
                    $breadcrumb_background_color = array_key_exists('breadcrumb-background-color', $tpl_default_settings) ? $tpl_default_settings ['breadcrumb-background-color'] : '';
                    $name  =  'dttheme-breadcrumb-background-color';
                    $value =  ($breadcrumb_background_color != NULL) ? $breadcrumb_background_color : '#';
                    painting_admin_color_picker_two($name, $value);
                    ?>                
                </div>
            </div>
            
        	<div class="column one-half last">
                <div class="column one-fourth"><?php esc_html_e('Background Color Opacity','painting');?></div>
                <div class="column three-fourth last">
					<?php $breadcrumb_background_color_opacity = array_key_exists('breadcrumb-background-color-opacity', $tpl_default_settings) ? $tpl_default_settings ['breadcrumb-background-color-opacity'] : ''; ?>   
                    <input type="text" class="small" name="dttheme-breadcrumb-background-color-opacity" value="<?php echo esc_attr($breadcrumb_background_color_opacity); ?>" />               
                </div>
            </div>

		</div>
                
        <div class="custom-box">
        
        	<div class="column one-half">
                <div class="column one-fourth">
                    <label><?php esc_html_e('Delimiter', 'painting');?></label>
                </div>
                <div class="column three-fourth last">
                    <select id="dttheme-breadcrumb-delimiter" name="dttheme-breadcrumb-delimiter" class="dt-chosen-select">
						<?php
						$breadcrumb_delimiter = array_key_exists('breadcrumb-delimiter', $tpl_default_settings) ? $tpl_default_settings['breadcrumb-delimiter'] : '';
                        $bIcons = array('default','fa-angle-double-right','fa-sort','fa-check','fa-caret-right','fa-double-angle-right','fa-arrow-right','fa-chevron-right','fa-hand-right','fa-plus','fa-remove');
                        foreach($bIcons as $bIcon):
							$s = selected($breadcrumb_delimiter, $bIcon, false);
							echo '<option '.$s.'>'.$bIcon.'</option>';
                        endforeach;
                        ?>
                    </select>
                    <p class="note"><?php esc_html_e('This is the symbol that will appear in between your breadcrumbs', 'painting');?></p>
                </div>
            </div>
            
        	<div class="column one-half last">
                <div class="column one-fourth">
                    <label><?php esc_html_e('Enable Parallax', 'painting');?></label>
                </div>
                <div class="column three-fourth last">
					<?php 
					$switchclass = array_key_exists('enable-breadcrumb-parallax',$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                    $checked = array_key_exists('enable-breadcrumb-parallax',$tpl_default_settings) ? ' checked="checked"' : '';
					?>
                    <div data-for="dttheme-enable-breadcrumb-parallax" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                    <input id="dttheme-enable-breadcrumb-parallax" class="hidden" type="checkbox" name="dttheme-enable-breadcrumb-parallax" value="true"  <?php echo esc_attr($checked);?>/>
                    <p class="note"><?php esc_html_e('YES! to enable parallax effect for your breadcrumb image.', 'painting');?></p>
                </div>
            </div>
            
        </div>
        

	<?php
	}
	
	
	#Page Meta Box	
	function painting_page_settings($args){
		 
		global $post; 
		$tpl_default_settings = get_post_meta($post->ID,'_tpl_default_settings',TRUE);
		$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings  : array();
		
		wp_nonce_field( 'dttheme_page_settings_meta_box', 'dttheme_page_settings_meta_box_nonce' );
		?>
        
        <div class="j-pagetemplate-container">
        
        	<div id="tpl-default-settings">
                <div class="custom-box">
                    <div class="column one-sixth">
                        <label><?php esc_html_e('Template','painting');?> </label>
                    </div>
                    <div class="column four-sixth last">
						<?php $template_value = array_key_exists("template",$tpl_default_settings) ? $tpl_default_settings["template"] : ''; ?>
                        <select class="dt-chosen-select" name="dttheme-template">
                        	<option value="" ><?php echo esc_html__('None', 'painting'); ?></option>
                            <?php 
							$args = array('sort_order' => 'ASC', 'sort_column' => 'ID', 'post_type' => 'dt_templates', 'post_status' => 'publish', 'posts_per_page' => -1); 
							$templates = get_posts($args); 
							foreach($templates as $template) {
								$template_id = $template->ID;
								$template_name = $template->post_title;
								echo '<option value="'.$template_id.'" '.selected($template_value,$template_id,false).'>'.$template_name.'</option>';	
							}
							?>
                        </select>
                        <p class="note"> <?php esc_html_e('You can choose predefined template for this page here. Custom changes you have created in template page will be applied for this page.','painting');?> </p>
                    </div>
                </div>
                <div class="custom-box">
                    <div class="column one-sixth">
                        <label><?php esc_html_e('Custom CSS','painting');?></label>
                    </div>
                    <div class="column five-sixth last">
                        <?php $v = array_key_exists("custom-css",$tpl_default_settings) ?  $tpl_default_settings['custom-css'] : '';?>
                        <textarea rows="6" cols="59" id="dttheme-custom-css" name="dttheme-custom-css"><?php echo esc_attr($v);?></textarea>
                        <p class="note"> <?php esc_html_e('Paste your custom CSS code for this page.','painting');?> </p>
                    </div>
                </div>
            </div>
            
        	<div id="tpl-common-settings">

            	<!-- 1. Layout -->
                <div id="page-layout" class="custom-box">
                	<div class="column one-sixth"><label><?php esc_html_e('Layout','painting');?> </label></div>
                    <div class="column five-sixth last">
                    	<ul class="bpanel-layout-set"><?php 
							$homepage_layout = array(
                                'content-full-width'=>'without-sidebar',
                                'with-left-sidebar'=>'left-sidebar',
                                'with-right-sidebar'=>'right-sidebar');
                            
                            	$v =  array_key_exists("layout",$tpl_default_settings) ?  $tpl_default_settings['layout'] : 'content-full-width';
							
							foreach($homepage_layout as $key => $value):
								$class = ($key == $v) ? " class='selected' " : "";
								echo "<li><a href='#' rel='{$key}' {$class}><img src='".PAINTING_URI."/framework/theme-options/images/columns/{$value}.png' alt='' /></a></li>";
							endforeach;?></ul>

                         <input id="dttheme-page-layout" name="layout" type="hidden"  value="<?php echo esc_attr($v); ?>"/>
                         <p class="note"> <?php esc_html_e("You can choose between a left, right or no sidebar layout.",'painting');?> </p>
                    </div>
                 </div> <!-- Layout End-->
    
				 <?php 
                 $sb_layout = array_key_exists("layout",$tpl_default_settings) ? $tpl_default_settings['layout'] : 'content-full-width';
                 $sidebar_both = $sidebar_left = $sidebar_right = '';
                 if($sb_layout == 'content-full-width') {
                    $sidebar_both = 'display:none;'; 
                 } elseif($sb_layout == 'with-left-sidebar') {
                    $sidebar_right = 'display:none;'; 
                 } elseif($sb_layout == 'with-right-sidebar') {
                    $sidebar_left = 'display:none;'; 
                 } 
                 ?>
                <div id="widget-area-options" <?php echo 'style="'.$sidebar_both.'"'; ?>>
                    
                    <div id="left-sidebar-container" class="page-left-sidebar" <?php echo 'style="'.$sidebar_left.'"'; ?>>
                        <!-- 2. Standard Sidebar Left Start -->
                        <div id="page-commom-sidebar" class="sidebar-section custom-box">
                            <div class="column one-sixth"><label><?php esc_html_e('Disable Standard Sidebar Left','painting');?></label></div>
                            <div class="column five-sixth last"><?php 
                                $switchclass = array_key_exists("disable-standard-sidebar-left",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                                $checked = array_key_exists("disable-standard-sidebar-left",$tpl_default_settings) ? ' checked="checked"' : '';?>
                                
                                <div data-for="dttheme-disable-standard-sidebar-left" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                                <input id="dttheme-disable-standard-sidebar-left" class="hidden" type="checkbox" name="disable-standard-sidebar-left" value="true"  <?php echo esc_attr($checked);?>/>
                                <p class="note"> <?php esc_html_e('Yes! to hide "Standard Sidebar" on this page.','painting');?> </p>
                             </div>
                        </div><!-- Standard Sidebar Left End-->
    
                        <!-- 3. Choose Widget Areas Start -->
                        <div id="page-sidebars" class="sidebar-section custom-box page-widgetareas">
                            <div class="column one-sixth"><label><?php esc_html_e('Choose Widget Area - Left Sidebar','painting');?></label></div>
                            <div class="column five-sixth last">
								<?php $widgetareas = array_key_exists("widget-area-left",$tpl_default_settings) ? array_unique($tpl_default_settings["widget-area-left"]) : array();
                                $widgets = painting_option('widgetarea','custom');?>
                                <select class="dt-chosen-select" name="dttheme[widgetareas-left][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Widget Area', 'painting');?>"><?php
                                    echo "<option value=''></option>";
                                    foreach ( $widgets as $widget ) :
                                        $id = mb_convert_case($widget['name'], MB_CASE_LOWER, "UTF-8");
                                        $id = str_replace(" ", "-", $id);
                                        $selected = in_array( $id , $widgetareas ) ? " selected='selected' " : "";
                                        echo "<option value='{$id}' {$selected}>{$widget['name']}</option>";
                                    endforeach;?>
                                </select>
                            </div>
                        </div><!-- Choose Widget Areas End -->
                    </div>

                    <div id="right-sidebar-container" class="page-right-sidebar" <?php echo 'style="'.$sidebar_right.'"'; ?>>
                        <!-- 3. Standard Sidebar Right Start -->
                        <div id="page-commom-sidebar" class="sidebar-section custom-box page-right-sidebar">
                            <div class="column one-sixth"><label><?php esc_html_e('Disable Standard Sidebar Right','painting');?></label></div>
                            <div class="column five-sixth last"><?php 
                                $switchclass = array_key_exists("disable-standard-sidebar-right",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                                $checked = array_key_exists("disable-standard-sidebar-right",$tpl_default_settings) ? ' checked="checked"' : '';?>
                                
                                <div data-for="dttheme-disable-standard-sidebar-right" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                                <input id="dttheme-disable-standard-sidebar-right" class="hidden" type="checkbox" name="disable-standard-sidebar-right" value="true"  <?php echo esc_attr($checked);?>/>
                                <p class="note"> <?php esc_html_e('Yes! to hide "Standard Sidebar" on this page.','painting');?> </p>
                             </div>
                        </div><!-- Standard Sidebar Right End-->
                        
                        <!-- 3. Choose Widget Areas Start -->
                        <div id="page-sidebars" class="sidebar-section custom-box page-widgetareas">
                            <div class="column one-sixth"><label><?php esc_html_e('Choose Widget Area - Right Sidebar','painting');?></label></div>
                            <div class="column five-sixth last">
								<?php $widgetareas = array_key_exists("widget-area-right",$tpl_default_settings) ? array_unique($tpl_default_settings["widget-area-right"]) : array();
                                $widgets = painting_option('widgetarea','custom');?>
                                <select class="dt-chosen-select" name="dttheme[widgetareas-right][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Widget Area', 'painting');?>"><?php
                                    echo "<option value=''></option>";
                                    foreach ( $widgets as $widget ) :
                                        $id = mb_convert_case($widget['name'], MB_CASE_LOWER, "UTF-8");
                                        $id = str_replace(" ", "-", $id);
                                        $selected = in_array( $id , $widgetareas ) ? " selected='selected' " : "";
                                        echo "<option value='{$id}' {$selected}>{$widget['name']}</option>";
                                    endforeach;?>
                                </select>
                            </div>
                        </div><!-- Choose Widget Areas End -->
                    </div>
                    
                </div>
                
            </div><!-- .tpl-common-settings end -->

            <!-- Blog Template Settings -->
            <div id="tpl-blog">
            
             	<!-- Post Playout -->
                <div class="custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Posts Layout','painting');?> </label></div>
                    
                    <div class="column five-sixth last">
                    	<ul class="bpanel-post-layout bpanel-layout-set"><?php 
							$posts_layout = array(	
                                'one-column'=>	esc_html__("Single post per row.",'painting'),
                                'one-half-column'=>	esc_html__("Two posts per row.",'painting'),
								'one-third-column'=>	esc_html__("Three posts per row.",'painting'));

                                $v = array_key_exists("blog-post-layout",$tpl_default_settings) ?  $tpl_default_settings['blog-post-layout'] : 'one-column';

                                foreach($posts_layout as $key => $value):
								$class = ($key == $v) ? " class='selected' " : "";
								echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='".PAINTING_URI."/framework/theme-options/images/columns/{$key}.png' alt='' /></a></li>";
							endforeach;?></ul>
                            
                        <input id="dttheme-blog-post-layout" name="dttheme-blog-post-layout" type="hidden" value="<?php echo esc_attr($v);?>"/>
                        <p class="note"> <?php esc_html_e("Choose layout style for your Blog",'painting');?> </p>
                    </div>
                </div><!-- Post Playout End-->

				<!-- Enable Grid Layout -->
                <div class="custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Enable Grid Layout','painting');?></label></div>
                    <div class="column five-sixth last">                     
						<?php $switchclass = array_key_exists("blog-post-gridlayout",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                              $checked = array_key_exists("blog-post-gridlayout",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        <div data-for="dttheme-blog-post-gridlayout" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-blog-post-gridlayout" class="hidden" type="checkbox" name="dttheme-blog-post-gridlayout" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Enable grid layout','painting');?> </p>
                    </div>
                </div><!-- Enable Grid Layout End-->

				<!-- Allow Excerpt -->
                <div class="custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Allow Excerpt','painting');?></label></div>
                    <div class="column five-sixth last">                     
						<?php $switchclass = array_key_exists("blog-post-excerpt",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                              $checked = array_key_exists("blog-post-excerpt",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        <div data-for="dttheme-blog-post-excerpt" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-blog-post-excerpt" class="hidden" type="checkbox" name="dttheme-blog-post-excerpt" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Enable Excerpt','painting');?> </p>
                    </div>
                </div><!-- Allow Excerpt End-->

                <!-- Excerpt Length-->
                <div class="custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Excerpt Length','painting');?></label></div>
                    <div class="column five-sixth last">
                    	<?php $v = array_key_exists("blog-post-excerpt-length",$tpl_default_settings) ?  $tpl_default_settings['blog-post-excerpt-length'] : '45';?>
                        <input id="dttheme-blog-post-excerpt-length" name="dttheme-blog-post-excerpt-length" type="text" value="<?php echo esc_attr($v);?>" />
                        <p class="note"> <?php esc_html_e("Limit! Number of charectors from the content to appear on each blog post (Number Only)",'painting');?> </p>
                    </div>
                </div><!-- Excerpt Length End-->

                <!-- Post Count-->
                <div class="custom-box">
                    <div class="column one-sixth"><label><?php esc_html_e('Post per page','painting');?></label></div>
                    <div class="column five-sixth last">
                        <select name="dttheme-blog-post-per-page">
                            <option value="-1"><?php esc_html_e("All",'painting');?></option>
                            <?php $selected = 	array_key_exists("blog-post-per-page",$tpl_default_settings) ?  $tpl_default_settings['blog-post-per-page'] : ''; ?>
                            <?php for($i=1;$i<=30;$i++):
                                echo "<option value='{$i}'".selected($selected,$i,false).">{$i}</option>";
                                endfor;?>
                        </select>
                        <p class="note"><?php esc_html_e("Your blog pages show at most selected number of posts per page.",'painting');?></p>
                    </div>
                </div><!-- Post Count End-->
                          
                <!-- Categories -->
                <div class="custom-box">
                  <div class="column one-sixth">
                      <label><?php esc_html_e('Choose Categories','painting');?></label>
                  </div>
                  <div class="column five-sixth last"><?php
                      $blog_post_cats = array_key_exists("blog-post-categories",$tpl_default_settings) ? array_unique($tpl_default_settings["blog-post-categories"]) : array();
                      $cats = get_categories ( 'orderby=name&hide_empty=0' );?>
                      <select class="dt-chosen-select" name="dttheme[blog][categories][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Categories', 'painting');?>"><?php
                          echo "<option value=''></option>";
                          foreach ( $cats as $cat ) :
                              $id = esc_attr ( $cat->term_id );
                              $title = esc_html ( $cat->name );
                              $selected = in_array( $id , $blog_post_cats ) ? " selected='selected' " : "";
                              echo "<option value='{$id}' {$selected}>{$title}</option>";
                          endforeach;?>                        	
                      </select>
                      <p class="note"> <?php esc_html_e("You can choose certain categories to include from your blog page.",'painting');?> </p>
                  </div>
                </div><!-- Categories End-->
                
                <!-- Post Meta-->
                <div class="custom-box">
	                <h3><?php esc_html_e('Post Meta Options','painting');?></h3>
                	<?php 
					$post_meta = array(array(
							"id"=>		"disable-format-info",
							"label"=>	esc_html__("Disable the Format info.",'painting'),
							"tooltip"=>	esc_html__("By default the format info will display when viewing your posts. You can choose to disable it here.",'painting')
						), 
						array(
							"id"=>		"disable-date-info",
							"label"=>	esc_html__("Disable the date info.",'painting'),
							"tooltip"=>	esc_html__("By default the date info will display when viewing your posts. You can choose to disable it here.",'painting')
						),
						array(
							"id"=>		"disable-comment-info",
							"label"=>	esc_html__("Disable the comment",'painting'),
							"tooltip"=>	esc_html__("By default the comment will display when viewing your posts. You can choose to disable it here.",'painting')
						),
						array(
							"id"=>		"disable-category-info",
							"label"=>	esc_html__("Disable the category",'painting'),
							"tooltip"=>	esc_html__("By default the category will display when viewing your posts. You can choose to disable it here.",'painting')
						));
					$count = 1;
					foreach($post_meta as $p_meta):
						$last = ($count%3 == 0)?"last":'';
						$id = 		$p_meta['id'];
						$label =	$p_meta['label'];
						$tooltip =  $p_meta['tooltip'];
						$v =  array_key_exists($id,$tpl_default_settings) ?  $tpl_default_settings[$id] : '';
						$rs =		checked($id,$v,false);
						$switchclass = ($v<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';
						
						echo "<div class='one-third-content {$last}'>";
						echo '<div class="bpanel-option-set">';
						echo "<label>{$label}</label>";							
						echo "<div data-for='{$id}' class='checkbox-switch {$switchclass}'></div>";
						echo "<input class='hidden' id='{$id}' type='checkbox' name='dttheme-blog-{$id}' value='{$id}' {$rs} />";
						echo '<p class="note">';
						echo ($tooltip);
						echo '</p>';
						echo '</div>';
						echo '</div>';
						
					$count++;	
					endforeach;
					?>
                </div><!-- Post Meta End-->                
                                
            </div><!-- Blog Template Settings End-->
            
             <!-- Portfolio Template Settings -->
             <div id="tpl-portfolio">
             	<!-- Post Playout -->
                <div class="custom-box">
                    <div class="column one-sixth">                 
                        <label><?php esc_html_e('Posts Layout','painting');?> </label>
                    </div>
                    <div class="column five-sixth last">       
                        <ul class="bpanel-post-layout bpanel-layout-set">
                        <?php $posts_layout = array( 
                                'one-column'=>  esc_html__("Single post per row.",'painting'),
								'one-half-column'=>	esc_html__("Two posts per row.",'painting'),
								'one-third-column'=>	esc_html__("Three posts per row.",'painting'),
								'one-fourth-column' => esc_html__("Four Posts per row",'painting'));
                                $v = array_key_exists("portfolio-post-layout",$tpl_default_settings) ?  $tpl_default_settings['portfolio-post-layout'] : 'one-half-column';
                                foreach($posts_layout as $key => $value):
                                    $class = ($key == $v) ? " class='selected' " : "";
                                    echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='".PAINTING_URI."/framework/theme-options/images/columns/{$key}.png' alt='' /></a></li>";
                                endforeach;?>
                        </ul>
                        <input id="dttheme-portfolio-post-layout" name="dttheme-portfolio-post-layout" type="hidden" value="<?php echo esc_attr($v);?>"/>
                        <p class="note"> <?php esc_html_e("Choose layout style for your Portfolio",'painting');?> </p>
                    </div>      

                </div><!-- Post Playout End-->

             	<!-- Post Types -->
                <div class="custom-box">
                    <div class="column one-sixth">                 
                        <label><?php esc_html_e('Post Types','painting');?> </label>
                    </div>
                    <div class="column five-sixth last">       
                        <?php $selected = array_key_exists("portfolio-type",$tpl_default_settings) ?  $tpl_default_settings['portfolio-type'] : ''; ?>
                        <select id="dttheme-portfolio-type" name="dttheme-portfolio-type" class="dt-chosen-select">
                            <?php 
                            $portfoliotypes = array('' => 'Default', 'type2' => 'Type 2', 'type3' => 'Type 3');
                            foreach($portfoliotypes as $portfoliokey => $portfoliotype):
                                $s = selected($selected, $portfoliokey, false);
                                echo '<option value="'.$portfoliokey.'" '.$s.' >'.$portfoliotype.'</option>';
                            endforeach;
                            ?>
                        </select>
                        <p class="note"> <?php esc_html_e("Choose type for your portfolio items.",'painting');?> </p>
                    </div>      

                </div><!-- Post Types End-->

                <!-- Post Count-->
                <div class="custom-box">
                    <div class="column one-sixth">                 
                        <label><?php esc_html_e('Post per page','painting');?></label>
                    </div>
                    <div class="column five-sixth last">   
                        <select name="dttheme-portfolio-post-per-page">
                            <option value="-1"><?php esc_html_e("All",'painting');?></option>
                            <?php $selected = 	array_key_exists("portfolio-post-per-page",$tpl_default_settings) ?  $tpl_default_settings['portfolio-post-per-page'] : ''; ?>
                            <?php for($i=1;$i<=30;$i++):
                                echo "<option value='{$i}'".selected($selected,$i,false).">{$i}</option>";
                                endfor;?>
                        </select>
                        <p class="note"> <?php esc_html_e("Your portfolio pages show at most selected number of posts per page.",'painting');?> </p>
                    </div>
                </div><!-- Post Count End-->

                <div class="custom-box">
                    <div class="column one-sixth">                
	                    <label><?php esc_html_e('Allow Filters','painting');?></label>
                    </div>
                    <div class="column five-sixth last">                       
						<?php $switchclass = array_key_exists("filter",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                              $checked = array_key_exists("filter",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        <div data-for="dttheme-portfolio-filter" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-portfolio-filter" class="hidden" type="checkbox" name="dttheme-portfolio-filter" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Allow filter options for portfolio items','painting');?> </p>
                    </div>
                </div>
                
                <div class="custom-box">
                    <div class="column one-sixth">                
	                    <label><?php esc_html_e('Enable LoadMore Pagination','painting');?></label>
                    </div>
                    <div class="column five-sixth last">                       
						<?php $switchclass = array_key_exists("loadmore",$tpl_default_settings) ? 'checkbox-switch-on' :'checkbox-switch-off';
                              $checked = array_key_exists("loadmore",$tpl_default_settings) ? ' checked="checked"' : '';?>
                        <div data-for="dttheme-portfolio-loadmore" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input id="dttheme-portfolio-loadmore" class="hidden" type="checkbox" name="dttheme-portfolio-loadmore" value="true"  <?php echo esc_attr($checked);?>/>
                        <p class="note"> <?php esc_html_e('Enabling load more pagination will disable the default pagination.','painting');?> </p>
                    </div>
                </div>
                
                <!-- Categories -->
                <div class="custom-box">
                  <div class="column one-sixth">
                      <label><?php esc_html_e('Choose Categories','painting');?></label>
                  </div>
                  <div class="column five-sixth last">
				  	  <?php
                      $portfolio_cats = array_key_exists("portfolio-categories",$tpl_default_settings) ? array_unique($tpl_default_settings["portfolio-categories"]) : array();
                      $cats = get_categories ( 'taxonomy=portfolio_entries&hide_empty=0' );
					  ?>
                      <select class="dt-chosen-select" name="dttheme[portfolio][categories][]" multiple="multiple" data-placeholder="<?php esc_html_e('Select Categories', 'painting');?>">
					  	  <?php
                          echo "<option value=''></option>";
                          foreach ( $cats as $cat ) :
                              $id = esc_attr ( $cat->term_id );
                              $title = esc_html ( $cat->name );
                              $selected = in_array( $id , $portfolio_cats ) ? " selected='selected' " : "";
                              echo "<option value='{$id}' {$selected}>{$title}</option>";
                          endforeach;
						  ?>                        	
                      </select>
                      <p class="note"> <?php esc_html_e("You can choose only certain categories to show in portfolio items.",'painting');?> </p>
                  </div>
                </div><!-- Categories End-->                
                
             </div><!-- Portfolio Template Settings End-->
             
        </div>    
<?php  wp_reset_postdata();
   } 
   
	function painting_page_meta_save($post_id){

		if ( ! isset( $_POST['dttheme_page_slider_meta_box_nonce'] ) || ! isset( $_POST['dttheme_page_settings_meta_box_nonce'] ) || ! isset( $_POST['dttheme_page_breadcrumb_meta_box_nonce'] ) ) {
			return;
		}
	
		if ( ! wp_verify_nonce( $_POST['dttheme_page_slider_meta_box_nonce'], 'dttheme_page_slider_meta_box' ) ||  ! wp_verify_nonce( $_POST['dttheme_page_breadcrumb_meta_box_nonce'], 'dttheme_page_breadcrumb_meta_box' ) || ! wp_verify_nonce( $_POST['dttheme_page_settings_meta_box_nonce'], 'dttheme_page_settings_meta_box' ) ) {
			return;
		}
	
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
	
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
		} else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}
	
		if ( (key_exists('post_type', $_POST)) && ('page' == $_POST['post_type']) ) :
		
			$settings = array();
			$settings['layout'] = isset($_POST['layout']) ? $_POST['layout'] : '';
			$settings['template'] =  isset($_POST['dttheme-template']) ? $_POST['dttheme-template'] : '';
			$settings['custom-css'] = isset($_POST['dttheme-custom-css']) ? painting_wp_kses($_POST['dttheme-custom-css']) : '';
			
			if($_POST['layout'] == 'with-left-sidebar') {
				$settings['disable-standard-sidebar-left'] = isset($_POST['disable-standard-sidebar-left']) ? $_POST['disable-standard-sidebar-left'] : '';
				$settings['widget-area-left'] = isset($_POST['dttheme']['widgetareas-left']) ? array_unique(array_filter($_POST['dttheme']['widgetareas-left'])) : '';
			} elseif($_POST['layout'] == 'with-right-sidebar') {
				$settings['disable-standard-sidebar-right'] = isset($_POST['disable-standard-sidebar-right']) ? $_POST['disable-standard-sidebar-right'] : '';
				$settings['widget-area-right'] = isset($_POST['dttheme']['widgetareas-right']) ? array_unique(array_filter($_POST['dttheme']['widgetareas-right'])) : '';
			} 
			
			$settings['show_slider'] =  isset($_POST['dttheme-show-slider']) ? $_POST['dttheme-show-slider'] : '';
			$settings['slider_type'] = isset($_POST['dttheme-slider-type']) ? $_POST['dttheme-slider-type'] : '';
			$settings['layerslider_id'] = isset($_POST['layerslider_id']) ? $_POST['layerslider_id'] : '';
			$settings['revolutionslider_id'] = isset($_POST['revolutionslider_id']) ? $_POST['revolutionslider_id'] : '';
			$settings['slider_image'] = isset($_POST['slider_image']) ? $_POST['slider_image']: '';
			
			$settings['disable-breadcrumb-section'] =  isset($_POST['dttheme-disable-breadcrumb-section']) ? $_POST['dttheme-disable-breadcrumb-section'] : '';
			$settings['enable-breadcrumb-settings'] = isset($_POST['dttheme-enable-breadcrumb-settings']) ? $_POST['dttheme-enable-breadcrumb-settings'] : '';
			$settings['breadcrumb-overlay'] = isset($_POST['dttheme-breadcrumb-overlay']) ? $_POST['dttheme-breadcrumb-overlay'] : '';
			$settings['breadcrumb-background-image'] = isset($_POST['dttheme-breadcrumb-background-image']) ? $_POST['dttheme-breadcrumb-background-image'] : '';
			$settings['breadcrumb-background-image-position'] = isset($_POST['dttheme-breadcrumb-background-image-position']) ? $_POST['dttheme-breadcrumb-background-image-position'] : '';
			$settings['breadcrumb-background-image-repeat'] = isset($_POST['dttheme-breadcrumb-background-image-repeat']) ? $_POST['dttheme-breadcrumb-background-image-repeat'] : '';
			$settings['breadcrumb-background-color'] = isset($_POST['dttheme-breadcrumb-background-color']) ? $_POST['dttheme-breadcrumb-background-color'] : '';
			$settings['breadcrumb-background-color-opacity'] = isset($_POST['dttheme-breadcrumb-background-color-opacity']) ? $_POST['dttheme-breadcrumb-background-color-opacity'] : '';
			$settings['breadcrumb-delimiter'] = isset($_POST['dttheme-breadcrumb-delimiter']) ? $_POST['dttheme-breadcrumb-delimiter'] : '';
			$settings['enable-breadcrumb-parallax'] = isset($_POST['dttheme-enable-breadcrumb-parallax']) ? $_POST['dttheme-enable-breadcrumb-parallax'] : '';
			
			
			if( "tpl-blog.php" == $_POST['page_template'] ):
				$settings['blog-post-layout'] = isset($_POST['dttheme-blog-post-layout']) ? $_POST['dttheme-blog-post-layout'] : '';
				$settings['blog-post-per-page'] = isset($_POST['dttheme-blog-post-per-page']) ? $_POST['dttheme-blog-post-per-page'] : '';
				$settings['blog-post-gridlayout'] = isset($_POST['dttheme-blog-post-gridlayout']) ? $_POST['dttheme-blog-post-gridlayout'] : '';
				$settings['blog-post-excerpt'] = isset($_POST['dttheme-blog-post-excerpt']) ? $_POST['dttheme-blog-post-excerpt'] : '';
				$settings['blog-post-excerpt-length'] = isset($_POST['dttheme-blog-post-excerpt-length']) ? painting_wp_kses($_POST['dttheme-blog-post-excerpt-length']) : '';
				$settings['blog-post-categories'] = isset($_POST['dttheme']['blog']['categories']) ? $_POST['dttheme']['blog']['categories'] : '';
				$settings['disable-format-info'] = isset($_POST['dttheme-blog-disable-format-info']) ? $_POST['dttheme-blog-disable-format-info'] : '';
				$settings['disable-date-info'] = isset($_POST['dttheme-blog-disable-date-info']) ? $_POST['dttheme-blog-disable-date-info'] : '';
				$settings['disable-comment-info'] = isset($_POST['dttheme-blog-disable-comment-info']) ? $_POST['dttheme-blog-disable-comment-info'] : '';
				$settings['disable-category-info'] = isset($_POST['dttheme-blog-disable-category-info']) ? $_POST['dttheme-blog-disable-category-info'] : '';
			
			elseif( "tpl-portfolio.php" == $_POST['page_template'] || "tpl-portfolio-fullwidth.php" == $_POST['page_template'] ):
				$settings['portfolio-post-layout'] = isset($_POST['dttheme-portfolio-post-layout']) ? $_POST['dttheme-portfolio-post-layout'] : '';
				$settings['portfolio-type'] = isset($_POST['dttheme-portfolio-type']) ? $_POST['dttheme-portfolio-type'] : '';
				$settings['portfolio-post-per-page'] = isset($_POST['dttheme-portfolio-post-per-page']) ? $_POST['dttheme-portfolio-post-per-page'] : '';
				$settings['filter'] = isset($_POST['dttheme-portfolio-filter']) ? $_POST['dttheme-portfolio-filter'] : '';
				$settings['loadmore'] = isset($_POST['dttheme-portfolio-loadmore']) ? $_POST['dttheme-portfolio-loadmore'] : '';
				$settings['portfolio-categories'] = isset($_POST['dttheme']['portfolio']['categories']) ? $_POST['dttheme']['portfolio']['categories'] : '';
				
			elseif( "tpl-feature.php" == $_POST['page_template'] ):
				$settings['feature-menu-icon'] = isset($_POST['dttheme-feature-menu-icon']) ? painting_wp_kses($_POST['dttheme-feature-menu-icon']) : '';
	
			elseif( "tpl-onepage.php" == $_POST['page_template'] ):
				$settings['menulocation'] = isset($_POST['dttheme-menulocation']) ? $_POST['dttheme-menulocation'] : '';

			endif;
			
			update_post_meta($post_id, "_tpl_default_settings", array_filter($settings));
		
		endif;
		
	}
?>