<?php
/* ---------------------------------------------------------------------------
 * Create menu for theme options panel
 * --------------------------------------------------------------------------- */
function painting_create_admin_menu() {
	/**
	 * Creates main options page.
	*/
	add_theme_page( PAINTING_NAME . esc_html__(' Theme Options', 'painting'), PAINTING_NAME . esc_html__(' Options', 'painting'), 'manage_options', 'painting-options', 'painting_options_page'	);
}
add_action('admin_menu', 'painting_create_admin_menu');
require_once(PAINTING_DIR . '/framework/theme-options/settings.php');

/* ---------------------------------------------------------------------------
 * Create function to init dttheme options
 * --------------------------------------------------------------------------- */
add_action('admin_init', 'painting_admin_options_init', 1);
function painting_admin_options_init() {
	register_setting(PAINTING_SETTINGS, PAINTING_SETTINGS);
	add_option(PAINTING_SETTINGS, painting_default_option());

	if (isset($_POST['dttheme-option-save'])) :
		painting_ajax_option_save();
	endif;

	if (isset($_POST['dttheme']['reset'])) :
		delete_option(PAINTING_SETTINGS);
		update_option(PAINTING_SETTINGS, painting_default_option()); # To set Default options
		wp_redirect(admin_url('admin.php?page=parent&reset=true'));
		exit;
	endif;
}

function painting_ajax_option_save() {
	$data = $_POST;
	check_ajax_referer('dttheme_wpnonce', 'dttheme_admin_wpnonce');

	unset($data['_wp_http_referer'], $data['_wpnonce'], $data['action']);
	unset($data['dttheme_admin_wpnonce'], $data['dttheme-option-save'], $data['option_page']);

	$msg = array(
		'success' => false, 
		'message' => esc_html__('Error: Options not saved, please try again.', 'painting')
	);

	$data = array_filter($data['dttheme']);
	
	$output = array();
	foreach($data as $key1 => $value1){
		if(is_array($value1)){
			$output[$key1] = $value1;
			foreach($value1 as $key2 => $value2){
				if(is_array($value2)){
					$output[$key1][$key2] = $value2;
					foreach($value2 as $key3 => $value3){
						if(is_array($value3)){
							$output[$key1][$key2][$key3] = $value3;
							foreach($value3 as $key4 => $value4){
								if(is_array($value4)){
									$output[$key1][$key2][$key3][$key4] = $value4;
								} else {
									$output[$key1][$key2][$key3][$key4] = painting_wp_kses(stripslashes($value4));
								}
							}
						} else {
							$output[$key1][$key2][$key3] = painting_wp_kses(stripslashes($value3));
						}
					}
				} else {
					$output[$key1][$key2] = painting_wp_kses(stripslashes($value2));
				}
			}
		}else{
			$output[$key1] = painting_wp_kses(stripslashes($value1));
		}
	}
	
	$data = $output;
		
	if (get_option(PAINTING_SETTINGS) != $data) {
		if (update_option(PAINTING_SETTINGS, $data))
			$msg = array(
				'success' => 'options_saved',
				'message' => esc_html__('Options Saved.', 'painting')
			);
	} else {
		$msg = array(
			'success' => true,
			'message' => esc_html__('Options Saved.', 'painting')
		);
	}

	$echo = json_encode($msg);
	@header('Content-Type: application/json; charset='.get_option('blog_charset'));
	echo painting_wp_kses($echo);
	exit;
}

/* ---------------------------------------------------------------------------
 * Backup And Restore theme options
 * --------------------------------------------------------------------------- */
add_action('wp_ajax_painting_backup_and_restore_action', 'painting_backup_and_restore_action');
function painting_backup_and_restore_action() {
	
	$save_type = $_POST['type'];
	
	if ($save_type == 'backup_options') :
		$data = array(
			'general' 		=>	painting_option('general'),
			'layout'		=>	painting_option('layout'),
			'widgetarea' 	=>	painting_option('widgetarea'),
			'pageoptions' 	=>	painting_option('pageoptions'),
			'colors'		=>	painting_option("colors"),
			'fonts'			=>	painting_option('fonts'),
			'woo' 			=>	painting_option('woo'),
			"appointments"  =>	painting_option('appointments'),
			'backup'		=>	date('r')
		);
		update_option("dttheme_backup", $data);
		die('1');
	elseif ($save_type == 'restore_options') :
		$data = get_option("dttheme_backup");
		update_option(PAINTING_SETTINGS, $data);
		die('1');
	elseif( $save_type == "reset_options") :
		delete_option(PAINTING_SETTINGS);
		update_option(PAINTING_SETTINGS, painting_default_option()); #To set Default options
		die('1');
	endif;
	
}

/* ---------------------------------------------------------------------------
 * Create function to use wordpress importer for import data
 * --------------------------------------------------------------------------- */
add_action('wp_ajax_painting_ajax_importer', 'painting_ajax_importer');
function painting_ajax_importer() {
	require_once PAINTING_CORE_PLUGIN . '/importer/import.php';
}

/* ---------------------------------------------------------------------------
 * Create function to get theme options
 * --------------------------------------------------------------------------- */
if( !function_exists( 'painting_option' ) ){
	function painting_option($key1, $key2 = '') {
		$options = get_option ( PAINTING_SETTINGS );
		$output = NULL;
	
		if (is_array ( $options )) {
	
			if (array_key_exists ( $key1, $options )) {
				$output = $options [$key1];
				if (is_array ( $output ) && ! empty ( $key2 )) {
					$output = (array_key_exists ( $key2, $output ) && (! empty ( $output [$key2] ))) ? $output [$key2] : NULL;
				}
			} else {
				$output = $output;
			}
		}
		return $output;
	}
}

/* ---------------------------------------------------------------------------
 * Create admin panel image preview
 * --------------------------------------------------------------------------- */
function painting_adminpanel_image_preview($src, $backend = true, $default = "no-image.jpg") {
	$default = ($backend) ? PAINTING_URI . "/framework/theme-options/images/" . $default : PAINTING_URI . "/images/" . $default;
	$src = ! empty ( $src ) ? $src : $default;
	echo "<div class='bpanel-option-help'>\n";
	echo "<a href='' title='' class='a_image_preivew'> <img src='" . PAINTING_URI . "/framework/theme-options/images/image-preview.png' alt='img' /> </a>\n";
	echo "\r<div class='bpanel-option-help-tooltip imagepreview'>\n";
	echo "\r<img src='{$src}' data-default='{$default}'/>";
	echo "\r</div>\n";
	echo "</div>\n";
}

/* ---------------------------------------------------------------------------
 * List all images from specific directory
 * --------------------------------------------------------------------------- */
function painting_listImage($dir) {
	$sociables = array ();
	$icon_types = array (
			'jpg',
			'jpeg',
			'gif',
			'png' 
	);

	if (is_dir ( $dir )) {
		$handle = opendir ( $dir );
		while ( false !== ($dirname = readdir ( $handle )) ) {
			if ($dirname != "." && $dirname != "..") {
				$parts = explode ( '.', $dirname );
				$ext = strtolower ( $parts [count ( $parts ) - 1] );

				if (in_array ( $ext, $icon_types )) {
					$option = $parts [count ( $parts ) - 2];
					$sociables [$dirname] = str_replace ( ' ', '', $option );
				}
			}
		}
		closedir ( $handle );
	}
	return $sociables;
}

/* ---------------------------------------------------------------------------
 * Types of Background option available
 * --------------------------------------------------------------------------- */
function painting_bgtypes($name, $parent, $child) {
	$args = array (
		"bg-patterns" => esc_html__( "Pattern", 'painting' ),
		"bg-custom" => esc_html__( "Custom Background", 'painting' ),
		"bg-none" => esc_html__( "None", 'painting' ) 
	);
	echo '<div class="bpanel-option-set">';
	echo "<label>" . esc_html__( "Background Type", 'painting' ) . "</label>";
	echo "<div class='clear'></div>";
	echo "<select class='bg-type' name='{$name}'>";
	foreach ( $args as $k => $v ) :
		$rs = selected ( $k, painting_option ( $parent, $child ), false );
		echo "<option value='{$k}' {$rs}>{$v}</option>";
	endforeach;
	echo "</select>";
	echo '</div>';
}

/* ---------------------------------------------------------------------------
 * Getting color picker for color option
 * --------------------------------------------------------------------------- */
function painting_admin_color_picker($label, $name, $value, $tooltip = NULL) {
	echo "<div class='bpanel-option-set'>\n";
	if (! empty ( $label )) :
		echo "<label>{$label}</label>";
		echo "<div class='hr_invisible'></div><div class='clear'></div>";
	endif;
	
	echo "<input type='text' class='dt-color-field medium' name='{$name}' value='{$value}' />";

	if ($tooltip != NULL)
		painting_adminpanel_tooltip ( $tooltip );

	echo "</div>\n";
}

/* ---------------------------------------------------------------------------
 * Tooltip for admin panel
 * --------------------------------------------------------------------------- */
function painting_adminpanel_tooltip($tooltip) {
	echo "<div class='bpanel-option-help'>\n";
	echo "<a href='' title=''> <img src='" . PAINTING_URI . "/framework/theme-options/images/help.png' alt='' title='' /> </a>\n";
	echo "\r<div class='bpanel-option-help-tooltip'>\n".$tooltip."\r</div>\n";
	echo "</div>\n";
}

/* ---------------------------------------------------------------------------
 * Getting color picker for color option
 * --------------------------------------------------------------------------- */
function painting_admin_color_picker_two($name, $value) {
	echo "<input type='text' class='dt-color-field small' name='{$name}' value='{$value}' />";
}

/* ---------------------------------------------------------------------------
 * Getting jquery ui slider
 * --------------------------------------------------------------------------- */
function painting_admin_jqueryuislider($label, $id = '', $value = '', $px = "px") {
	$div_value = (! empty ( $value ) && ($px == "px")) ? $value . "px" : $value;
	if($label != '') {
		echo "<label>{$label}</label>";
		echo "<div class='clear'></div>";
	}
	echo "<div id='{$id}' class='dttheme-slider' data-for='{$px}'></div>";
	echo "<input type='hidden' class='' name='{$id}' value='{$value}'/>";
	echo "<div class='dttheme-slider-txt'>{$div_value}</div>";
}

/* ---------------------------------------------------------------------------
 * Getting theme switch button
 * --------------------------------------------------------------------------- */
function painting_switch($label, $parent, $name) {
	$checked = ("true" == painting_option ( $parent, $name )) ? ' checked="checked"' : '';
	$switchclass = ("true" == painting_option ( $parent, $name )) ? 'checkbox-switch-on' : 'checkbox-switch-off';
	echo "<div data-for='dttheme-{$parent}-{$name}' class='checkbox-switch {$switchclass}'></div>";
	echo "<input id='dttheme-{$parent}-{$name}' class='hidden' name='dttheme[{$parent}][{$name}]' type='checkbox' value='true' {$checked} />";
}

/* ---------------------------------------------------------------------------
 * Return List of social icons
 * --------------------------------------------------------------------------- */
function painting_listSocial() {
	$sociables = array('fa-dribbble' => 'Dribble', 'fa-flickr' => 'Flickr', 'fa-github' => 'GitHub', 'fa-pinterest' => 'Pinterest', 'fa-stack-overflow' => 'Stack Overflow', 'fa-twitter' => 'Twitter', 'fa-youtube' => 'YouTube', 'fa-android' => 'Android', 'fa-dropbox' => 'Dropbox', 'fa-instagram' => 'Instagram', 'fa-windows' => 'Windows', 'fa-apple' => 'Apple', 'fa-facebook' => 'Facebook', 'fa-google-plus' => 'Google Plus', 'fa-linkedin' => 'LinkedIn', 'fa-skype' => 'Skype', 'fa-tumblr' => 'Tumblr', 'fa-vimeo-square' => 'Vimeo');
	
	return $sociables;
}

/* ---------------------------------------------------------------------------
 * Getting sub directories from parent directory
 * --------------------------------------------------------------------------- */
function painting_getfolders($directory, $starting_with = "", $sorting_order = 0) {
	if (! is_dir ( $directory ))
		return false;
	$dirs = array ();
	$handle = opendir ( $directory );
	while ( false !== ($dirname = readdir ( $handle )) ) {
		if ($dirname != "." && $dirname != ".." && is_dir ( $directory . "/" . $dirname )) {
			if ($starting_with == "")
				$dirs [] = $dirname;
			else {
				$filter = strstr ( $dirname, $starting_with );
				if ($filter !== false)
					$dirs [] = $dirname;
			}
		}
	}
	
	closedir ( $handle );
	
	if ($sorting_order == 1) {
		rsort ( $dirs );
	} else {
		sort ( $dirs );
	}
	return $dirs;
}

/* ---------------------------------------------------------------------------
 * Getting privacy button action selection box
 * --------------------------------------------------------------------------- */
if ( ! function_exists( 'painting_privacy_btnaction_selection' ) ) {
	function painting_privacy_btnaction_selection($name = '', $selected = "") {
		$actions = array( '' => esc_html__('Dismiss the notification', 'painting'), 'link' => esc_html__('Link to another page', 'painting'), 'info_modal' => esc_html__('Open info modal on privacy and cookies', 'painting') );
	
		$name = ! empty ( $name ) ? "name='dttheme[privacy-bar][{$name}][action]'" : '';
		$out = "<select class='button-select' {$name}>"; // name attribute will be added to this by jQuery menuAdd()
		foreach ( $actions as $key => $value ) :
			$s = selected ( $key, $selected, false );
			$v = $value;
			$out .= "<option value='{$key}' {$s} >{$v}</option>";
		endforeach;
		$out .= "</select>";
	
		return $out;
	}
}

/* ---------------------------------------------------------------------------
 * Add new mimes to use custom font upload
 * --------------------------------------------------------------------------- */
add_filter('upload_mimes', 'painting_upload_mimes');
function painting_upload_mimes( $existing_mimes = array() ){
	$existing_mimes['woff'] = 'font/woff';
	$existing_mimes['ttf'] 	= 'font/ttf';
	$existing_mimes['svg'] 	= 'font/svg';
	$existing_mimes['eot'] 	= 'font/eot';
	return $existing_mimes;
}

?>