<!-- layout -->
<div id="layout" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#tab1"><?php esc_html_e('General', 'painting');?></a></li>
            <li><a href="#tab2"><?php esc_html_e('Header', 'painting');?></a></li>
            <li><a href="#tab3"><?php esc_html_e('Footer', 'painting');?></a></li>
            <li><a href="#tab4"><?php esc_html_e('Custom Css &amp; Js', 'painting');?></a></li>
        </ul>

        <!-- tab1-general -->
        <div id="tab1" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Logo', 'painting');?></h3>
                </div>
                <div class="box-content">
                    <div class="column three-fifth">
                        <div class="bpanel-option-set"><?php
							$logo = array( 
											'id'=> 'logo',
											'options'=> array( 
															'true' => esc_html__('Custom Image Logo', 'painting'),
															 '' => sprintf( esc_html__('Display Site Title %s.', 'painting'), '<small><a href="'.esc_url("options-general.php").'">(click here to edit site title)</a></small>' )
															 )
											);
							$i = 0;
							foreach($logo['options'] as $key => $option):
								$checked = ( $key ==  painting_option('layout',$logo['id']) ) ? ' checked="checked"' : '';
								echo "<label><input type='radio' name='dttheme[layout][$logo[id]]' value='{$key}' $checked />$option</label>";
								if($i == 0):
									echo '<div class="clear"></div>';
								endif;
							$i++;
							endforeach; ?>
                        </div>
                    </div>
                    <div class="column two-fifth last">
                        <p class="note"><?php esc_html_e('You can choose whether you wish to display a custom logo or your site title.', 'painting');?></p>
                    </div>
                    <div class="hr"> </div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Logo', 'painting');?></h6>
                    <div class="image-preview-container">
                        <input id="dttheme-logo" name="dttheme[layout][logo-url]" type="text" class="uploadfield" readonly="readonly" value="<?php echo painting_option('layout','logo-url');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button show_preview" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                        <?php painting_adminpanel_image_preview(painting_option('layout','logo-url'),false,'logo.png');?>
                    </div>
                    <p class="note"><?php esc_html_e('Upload a logo for your theme, or specify the image address of your online logo.', 'painting');?></p>
                    <div class="hr"></div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Retina Logo', 'painting');?></h6>
                    <div class="image-preview-container">
                        <input id="dttheme-retina-logo" name="dttheme[layout][retina-logo-url]" type="text" class="uploadfield" readonly="readonly" value="<?php echo painting_option('layout','retina-logo-url');?>"/>
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button show_preview" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                        <?php painting_adminpanel_image_preview(painting_option('layout','retina-logo-url'),false,'logo@2x.png');?>
                    </div>
                    <p class="note"><?php esc_html_e('Upload a retina logo for your theme, or specify the image address of your online logo.', 'painting');?></p>
                    <div class="clear"></div>

                    <div class="one-half-content">
                        <h6><?php esc_html_e('Width', 'painting');?></h6>
                        <input type="text" class="medium" name="dttheme[layout][retina-logo-width]" value="<?php echo painting_option('layout','retina-logo-width');?>" />
                        <?php esc_html_e('px', 'painting');?>
                    </div>
  
                    <div class="one-half-content last">
                        <h6><?php esc_html_e('Height', 'painting');?></h6>
                        <input type="text" class="medium" name="dttheme[layout][retina-logo-height]" value="<?php echo painting_option('layout','retina-logo-height');?>"/>
                        <?php esc_html_e('px', 'painting');?>
                    </div>
                    <p class="note"><?php esc_html_e('If retina logo is uploaded, enter the standard logo width and height in above respective boxes.', 'painting');?></p>
                    <div class="clear"></div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
            
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Favicon', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                
                	<?php if (!function_exists('has_site_icon')) { ?>
                        <p class="note"><strong><?php esc_html_e('Your wordpress core has new site icon feature, which covers favicons and a few other icons. You can make use of it in Dashboard -> Appearance -> Themes -> Customize -> Site Identity -> Site Icon.', 'painting');?></strong></p>
                        <div class="hr"></div>
                        <div class="clear"></div>

                        <h6><?php esc_html_e('Custom Favicon', 'painting');?></h6>
                        <div class="image-preview-container">
                            <input id="dttheme-favicon" name="dttheme[layout][favicon-url]" type="text" class="uploadfield" value="<?php echo  painting_option('layout','favicon-url');?>" />
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','favicon-url'),false,'favicon.png');?>
                        </div>
                        <p class="note"> <?php esc_html_e('Upload a favicon for your theme, or specify the oneline URL for favicon', 'painting');?>  </p>
                        <div class="hr"></div>
                        <div class="clear"></div>
    
                        <h6><?php esc_html_e('Apple iPhone Icon', 'painting');?></h6>
                        <div class="image-preview-container">
                            <input id="dttheme-apple-icon" name="dttheme[layout][apple-favicon]" type="text" class="uploadfield" value="<?php echo painting_option('layout','apple-favicon');?>"/>
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','apple-favicon'),false,'apple-touch-icon.png');?>
                        </div>
                        <p class="note"> <?php esc_html_e('Upload your custom iPhone icon (57px by 57px), or specify the oneline URL for favicon', 'painting');?>  </p>
                        <div class="hr"></div>
                        <div class="clear"></div>
    
                        <h6><?php esc_html_e('Apple iPhone Retina Icon', 'painting');?></h6>
                        <div class="image-preview-container">
                            <input id="dttheme-apple-icon" name="dttheme[layout][apple-retina-favicon]" type="text" class="uploadfield" value="<?php echo painting_option('layout','apple-retina-favicon');?>"/>
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','apple-retina-favicon'),false,'apple-touch-icon-114x114.png');?>
                        </div>
                        <p class="note"><?php esc_html_e('Upload your custom iPhone retina icon (114px by 114px), or specify the oneline URL for favicon', 'painting');?></p>
                        <div class="hr"></div>
                        <div class="clear"></div>
    
                        <h6><?php esc_html_e('Apple iPad Icon', 'painting');?></h6>
                        <div class="image-preview-container">
                            <input id="dttheme-apple-icon" name="dttheme[layout][apple-ipad-favicon]" type="text" class="uploadfield" value="<?php echo painting_option('layout','apple-ipad-favicon');?>"/>
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','apple-ipad-favicon'),false,'apple-touch-icon-72x72.png');?>
                        </div>
                        <p class="note"> <?php esc_html_e('Upload your custom iPad icon (72px by 72px), or specify the oneline URL for favicon', 'painting');?></p>
                        <div class="hr"></div>
                        <div class="clear"></div>
                        
                        <h6><?php esc_html_e('Apple iPad Retina Icon', 'painting');?></h6>
                        <div class="image-preview-container">
                            <input id="dttheme-apple-icon" name="dttheme[layout][apple-ipad-retina-favicon]" type="text" class="uploadfield" value="<?php echo painting_option('layout','apple-ipad-retina-favicon');?>"/>
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','apple-ipad-retina-favicon'),false,'apple-touch-icon-144x144.png');?>
                        </div>
                        <p class="note"><?php esc_html_e('Upload your custom iPad retina icon (144px by 144px), or specify the oneline URL for favicon', 'painting');?></p>
                    <?php } else { ?>
                    	<p class="note"><strong><?php esc_html_e('Your wordpress core has new site icon feature, which covers favicons and a few other icons. You can make use of it in Dashboard -> Appearance -> Themes -> Customize -> Site Identity -> Site Icon.', 'painting');?></strong></p>
                    <?php } ?>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->

            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Breadcrumb Section', 'painting');?></h3>
                </div>

                <div class="box-content">
                
                    <h6><?php esc_html_e('Breadcrumb Delimiter', 'painting');?></h6>
                    <select id="dttheme-breadcrumb-delimiter" name="dttheme[layout][breadcrumb-delimiter]" class="dt-chosen-select"><?php
                      $bIcons = array('default','fa-angle-double-right','fa-sort','fa-check','fa-caret-right','fa-double-angle-right','fa-arrow-right','fa-chevron-right','fa-hand-right','fa-plus','fa-remove');
					  foreach($bIcons as $bIcon):
						  $s = selected(painting_option('layout','breadcrumb-delimiter'),$bIcon,false);
						  echo "<option $s >$bIcon</option>";
					  endforeach;?>
                    </select>
                    <p class="note"><?php esc_html_e('This is the symbol that will appear in between your breadcrumbs', 'painting');?></p>
                    <div class="hr"></div>
                    <div class="clear"></div>
                    
                    <h6><?php esc_html_e('Enable Breadcrumb Overlay', 'painting');?></h6>
                    <select id="dttheme-breadcrumb-overlay" name="dttheme[layout][breadcrumb-overlay]" class="dt-chosen-select">
                        <?php
                        $breadcrumb_overlay = painting_option('layout','breadcrumb-overlay');
                        $breadcrumb_overlays = array('' => 'None', 'color-overlay' => 'Color Overlay');
                        foreach($breadcrumb_overlays as $breadcrumb_overlays_key => $breadcrumb_overlay_item):
                            $s = selected($breadcrumb_overlay, $breadcrumb_overlays_key, false);
                            echo '<option value="'.$breadcrumb_overlays_key.'" '.$s.' >'.$breadcrumb_overlay_item.'</option>';
                        endforeach;
                        ?>
                    </select>
                    <p class="note"><?php esc_html_e('You can enable overlay for your breadcrumb here. Make sure you have choosen background image and background color for breadcrumb.', 'painting');?></p>
                    <div class="hr"></div>
                    <div class="clear"></div>
                    
                    <h6><?php esc_html_e('Breadcrumb Background Image', 'painting');?></h6>
                    <div class="image-preview-container">
                        <input id="dttheme-breadcrumb-bg-image" name="dttheme[layout][breadcrumb-bg-image]" type="text" class="uploadfield" value="<?php echo painting_option('layout','breadcrumb-bg-image');?>"/>
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                        <?php painting_adminpanel_image_preview(painting_option('layout','breadcrumb-bg-image'),false,'bg.jpg');?>
                    </div>
                    <p class="note"> <?php esc_html_e('You can choose background image for breadcrumb.', 'painting');?></p>
                    <div class="hr_invisible"></div>
                    <div class="clear"></div>
                    
                    <h6><?php esc_html_e('Breadcrumb Background Image Position','painting');?></h6>
                    <select id="dttheme-breadcrumb-bg-image-position" name="dttheme[layout][breadcrumb-bg-image-position]" class="dt-chosen-select">
						<?php 
						$bgimage_positions = array('' => 'None', 'left top' => 'Left Top', 'left center' => 'Left Center', 'left bottom' => 'Left Bottom', 'right top' => 'Right Top', 'right center' => 'Right Center', 'right bottom' => 'Right Bottom', 'center top' => 'Center Top', 'center center' => 'Center Center', 'center bottom' => 'Center Bottom');
                        foreach($bgimage_positions as $bgimage_position_key => $bgimage_position):
                            $s = selected(painting_option('layout','breadcrumb-bg-image-position'), $bgimage_position_key, false);
                            echo '<option value="'.$bgimage_position_key.'" '.$s.' >'.$bgimage_position.'</option>';
                        endforeach;
						?>
                    </select>
                    <p class="note"><?php esc_html_e('You can choose background image position for breadcrumb','painting');?></p>
                    <div class="hr_invisible"></div>
                    <div class="clear"></div>
                                        
                    <h6><?php esc_html_e('Breadcrumb Background Image Repeat','painting');?></h6>
                    <select id="dttheme-breadcrumb-bg-image-repeat" name="dttheme[layout][breadcrumb-bg-image-repeat]" class="dt-chosen-select">
						<?php 
						$bgimage_repeats = array('' => 'None', 'no-repeat' => 'No Repeat', 'repeat' => 'Repeat', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y');
                        foreach($bgimage_repeats as $bgimage_repeat_key => $bgimage_repeat):
                            $s = selected(painting_option('layout','breadcrumb-bg-image-repeat'), $bgimage_repeat_key, false);
                            echo '<option value="'.$bgimage_repeat_key.'" '.$s.' >'.$bgimage_repeat.'</option>';
                        endforeach;
						?>
                    </select>
                    <p class="note"><?php esc_html_e('You can choose background image repeat option for breadcrumb','painting');?></p>
                    <div class="hr"></div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Enable Breadcrumb Parallax','painting');?></h6> 
					<?php $checked = ( "true" ==  painting_option('layout','breadcrumb-enable-parallax') ) ? ' checked="checked"' : ''; ?>
                    <?php $switchclass = ( "true" ==  painting_option('layout','breadcrumb-enable-parallax') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                    <div data-for="breadcrumb-enable-parallax" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                    <input class="hidden" id="breadcrumb-enable-parallax" name="dttheme[layout][breadcrumb-enable-parallax]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    <p class="note"><?php esc_html_e('YES! to enable parallax effect for your breadcrumb image.', 'painting');?></p>
                    
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->

            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Others', 'painting');?></h3>
                </div>

                <div class="box-content">
                	<h6><?php esc_html_e('Layout', 'painting');?></h6>
                	<p class="note no-margin"><?php esc_html_e("Choose the Layout Style(Boxed / Fullwidth)", 'painting');?></p>
                    <div class="hr_invisible"> </div>
					<div class="bpanel-option-set">
                        <ul class="bpanel-layout-set bpanel-post-layout">
                          <?php $layouts = array("boxed","wide");
                                foreach($layouts as $layout):
                                  $class = ( $layout ==  painting_option('layout','site-layout')) ? 'class="selected"' : "";?>
                                  <li class="themelayout"><a href="#" rel="<?php echo esc_attr($layout);?>" <?php echo painting_wp_kses($class);?> title="<?php echo esc_attr($layout);?>">
	                                  <img src="<?php echo esc_url( PAINTING_URI."/framework/theme-options/images/layouts/{$layout}.png" );?>" /></a>
                                  </li>
                          <?php endforeach;?>
                        </ul>
                        <input id="dttheme[layout][site-layout]" name="dttheme[layout][site-layout]" type="hidden" value="<?php echo painting_option('layout','site-layout');?>"/>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->

            <?php $style = (painting_option('layout','site-layout') == "boxed") ? '' :'style="display:none;"'; ?>
	        <div id="boxed" class="bpanel-box" <?php echo painting_wp_kses($style);?>>
                <div class="box-title">
                	<h3><?php esc_html_e('Boxed Layout Background BG', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <?php painting_bgtypes("dttheme[layout][bg-type]","layout","bg-type");?>

                    <?php $bg_pattern = ( painting_option('layout','bg-type')=="bg-patterns" ) ? 'style="display:block"' : 'style="display:none"'; ?>
                    <?php $bg_custom = ( painting_option('layout','bg-type')=="bg-custom" ) ? 'style="display:block"' : 'style="display:none"'; ?>
                
                	<!-- In-built BG Patterns starts-->
                    <div class="bg-pattern" <?php echo painting_wp_kses($bg_pattern);?>>

                    	<div class="hr_invisible"> </div>

                    	<h6> <?php esc_html_e('Choose Patterns', 'painting');?> </h6>
                    	<!-- Pattern Sets Start -->
                    	<div class="bpanel-option-set">
                            <ul class="bpanel-layout-set bpanel-post-layout"><?php
                            	$pattrens  = painting_listImage(PAINTING_DIR . "/images/style-picker/patterns/");
								foreach($pattrens as $key => $value):
									$class = ( $key ==  painting_option('layout','boxed-layout-pattern')) ? " class='selected' " : "";
									echo "<li>";
									echo "<a href='#' rel='{$key}' {$class}><img width='80px' height='80px' src='" . PAINTING_URI . "/images/style-picker/patterns/$key' /></a>";
									echo "</li>";
								endforeach;?>
                            </ul>
                            <input id="dttheme[layout][boxed-layout-pattern]" name="dttheme[layout][boxed-layout-pattern]" type="hidden" value="<?php echo painting_option('layout','boxed-layout-pattern');?>"/>
                            <p class="note"><?php esc_html_e('Choose background pattern, you can add patterns by placing .png files in the folder ', 'painting'); echo ('<b>framework/theme-options/images/patterns/</b>');?></p>
                        </div><!-- Patterns set End -->

                        <!-- Pattern BG Settings -->
                        <div class="column one-column">
                        	<div class="bpanel-option-set">
                                <h6><?php esc_html_e('Boxed Layout Background Pattern repeat', 'painting');?></h6>
                                <div class="clear"></div>
                                <select name="dttheme[layout][boxed-layout-pattern-repeat]" class="dt-chosen-select">
                                    <option value=""><?php esc_html_e("Select", 'painting');?></option>
                                    <?php $options = array("repeat","repeat-x","repeat-y","no-repeat");
										foreach($options as $option):?>
                                        <option value="<?php echo esc_attr($option);?>"
                                            <?php selected($option,painting_option('layout','boxed-layout-pattern-repeat')); ?>><?php echo esc_attr($option);?></option>
                                    <?php endforeach;?>
                                </select>
                                <p class="note"> <?php esc_html_e("Select how would you like to repeat the pattern image", 'painting');?> </p>
                            </div>
                        </div>
                        <div class="hr"> </div>
                        
                        <div class="column one-half">
                            <h6><?php esc_html_e("Disable Background Color", 'painting');?></h6>
                            <?php painting_switch("",'layout','disable-boxed-layout-pattern-color');?>
                        </div>
                            
                        <div class="column one-half last">
                        <?php $label = 		esc_html__("Choose Background Color", 'painting');
                              $name  =		"dttheme[layout][boxed-layout-pattern-color]";
                              $value =  	(painting_option('layout','boxed-layout-pattern-color') != NULL) ? painting_option('layout','boxed-layout-pattern-color') :"#";
                              $tooltip = 	esc_html__("Pick a custom background color of the theme.(e.g. #a314a3)", 'painting');
                              painting_admin_color_picker($label,$name,$value,'');?>
                              <p class="note"><?php echo esc_html($tooltip);?></p>
                        </div><!-- Pattern BG Settings end-->
                        <div class="hr"> </div>
                        
                        <div class="bpanel-option-set">
	                        <?php echo painting_admin_jqueryuislider( esc_html__("Background opacity", 'painting'),	"dttheme[layout][boxed-layout-pattern-opacity]",
                                                                          painting_option("layout","boxed-layout-pattern-opacity"),"");?>
                        </div>
                    </div><!-- In-built BG Patterns ends-->
                     	
                	<!-- Upload custom BG option Starts -->
                    <div class="bg-custom" <?php echo painting_wp_kses($bg_custom);?>>
                        
                        <div class="hr_invisible"> </div>

                        <h6><?php esc_html_e("Boxed Layout Background Image", 'painting');?></h6>
                        <div class="clear"></div>
                        <div class="image-preview-container">
                            <input id="dttheme-boxed-layout-bg" name="dttheme[layout][boxed-layout-bg]" type="text" class="uploadfield large" value="<?php echo painting_option('layout','boxed-layout-bg');?>"/>
                            <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button show_preview" />
                            <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                            <?php painting_adminpanel_image_preview(painting_option('layout','boxed-layout-bg'));?>
                        </div>
                        <p class="note"><?php esc_html_e("Upload an image for the theme's background", 'painting');?> </p>
                       
                       <div class="hr_invisible"> </div>                       
                
                        <!-- Boxed Layout BG Settings -->
                        <div class="column one-half">
                        <?php $bg_settings = array(
                                    array(
                                        "label"=>	esc_html__('Background Image Repeat', 'painting'),
                                        "tooltip"=>	esc_html__("Select how would you like to repeat the background image", 'painting'),
                                        "name" => "dttheme[layout][boxed-layout-bg-repeat]",
                                        "db-key"=>"boxed-layout-bg-repeat",
                                        "options"=>  array("repeat","repeat-x","repeat-y","no-repeat")
                                    ),
                                    array(
                                        "label"=>esc_html__('Background Image Position', 'painting'),
                                        "tooltip"=>	esc_html__("Select how would you like to position the background", 'painting'),
                                        "name" => "dttheme[layout][boxed-layout-bg-position]",
                                        "db-key"=>"boxed-layout-bg-position",
                                        "options"=>  array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right")
                                    )
                              );

                              foreach($bg_settings as $bgsettings): ?>
                                  <div class="bpanel-option-set">
                                    <label><?php echo esc_attr($bgsettings['label']);?></label>
                                    <div class="clear"></div>
                                    <select name="<?php echo esc_attr($bgsettings['name']);?>" class="dt-chosen-select">
                                        <option value=""><?php esc_html_e("Select", 'painting');?></option>
                                        <?php foreach($bgsettings['options'] as $option):?>
                                            <option value="<?php echo esc_attr($option);?>"
                                                <?php selected($option,painting_option('layout',$bgsettings['db-key'])); ?>><?php echo esc_html($option);?></option>
                                        <?php endforeach;?>
                                    </select>
                                    <p class="note"><?php echo esc_html($bgsettings['tooltip']);?></p>
                                    <div class="hr_invisible"> </div>
                                  </div><?php
                              endforeach;?>

                              <div class="bpanel-option-set">
                                 <h6><?php esc_html_e("Disable Background Color", 'painting');?></h6>
                                 <?php painting_switch("",'layout','disable-boxed-layout-bg-color');?>
                              </div>
                        </div><!-- Boxed Layout BG Settings End -->
                        
                         <!-- Boxed Layout BG Color -->
                         <div class="column one-half last">
                            <?php $label = 		esc_html__("Background Color", 'painting');
                                  $name  =		"dttheme[layout][boxed-layout-bg-color]";
                                  $value =  	(painting_option('layout','boxed-layout-bg-color') != NULL) ? painting_option('layout','boxed-layout-bg-color') :"#";
                                  $tooltip = 	esc_html__("Pick a background color of the theme.(e.g. #a314a3)", 'painting');
                                  painting_admin_color_picker($label,$name,$value,'');?>
                                  <p class="note"><?php echo esc_html($tooltip);?></p>
                                  <div class="hr_invisible_large"> </div>
                                
							 <?php echo painting_admin_jqueryuislider( esc_html__("Background opacity", 'painting'),	"dttheme[layout][boxed-layout-bg-opacity]",
                                                                      painting_option("layout","boxed-layout-bg-opacity"),"");?>                                
                         </div><!-- Boxed Layout BG Color -->
                    </div><!-- Upload custom BG option Ends -->
                     
                </div><!-- .box-content -->   
            </div><!-- .bpanel-box -->
        </div><!--tab1-general end-->

        <!-- tab2-header -->
        <div id="tab2" class="tab-content">

            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Header', 'painting');?></h3>
                </div>

                <div class="box-content">
                	<h6><?php esc_html_e('Header Types', 'painting'); ?></h6>
                    <div class="hr_invisible"> </div>
                    <select id="dttheme-header-type" name="dttheme[layout][header-type]" class="dt-chosen-select">
						<?php 
						$header_types = array('default' => 'Default', 'header2' => 'Header 2', 'header3' => 'Header 3', 'header4' => 'Header 4');
                        foreach($header_types as $header_key => $header_type):
                            $s = selected(painting_option('layout','header-type'), $header_key, false);
							echo '<option value="'.$header_key.'" '.$s.' >'.$header_type.'</option>';
                        endforeach;
						?>
                    </select>
                    <p class="note"><?php esc_html_e('You can choose any one of available header styles.','painting');?></p>
                    
                    <div class="clear"></div>
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Left Content','painting');?></h6>
                    <textarea id="dttheme-layout-header-leftcontent" name="dttheme[layout][header-leftcontent]" style="width:540px; height:180px;"><?php echo stripslashes(painting_option('layout','header-leftcontent')); ?></textarea>
                    <p class="note"><?php esc_html_e("Content added here will appear in left side of menu. Applicable only for header 4.",'painting');?></p>

                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Right Content','painting');?></h6>
                    <textarea id="dttheme-layout-header-rightcontent" name="dttheme[layout][header-rightcontent]" style="width:540px; height:180px;"><?php echo stripslashes(painting_option('layout','header-rightcontent')); ?></textarea>
                    <p class="note"><?php esc_html_e("Content added here will appear in right side of menu. Applicable only for header 2, header 3, header 4.",'painting');?></p>
                </div><!-- .box-content -->
            </div>
            
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Top Bar', 'painting');?></h3>
                </div>
                <div class="box-content">
                
                    <h6><?php esc_html_e('Enable Top Bar','painting');?></h6> 
                    <div class="column one-fifth">
                        <?php $checked = ( "true" ==  painting_option('layout','enable-topbar') ) ? ' checked="checked"' : ''; ?>
                        <?php $switchclass = ( "true" ==  painting_option('layout','enable-topbar') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        <div data-for="enable-topbar" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                        <input class="hidden" id="enable-topbar" name="dttheme[layout][enable-topbar]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last"></div>
                    
                    <div class="clear"></div>
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Left Content','painting');?></h6>
                    <textarea id="dttheme-layout-topbar-leftcontent" name="dttheme[layout][topbar-leftcontent]" style="width:540px; height:180px;"><?php echo stripslashes(painting_option('layout','topbar-leftcontent')); ?></textarea>
                    <p class="note"><?php esc_html_e("Content added here will appear in left side of top bar. For header 8 this will be used for top right content along with menu.",'painting');?></p>

                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Right Content','painting');?></h6>
                    <textarea id="dttheme-layout-topbar-rightcontent" name="dttheme[layout][topbar-rightcontent]" style="width:540px; height:180px;"><?php echo stripslashes(painting_option('layout','topbar-rightcontent')); ?></textarea>
                    <p class="note"><?php esc_html_e("Content added here will appear in right side of top bar. For header 8 this will be used for top right content along with logo.",'painting');?></p>

                </div>
            </div>

            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Others', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Enable Sticky Navigation', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-stickynav') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-stickynav') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-enable-stickynav" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-enable-stickynav" name="dttheme[layout][enable-stickynav]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to use sticky header for this site.', 'painting');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!--tab2-header end-->

        <!-- tab3-footer -->
        <div id="tab3" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Footer', 'painting');?></h3>
                </div>
                
                <div class="box-content">

                     <h6><?php esc_html_e('Enable Footer Top Strip', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-footer-topstrip') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-footer-topstrip') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-footer-topstrip" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-footer-topstrip" name="dttheme[layout][enable-footer-topstrip]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note no-margin"><?php esc_html_e('Yes! to enable footer top strip.', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[layout][footer-topstrip]" name="dttheme[layout][footer-topstrip]"><?php echo stripslashes(painting_option('layout', 'footer-topstrip'));?></textarea>
                     
                    <div class="hr"></div>
                    <div class="clear"></div>


                    <h6><?php esc_html_e('Enable Footer Column Layout', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-footer') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-footer') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-footer" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-footer" name="dttheme[layout][enable-footer]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to use footer columns for this site.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Footer Column Layout', 'painting');?></h6>
                    <p class="note"><?php esc_html_e("Select a perfect column layout style for your theme's footer.", 'painting');?></p>
                    <ul class="bpanel-layout-set bpanel-post-layout">
                    <?php $footer_layouts = array(
                                1=>'one-column',							2=>'one-half-column',
                                3=>'one-third-column',						4=>'one-fourth-column',
                                5=>'one-fifth-column',						6=>'onefourth-onefourth-onehalf-column',	
                                7=>'onehalf-onefourth-onefourth-column', 	8=>'onefourth-threefourth-column',			
                                9=>'threefourth-onefourth-column',			10=>'onethird-twothird-column',
                                11=>'twothird-onethird-column');
                    //Footer layout options...
                    foreach($footer_layouts as $k => $v): $class = ( $k ==  painting_option('layout','footer-columns')) ? " class='selected' " : "";?>
                        <li><a href="#" rel="<?php echo esc_attr($k);?>" <?php echo painting_wp_kses($class);?>><img src="<?php echo PAINTING_URI . "/framework/theme-options/images/columns/{$v}.png";?>" /></a></li>
                    <?php endforeach;?>
                    </ul><input id="dttheme[layout][footer-columns]" name="dttheme[layout][footer-columns]" type="hidden" value="<?php echo painting_option('layout','footer-columns');?>"/>

                    <div class="hr"></div>

                    <h6><?php esc_html_e('Footer Background Image', 'painting');?></h6>
                    <div class="image-preview-container">
                        <input id="dttheme-footer-background-image" name="dttheme[layout][footer-background-image]" type="text" class="uploadfield" value="<?php echo painting_option('layout','footer-background-image');?>" />
                        <input type="button" value="<?php esc_html_e('Upload', 'painting');?>" class="upload_image_button show_preview" />
                        <input type="button" value="<?php esc_html_e('Remove', 'painting');?>" class="upload_image_reset" />
                        <?php painting_adminpanel_image_preview(painting_option('layout','footer-background-image'),false,'footer-bg.jpg');?>
                    </div>
                    <p class="note"><?php esc_html_e('Upload an image for footer background, or specify the image address of your online background.', 'painting');?></p>
                    
                    <div class="hr_invisible"></div>
                    <div class="clear"></div>
                    
                    <h6><?php esc_html_e('Footer Background Image Position','painting');?></h6>
                    <select id="dttheme-footer-bg-image-position" name="dttheme[layout][footer-bg-image-position]" class="dt-chosen-select">
						<?php 
						$bgimage_positions = array('none' => 'None', 'left top' => 'Left Top', 'left center' => 'Left Center', 'left bottom' => 'Left Bottom', 'right top' => 'Right Top', 'right center' => 'Right Center', 'right bottom' => 'Right Bottom', 'center top' => 'Center Top', 'center center' => 'Center Center', 'center bottom' => 'Center Bottom');
                        foreach($bgimage_positions as $bgimage_position_key => $bgimage_position):
                            $s = selected(painting_option('layout','footer-bg-image-position'), $bgimage_position_key, false);
                            echo '<option value="'.$bgimage_position_key.'" '.$s.' >'.$bgimage_position.'</option>';
                        endforeach;
						?>
                    </select>
                    <p class="note"><?php esc_html_e('You can choose background image position for footer','painting');?></p>
                    <div class="hr_invisible"></div>
                    <div class="clear"></div>
                    
                    <h6><?php esc_html_e('Footer Background Image Repeat','painting');?></h6>
                    <select id="dttheme-footer-bg-image-repeat" name="dttheme[layout][footer-bg-image-repeat]" class="dt-chosen-select">
						<?php 
						$bgimage_repeats = array('no-repeat' => 'No Repeat', 'repeat' => 'Repeat', 'repeat-x' => 'Repeat X', 'repeat-y' => 'Repeat Y');
                        foreach($bgimage_repeats as $bgimage_repeat_key => $bgimage_repeat):
                            $s = selected(painting_option('layout','footer-bg-image-repeat'), $bgimage_repeat_key, false);
                            echo '<option value="'.$bgimage_repeat_key.'" '.$s.' >'.$bgimage_repeat.'</option>';
                        endforeach;
						?>
                    </select>
                    <p class="note"><?php esc_html_e('You can choose background image repeat option for footer','painting');?></p>
                    
                    <div class="hr"></div>
                    <div class="clear"></div>
                    
                     <h6><?php esc_html_e('Show Copyright Text', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-copyright') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-copyright') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-copyright" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-copyright" name="dttheme[layout][enable-copyright]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note no-margin"><?php esc_html_e('You can paste your copyright text in this box. This will be automatically added to the footer.', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[layout][copyright-content]" name="dttheme[layout][copyright-content]"><?php echo stripslashes(painting_option('layout', 'copyright-content'));?></textarea>
                     
                    <div class="hr"></div>
                    <div class="clear"></div>
                    
                     <h6><?php esc_html_e('Show Footer Menu', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-footer-menu') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-footer-menu') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-footer-menu" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-footer-menu" name="dttheme[layout][enable-footer-menu]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note no-margin"><?php esc_html_e('You can enable the footer menu here.', 'painting');?></p>
                     </div>

                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!--tab3-footer end-->

        <!-- tab4-hooks -->
        <div id="tab4" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Custom CSS', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Custom CSS', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-customcss') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-customcss') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-customcss" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-customcss" name="dttheme[layout][enable-customcss]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your custom CSS code here.', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[layout][customcss-content]" name="dttheme[layout][customcss-content]"><?php echo stripslashes(painting_option('layout', 'customcss-content'));?></textarea>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            

            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Custom JS', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Custom JS', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('layout','enable-customjs') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('layout','enable-customjs') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-layout-customjs" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-layout-customjs" name="dttheme[layout][enable-customjs]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note no-margin"><?php esc_html_e('Paste your custom JS code here. <br><b>To use jQuery code wrap it into jQuery(function($){ ... });</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[layout][customjs-content]" name="dttheme[layout][customjs-content]"><?php echo stripslashes(painting_option('layout', 'customjs-content'));?></textarea>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!--tab4-hooks end-->

    </div><!-- .bpanel-main-content end-->
</div><!-- layout end-->