<!-- pageoptions -->
<div id="pageoptions" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#tab1"><?php esc_html_e('Post', 'painting');?></a></li>
            <li><a href="#tab2"><?php esc_html_e('Portfolio', 'painting');?></a></li>
			<li><a href="#tab3"><?php esc_html_e('404', 'painting');?></a></li>
            <li><a href="#tab4"><?php esc_html_e('Hooks', 'painting');?></a></li>
        </ul>
        
        <!-- tab1-post -->
        <div id="tab1" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Post Single', 'painting');?></h3>
                </div>
                
                <div class="box-content">

                    <h6><?php esc_html_e('Single Author Box', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','single-post-authorbox') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','single-post-authorbox') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-single-post-authorbox" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-single-post-authorbox" name="dttheme[pageoptions][single-post-authorbox]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display author box in single blog posts.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Single Posts Comments', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','single-post-comments') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','single-post-comments') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-single-post-comments" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-single-post-comments" name="dttheme[pageoptions][single-post-comments]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display single blog post comments.', 'painting');?></p>
                    </div>

				</div><!-- .box-content -->
                
                <div class="box-title">
                    <h3><?php esc_html_e('Post Archives', 'painting');?></h3>
                </div>
                
                <div class="box-content">

                    <h6><?php esc_html_e('Page Layout', 'painting');?></h6>
                    <p class="note no-margin"> <?php esc_html_e("Choose the Post archives page layout Style", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="post-archives-layout">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('pageoptions',"post-archives-page-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==   $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach; ?>
                        </ul>
                        <input name="dttheme[pageoptions][post-archives-page-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php 
                    $sb_layout = painting_option('pageoptions',"post-archives-page-layout");
                    $sidebar_left = $sidebar_right = $sidebar_both = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="post-archives-layout" '.$sidebar_both;?>>
                      <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                          <!-- 2. Standard Sidebar Left Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Left Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-left-sidebar-for-post-archives'); ?>
                          </div><!-- Standard Sidebar Left End-->
                      </div>

                      <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                          <!-- 3. Standard Sidebar Right Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Right Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-right-sidebar-for-post-archives'); ?>
                          </div><!-- Standard Sidebar Right End-->
                      </div>
                    </div>
					
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Post Layout', 'painting');?></h6>
                    <p class="note no-margin"><?php esc_html_e("Choose the Post Layout Style in Post Archives", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set">
                        <?php $posts_layout = array('one-column'=>esc_html__("One post per row.", 'painting'), 'one-half-column'=>esc_html__("Two posts per row.", 'painting'),
													'one-third-column' => esc_html__("Three posts per row.", 'painting'));
                              $v = painting_option('pageoptions',"post-archives-post-layout");
                              $v = !empty($v) ? $v : "one-column";
                              foreach($posts_layout as $key => $value):
                                 $class = ( $key ==  $v ) ? " class='selected' " :"";                                  
                                 echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$key}.png' /></a></li>";
                              endforeach;?>                        
                        </ul>
                        <input name="dttheme[pageoptions][post-archives-post-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div>
                    
                </div>
                
                <div class="box-title">
                    <h3><?php esc_html_e('Archives and Single Post Options', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                
                	<div class="column one-half">
                    	<h6><?php esc_html_e('Post Format Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-format-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-format-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-format-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-format-meta" name="dttheme[pageoptions][post-format-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post format meta information', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('Author Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-author-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-author-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-author-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-author-meta" name="dttheme[pageoptions][post-author-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post author meta information', 'painting');?></p>
                        </div>
                    </div>
                    <div class="hr"></div>

                	<div class="column one-half">
                    	<h6><?php esc_html_e('Date Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-date-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-date-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-date-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-date-meta" name="dttheme[pageoptions][post-date-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post date meta information', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('Comment Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-comment-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-comment-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-comment-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-comment-meta" name="dttheme[pageoptions][post-comment-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post comment meta information', 'painting');?></p>
                        </div>
                    </div>
                    <div class="hr"></div>

                	<div class="column one-half">
                    	<h6><?php esc_html_e('Category Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-category-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-category-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-category-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-category-meta" name="dttheme[pageoptions][post-category-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post category information', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('Tag Meta', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-tag-meta') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-tag-meta') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-tag-meta" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-tag-meta" name="dttheme[pageoptions][post-tag-meta]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to disable post tag information', 'painting');?></p>
                        </div>
                    </div>
                
				</div>
                
                <div class="box-title">
                    <h3><?php esc_html_e('Social Share for Single Post', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                
                	<div class="column one-half">
                    	<h6><?php esc_html_e('Facebook', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-facebook') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-facebook') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-facebook" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-facebook" name="dttheme[pageoptions][post-facebook]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable facebook social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('Delicious', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-delicious') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-delicious') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-delicious" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-delicious" name="dttheme[pageoptions][post-delicious]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable delicious social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="hr"></div>

                	<div class="column one-half">
                    	<h6><?php esc_html_e('Digg', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-digg') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-digg') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-digg" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-digg" name="dttheme[pageoptions][post-digg]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable digg social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('StumbleUpon', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-stumbleupon') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-stumbleupon') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-stumbleupon" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-stumbleupon" name="dttheme[pageoptions][post-stumbleupon]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable stumbleupon social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="hr"></div>

                	<div class="column one-half">
                    	<h6><?php esc_html_e('Twitter', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-twitter') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-twitter') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-twitter" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-twitter" name="dttheme[pageoptions][post-twitter]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable twitter social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('GooglePlus', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-googleplus') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-googleplus') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-googleplus" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-googleplus" name="dttheme[pageoptions][post-googleplus]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable googleplus social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="hr"></div>

                	<div class="column one-half">
                    	<h6><?php esc_html_e('LinkedIn', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-linkedin') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-linkedin') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-linkedin" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-linkedin" name="dttheme[pageoptions][post-linkedin]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable linkedin social share', 'painting');?></p>
                        </div>
                    </div>
                    <div class="column one-half last">
                    	<h6><?php esc_html_e('Pinterest', 'painting');?></h6>
                        <div class="column one-fifth">
                        	<?php $checked = ( "true" ==  painting_option('pageoptions','post-pinterest') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  painting_option('pageoptions','post-pinterest') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        	<div data-for="dttheme-post-pinterest" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                            <input class="hidden" id="dttheme-post-pinterest" name="dttheme[pageoptions][post-pinterest]"
                            	type="checkbox" value="true" <?php echo esc_attr($checked);?> />                        
                        </div>
                        <div class="column four-fifth last">
                              <p class="note"><?php esc_html_e('YES! to enable pinterest social share', 'painting');?></p>
                        </div>
                    </div>

				</div>
                                
            </div><!-- .bpanel-box end -->
        </div><!--tab1-post end-->

        <!-- tab2-portfolio -->
        <div id="tab2" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Portfolio Single', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                    <h6><?php esc_html_e('Single Related Portfolios', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','single-portfolio-related') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','single-portfolio-related') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-single-portfolio-related" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-single-portfolio-related" name="dttheme[pageoptions][single-portfolio-related]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display related portfolio items in single portfolios.', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Portfolios Comment', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','single-portfolio-comments') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','single-portfolio-comments') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-single-portfolio-comments" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-single-portfolio-comments" name="dttheme[pageoptions][single-portfolio-comments]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display comments in single portfolios.', 'painting');?></p>
                    </div>
                </div>    

                <div class="box-title">
                    <h3><?php esc_html_e('Portfolio Archives', 'painting');?></h3>
                </div>
				
                <div class="box-content">
                    <h6><?php esc_html_e('Layout Type', 'painting');?></h6>
                    <div class="column one-fifth">
                        <select name="dttheme[pageoptions][portfolio-archives-layout-type]">
                            <?php 
							$layout_types = array('' => 'Default', 'type2' => 'Type 2', 'type3' => 'Type 3');
							$selected = (painting_option('pageoptions','portfolio-archives-layout-type') != '') ?  painting_option('pageoptions','portfolio-archives-layout-type') : ''; 
							foreach($layout_types as $layout_key => $layout_type) {
								 echo '<option value="'.$layout_key.'" '.selected($selected,$layout_key,false).'>'.$layout_type.'</option>';	
							}
							?>
                        </select>
                    </div>
                    <div class="column four-fifth last">
                    	<p class="note"><?php esc_html_e("You can choose layout design for your portfolio archive posts.",'painting');?></p>
                    </div>
                    
                    <div class="hr"></div>                
                
                    <h6><?php esc_html_e('Page Layout', 'painting');?></h6>
                    <p class="note no-margin"> <?php esc_html_e("Choose the Portfolio archives page layout Style", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="portfolio-archives-layout">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('pageoptions',"portfolio-archives-page-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==   $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach; ?>
                        </ul>
                        <input name="dttheme[pageoptions][portfolio-archives-page-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php 
                    $sb_layout = painting_option('pageoptions',"portfolio-archives-page-layout");
                    $sidebar_both = $sidebar_left = $sidebar_right = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="portfolio-archives-layout" '.$sidebar_both;?>>
                      <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                          <!-- 2. Standard Sidebar Left Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Left Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-left-sidebar-for-portfolio-archives'); ?>
                          </div><!-- Standard Sidebar Left End-->
                      </div>

                      <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                          <!-- 3. Standard Sidebar Right Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Right Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-right-sidebar-for-portfolio-archives'); ?>
                          </div><!-- Standard Sidebar Right End-->
                      </div>
                    </div>

					<div class="hr"></div>
                    
                    <h6><?php esc_html_e('Post Layout', 'painting');?></h6>
                    <p class="note no-margin"><?php esc_html_e("Choose the Post Layout Style in Portfolio Archives", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set">
                        <?php $posts_layout = array('one-column'=>esc_html__("One post per row.", 'painting'), 'one-half-column'=>esc_html__("Two posts per row.", 'painting'),
													'one-third-column' => esc_html__("Three posts per row.", 'painting'), 'one-fourth-column' => esc_html__("Four posts per row.", 'painting'));
                              $v = painting_option('pageoptions',"portfolio-archives-post-layout");
                              $v = !empty($v) ? $v : "one-fourth-column";
                              foreach($posts_layout as $key => $value):
                                 $class = ( $key ==  $v ) ? " class='selected' " :"";                                  
                                 echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$key}.png' /></a></li>";
                              endforeach;?>                        
                        </ul>
                        <input name="dttheme[pageoptions][portfolio-archives-post-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div>
                </div>                

                <div class="box-title">
                    <h3><?php esc_html_e('Portfolio Custom Fields', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <div class="portfolio-custom-fields">
                        <input type="button" class="black add-custom-field" value="<?php esc_html_e('Add New Field', 'painting');?>" />
						<div class="hr_invisible"> </div>

								<?php 
                                $custom_fields_icon = painting_option("pageoptions","portfolio-custom-fields-icon");
                                $custom_fields_link = painting_option("pageoptions","portfolio-custom-fields-link");

                                $custom_fields = painting_option("pageoptions","portfolio-custom-fields");
                                $custom_fields = is_array($custom_fields) ? array_filter($custom_fields) : array();
                                
                                $custom_fields = array_unique( $custom_fields);
                                foreach( $custom_fields as $key => $field ){ 
                                ?>
                                  <div class="custom-field-container">
									  <div class="hr_invisible"> </div>
                                      <input class="medium" type="text" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields][]";?>" value="<?php echo esc_attr($field);?>">
                                      <input class="medium" type="text" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields-icon][]";?>" value="<?php echo esc_attr($custom_fields_icon[$key]);?>">
                                      <select class="medium" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields-link][]";?>">
                                      	<option value="" <?php if($custom_fields_link[$key] == '') echo 'selected'; ?>><?php echo esc_html__('Default', 'painting'); ?></option>
                                      	<option value="link" <?php if($custom_fields_link[$key] == 'link') echo 'selected'; ?>><?php echo esc_html__('Link', 'painting'); ?></option>
                                      </select>
                                      <a href='' class='remove-custom-field'><?php esc_html_e('Remove', 'painting');?></a>
                                  </div>
						<?php } ?>
                        <div class="clone hidden">
                            <div class="custom-field-container">
								<div class="hr_invisible"> </div>                            
                                <input class="medium" type="text" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields][]";?>" placeholder="<?php esc_html_e('Field Name', 'painting'); ?>" value="">
                                <input class="medium" type="text" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields-icon][]";?>" placeholder="<?php esc_html_e('Field Icon', 'painting'); ?>" value="">
                                  <select class="medium" name="<?php echo "dttheme[pageoptions][portfolio-custom-fields-link][]";?>">
                                    <option value=""><?php echo esc_html__('Default', 'painting'); ?></option>
                                    <option value="link"><?php echo esc_html__('Link', 'painting'); ?></option>
                                  </select>
                                <a href='' class='remove-custom-field'><?php esc_html_e('Remove', 'painting');?></a>
                            </div>
                        </div>
                    </div>
				</div>

                <div class="box-title">
                    <h3><?php esc_html_e('Permalinks', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Single Portfolio slug', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input name="dttheme[pageoptions][single-portfolio-slug]" type="text" class="medium" value="<?php echo trim(stripslashes(painting_option('pageoptions','single-portfolio-slug')));?>" />
                        <p class="note"><?php esc_html_e('Do not use characters not allowed in links. Use, eg. portfolio-item <br> <b>After change go to Settings > Permalinks and click Save changes.</b>', 'painting');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Portfolio Category slug', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input name="dttheme[pageoptions][portfolio-category-slug]" type="text" class="medium" value="<?php echo trim(stripslashes(painting_option('pageoptions','portfolio-category-slug')));?>" />
                        <p class="note"><?php esc_html_e('Do not use characters not allowed in links. Use, eg. portfolio-types <br> <b>After change go to Settings > Permalinks and click Save changes.</b>', 'painting');?></p>
                    </div>
				</div>
            </div><!-- .bpanel-box end -->
        </div><!--tab2-portfolio end-->

        <!-- tab3-404 -->
        <div id="tab3" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('404 Page Layout', 'painting');?></h3>
                </div>
                
                <div class="box-content">
                    <h6><?php esc_html_e('Layout', 'painting');?></h6>
                    <p class="note no-margin"> <?php esc_html_e("Choose the 404 - not found page layout Style", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="404-page-layout">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('pageoptions',"notfound-page-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==   $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach; ?>
                        </ul>
                        <input name="dttheme[pageoptions][notfound-page-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php 
                    $sb_layout = painting_option('pageoptions',"notfound-page-layout");
                    $sidebar_both = $sidebar_left = $sidebar_right = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="404-page-layout" '.$sidebar_both;?>>
                      <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                          <!-- 2. Standard Sidebar Left Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Left Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-left-sidebar-for-notfound-page'); ?>
                          </div><!-- Standard Sidebar Left End-->
                      </div>

                      <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                          <!-- 3. Standard Sidebar Right Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Standard Right Sidebar', 'painting');?></label></h6>
                              <?php painting_switch("",'pageoptions','disable-standard-right-sidebar-for-notfound-page'); ?>
                          </div><!-- Standard Sidebar Right End-->
                      </div>
                    </div>
                </div><!-- .box-content -->

                <div class="box-title">
                    <h3><?php esc_html_e('404 Message', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Custom Message', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','enable-404message') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-404message') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-pageoptions-404message" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-pageoptions-404message" name="dttheme[pageoptions][enable-404message]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your custom message for 404 not found page. <b>Note: Html tags are allowed.</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[pageoptions][custom404-message]" name="dttheme[pageoptions][custom404-message]"><?php echo stripslashes(painting_option('pageoptions', 'custom404-message'));?></textarea>
				</div>
            </div><!-- .bpanel-box end -->
        </div><!--tab3-404 end-->

        <!-- tab4-hooks -->
        <div id="tab4" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Top', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Top Hook', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','enable-top-hook') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-top-hook') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-pageoptions-top-hook" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-pageoptions-top-hook" name="dttheme[pageoptions][enable-top-hook]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your top hook, Executes after the opening of &lt;body&gt; tag.</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[pageoptions][top-hook]" name="dttheme[pageoptions][top-hook]"><?php echo stripslashes(painting_option('pageoptions', 'top-hook'));?></textarea>
                </div><!-- .box-content -->
                
                <div class="box-title">
                    <h3><?php esc_html_e('Content Before', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Content Before Hook', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','enable-content-before-hook') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-content-before-hook') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-pageoptions-content-before-hook" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-pageoptions-content-before-hook" name="dttheme[pageoptions][enable-content-before-hook]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your content before hook, Executes after the opening of inner-wrapper tag.</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[pageoptions][content-before-hook]" name="dttheme[pageoptions][content-before-hook]"><?php echo stripslashes(painting_option('pageoptions', 'content-before-hook'));?></textarea>
                </div><!-- .box-content -->

                <div class="box-title">
                    <h3><?php esc_html_e('Content After', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Content After Hook', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','enable-content-after-hook') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-content-after-hook') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-pageoptions-content-after-hook" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-pageoptions-content-after-hook" name="dttheme[pageoptions][enable-content-after-hook]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your content after hook, Executes before the closing of inner-wrapper tag.</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[pageoptions][content-after-hook]" name="dttheme[pageoptions][content-after-hook]"><?php echo stripslashes(painting_option('pageoptions', 'content-after-hook'));?></textarea>
                </div><!-- .box-content -->

                <div class="box-title">
                    <h3><?php esc_html_e('Bottom', 'painting');?></h3>
                </div>

                <div class="box-content">
                     <h6><?php esc_html_e('Enable Bottom Hook', 'painting');?></h6>
                     <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('pageoptions','enable-bottom-hook') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-bottom-hook') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-pageoptions-bottom-hook" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-pageoptions-bottom-hook" name="dttheme[pageoptions][enable-bottom-hook]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                     </div>
                     <div class="column four-fifth last">
                        <p class="note"><?php esc_html_e('Paste your bottom hook, Executes before the closing of &lt;/body&gt; tag.</b>', 'painting');?></p>
                     </div>
                     <div class="clear"></div>
                     <div class="hr_invisible_large"></div>
                     <textarea id="dttheme[pageoptions][bottom-hook]" name="dttheme[pageoptions][bottom-hook]"><?php echo stripslashes(painting_option('pageoptions', 'bottom-hook'));?></textarea>
                </div><!-- .box-content -->

                <div class="box-title">
                   <h3><?php esc_html_e('Tracking Code', 'painting');?></h3>
               </div>

               <div class="box-content">
                    <h6><?php esc_html_e('Enable Tracking Code', 'painting');?></h6>
                    <div class="column one-fifth">
                         <?php $checked = ( "true" ==  painting_option('pageoptions','enable-tracking-code') ) ? ' checked="checked"' : ''; ?>
                         <?php $switchclass = ( "true" ==  painting_option('pageoptions','enable-tracking-code') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                         <div data-for="dttheme-pageoptions-tracking-code" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                         <input class="hidden" id="dttheme-pageoptions-tracking-code" name="dttheme[pageoptions][enable-tracking-code]" type="checkbox" value="true" <?php echo $checked;?> />
                    </div>
                    <div class="column four-fifth last">
                       <p class="note"><?php esc_html_e('YES! to enable tracking code.', 'painting');?></p>
                    </div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Google Analytics Tracking Code', 'painting');?></h6>
                    <textarea id="dttheme[pageoptions][tracking-code]" name="dttheme[pageoptions][tracking-code]"><?php echo stripslashes(painting_option('pageoptions', 'tracking-code'));?></textarea>
                    <p class="note"><?php esc_html_e('Either enter your Google tracking id (UA-XXXXX-X) or your full Google Analytics tracking Code here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site', 'painting');?></p>
               </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!--tab4-hooks end-->

    </div><!-- .bpanel-main-content end-->
</div><!-- pageoptions end-->