<!-- woocommerce -->
<div id="woocommerce" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#tab1"><?php esc_html_e('WooCommerce', 'painting');?></a></li>
        </ul>

        <!-- tab1-woocommerce -->
        <div id="tab1" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">

                <div class="box-title">
                    <h3><?php esc_html_e('WooCommerce', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Products Per Page', 'painting');?></label></div>
                    <div class="column two-third last">
                        <input name="dttheme[woo][shop-product-per-page]" type="text" class="small" value="<?php echo trim(stripslashes(painting_option('woo','shop-product-per-page')));?>" />
                        <p class="note"><?php esc_html_e('Number of products to show in catalog / shop page', 'painting');?></p>
                    </div>

                    <h6><?php esc_html_e('Product Layout', 'painting');?></h6>
                    <p class="note no-margin"><?php esc_html_e("Choose the Product Layout Style in Catalog / Shop ", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set">
                        <?php $posts_layout = array('one-half-column'=>esc_html__("Two products per row.", 'painting'),'one-third-column' => esc_html__("Three products per row.", 'painting'),
                                                    'one-fourth-column' => esc_html__("Four products per row", 'painting'));
                              $v = painting_option('woo',"shop-page-product-layout");
                              $v = !empty($v) ? $v : "one-half-column";
                              foreach($posts_layout as $key => $value):
                                 $class = ( $key ==  $v ) ? " class='selected' " :"";                                  
                                 echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$key}.png' /></a></li>";
                              endforeach;?>                        
                        </ul>
                        <input name="dttheme[woo][shop-page-product-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div>
                    
                    <div class="hr_invisible"> </div>
                    <div class="column one-third"><label><?php esc_html_e('Apply Isotope', 'painting');?></label></div>
                    <div class="column two-third last">
                          <?php $checked = ( "true" ==  painting_option('woo','shop-apply-isotope') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('woo','shop-apply-isotope') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-shop-apply-isotope" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-shop-apply-isotope" name="dttheme[woo][shop-apply-isotope]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                        <p class="note"><?php esc_html_e('You can apply isotope for your shop products.', 'painting');?></p>
                    </div>
                    
                    <div class="hr_invisible"> </div>
                    <div class="column one-third"><label><?php esc_html_e('Disable Shop Standard Sidebar', 'painting');?></label></div>
                    <div class="column two-third last">
                         <?php painting_switch("",'woo','disable-shop-standard-sidebar'); ?>
                        <p class="note"><?php esc_html_e('You can disable shop standard sidebar from shop page.', 'painting');?></p>
                    </div>
                    
                    <div class="hr_invisible"> </div>
                    <div class="column one-third"><label><?php esc_html_e('Choose Categories', 'painting');?></label></div>
                    <div class="column two-third last">
                        <?php 
                        $pd_cat = painting_option('woo','shop-include-categories');
                        $cats = get_categories ( 'taxonomy=product_cat&hide_empty=0' ); 
                        ?>
                        <select class="dt-chosen-select" name="dttheme[woo][shop-include-categories][]" multiple="multiple" data-placeholder="<?php esc_html_e('Choose Categories', 'painting');?>"><?php
                          echo "<option value=''></option>";
                          foreach ( $cats as $cat ) :
                              $id = esc_attr ( $cat->term_id );
                              $title = esc_html ( $cat->name );
                              $selected = in_array( $id , $pd_cat ) ? " selected='selected' " : "";
                              echo "<option value='{$id}' {$selected}>{$title}</option>";
                          endforeach;?>                        	
                        </select>
                        <p class="note"><?php esc_html_e('You can choose only certain categories to display in shop page. By default all categories will be displayed.', 'painting');?></p>
                    </div>
                    
                </div><!-- .box-content -->

                <div class="box-title">
                    <h3><?php esc_html_e('Product Detail', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Page Layout', 'painting');?></h6>
                    <p class="note no-margin"> <?php esc_html_e("Choose The Product Page Layout", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set"  id="woocommerce-product-layout">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('woo',"product-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==  $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach;?>
                        </ul>
                        <input name="dttheme[woo][product-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php
                    //Disable option for sidebar
                    $sb_layout = painting_option('woo',"product-layout");
                    $sidebar_both = $sidebar_left = $sidebar_right = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="woocommerce-product-layout" '.$sidebar_both;?>>
                      <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                          <!-- 2. Standard Sidebar Left Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Shop Standard Sidebar Left', 'painting');?></label></h6>
                              <?php painting_switch("",'woo','disable-shop-standard-left-sidebar-for-product-layout'); ?>
                          </div><!-- Standard Sidebar Left End-->
                      </div>

                      <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                          <!-- 3. Standard Sidebar Right Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Shop Standard Sidebar Right', 'painting');?></label></h6>
                              <?php painting_switch("",'woo','disable-shop-standard-right-sidebar-for-product-layout'); ?>
                          </div><!-- Standard Sidebar Right End-->
                      </div>
                    </div>
                    <div class="hr"> </div>
                    
                    <h6><?php esc_html_e('Disable Tabs Section', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('woo','disable-tabs-section') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('woo','disable-tabs-section') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-woo-disable-tabs-section" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-woo-disable-tabs-section" name="dttheme[woo][disable-tabs-section]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to disable tabs section in product single page.', 'painting');?></p>
                    </div>      
                    <div class="hr"> </div>
                    <div class="clear"> </div>
                    
                    <h6><?php esc_html_e('Up Sell, Cross Sell And  Related Products Layout', 'painting');?></h6>
                    <p class="note no-margin"><?php esc_html_e("Choose The Layout Style For Up Sell, Cross Sell And Related Products ", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set">
                        <?php $posts_layout = array('one-half-column'=>esc_html__("Two products per row.", 'painting'),'one-third-column' => esc_html__("Three products per row.", 'painting'),
                                                    'one-fourth-column' => esc_html__("Four products per row", 'painting'));
                              $v = painting_option('woo',"shop-other-product-layout");
                              $v = !empty($v) ? $v : "one-half-column";
                              foreach($posts_layout as $key => $value):
                                 $class = ( $key ==  $v ) ? " class='selected' " :"";                                  
                                 echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$key}.png' /></a></li>";
                              endforeach;?>                        
                        </ul>
                        <input name="dttheme[woo][shop-other-product-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div>
                    <div class="hr_invisible"> </div>
                    <div class="hr_invisible"> </div>
                    
                    <h6><?php esc_html_e('Show UpSell Products', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('woo','show-upsell-products') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('woo','show-upsell-products') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-woo-show-upsell-products" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-woo-show-upsell-products" name="dttheme[woo][show-upsell-products]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display upsell products on product single page.', 'painting');?></p>
                    </div>
                    <div class="hr_invisible"> </div>
                    <div class="hr_invisible"> </div>
                    
                    <h6><?php esc_html_e('Show Related Products', 'painting');?></h6>
                    <div class="column one-fifth">
                          <?php $checked = ( "true" ==  painting_option('woo','show-related-products') ) ? ' checked="checked"' : ''; ?>
                          <?php $switchclass = ( "true" ==  painting_option('woo','show-related-products') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                          <div data-for="dttheme-woo-show-related-products" class="checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
                          <input class="hidden" id="dttheme-woo-show-related-products" name="dttheme[woo][show-related-products]" type="checkbox" value="true" <?php echo esc_attr($checked);?> />
                    </div>
                    <div class="column four-fifth last">
                          <p class="note"><?php esc_html_e('YES! to display related products on product single page.', 'painting');?></p>
                    </div>
                    
                    
                </div><!-- .box-content -->

                <div class="box-title">
                    <h3><?php esc_html_e('Product Category', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Layout', 'painting');?></h6>
                    <p class="note no-margin"><?php esc_html_e("Choose the Product category page layout Style", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="woocommerce-product-category">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('woo',"product-category-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==  $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach; ?>
                        </ul>
                        <input name="dttheme[woo][product-category-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php
                    //Disable option for sidebar
                    $sb_layout = painting_option('woo',"product-category-layout");
                    $sidebar_both = $sidebar_left = $sidebar_right = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="woocommerce-product-category" '.$sidebar_both;?>>
                        <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                            <!-- 2. Standard Sidebar Left Start -->
                            <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                                <h6><?php esc_html_e('Disable Shop Standard Sidebar Left', 'painting');?></label></h6>
                                <?php painting_switch("",'woo','disable-shop-standard-left-sidebar-for-product-category-layout'); ?>
                            </div><!-- Standard Sidebar Left End-->
                        </div>

                        <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                            <!-- 3. Standard Sidebar Right Start -->
                            <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                                <h6><?php esc_html_e('Disable Shop Standard Sidebar Right', 'painting');?></label></h6>
                                <?php painting_switch("",'woo','disable-shop-standard-right-sidebar-for-product-category-layout'); ?>
                            </div><!-- Standard Sidebar Right End-->
                        </div>
                    </div>
                </div>

                <div class="box-title">
                    <h3><?php esc_html_e('Product Tag', 'painting');?></h3>
                </div>

                <div class="box-content">
                    <h6><?php esc_html_e('Layout', 'painting');?></h6>
                    <p class="note no-margin"> <?php esc_html_e("Choose the Product tag page layout Style", 'painting');?></p>
                    <div class="hr_invisible"> </div>
                    <div class="bpanel-option-set">
                        <ul class="bpanel-post-layout bpanel-layout-set" id="woocommerce-product-tag">
                        <?php $layout = array('content-full-width'=>'without-sidebar','with-left-sidebar'=>'left-sidebar','with-right-sidebar'=>'right-sidebar');
                              $v =  painting_option('woo',"product-tag-layout");
                              $v = !empty($v) ? $v : "content-full-width";
                              foreach($layout as $key => $value):
                                  $class = ( $key ==   $v ) ? " class='selected' " : "";
                                  echo "<li><a href='#' rel='{$key}' {$class}><img src='" . PAINTING_URI . "/framework/theme-options/images/columns/{$value}.png' /></a></li>";
                              endforeach; ?>
                        </ul>
                        <input name="dttheme[woo][product-tag-layout]" type="hidden" value="<?php echo esc_attr($v);?>"/>
                    </div><?php 
                    $sb_layout = painting_option('woo',"product-tag-layout");
                    $sidebar_both = $sidebar_left = $sidebar_right = '';
                    if($sb_layout == 'content-full-width') {
                      $sidebar_both = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-left-sidebar') {
                      $sidebar_right = 'style="display:none;"'; 
                    } elseif($sb_layout == 'with-right-sidebar') {
                      $sidebar_left = 'style="display:none;"'; 
                    } ?>
                    <div id="bpanel-widget-area-options" <?php echo 'class="woocommerce-product-tag" '.$sidebar_both;?>>
                      <div id="left-sidebar-container" class="bpanel-page-left-sidebar" <?php echo painting_wp_kses($sidebar_left); ?>>
                          <!-- 2. Standard Sidebar Left Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Shop Standard Sidebar Left', 'painting');?></label></h6>
                              <?php painting_switch("",'woo','disable-shop-standard-left-sidebar-for-product-tag-layout'); ?>
                          </div><!-- Standard Sidebar Left End-->
                      </div>

                      <div id="right-sidebar-container" class="bpanel-page-right-sidebar" <?php echo painting_wp_kses($sidebar_right); ?>>
                          <!-- 3. Standard Sidebar Right Start -->
                          <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                              <h6><?php esc_html_e('Disable Shop Standard Sidebar Right', 'painting');?></label></h6>
                              <?php painting_switch("",'woo','disable-shop-standard-right-sidebar-for-product-tag-layout'); ?>
                          </div><!-- Standard Sidebar Right End-->
                      </div>
                    </div>
                </div>

            </div><!-- .bpanel-box end -->            
        </div><!--tab1-woocommerce end-->

    </div><!-- .bpanel-main-content end-->
</div><!-- woocommerce end-->