<?php
/** My Recent Posts Widget
  * Objective:
  *		1.To list out posts
**/
class DT_Recent_Posts extends WP_Widget {
	#1.constructor
	function __construct() {
		$widget_ops = array(
			'classname' => 'widget_recent_entries',
			'description' => esc_html__( 'To list out posts', 'painting' ),
			'customize_selective_refresh' => true,
		);
		parent::__construct( 'posts', PAINTING_NAME.' '.esc_html__('Posts', 'painting'), $widget_ops );
	}
	
	#2.widget input form in back-end
	function form($instance) {
		$instance = wp_parse_args( (array) $instance,array('title'=>'','_post_count'=>'','_post_categories'=>'','_enabled_image'=>'','_excerpt'=>'') );
		$title = strip_tags($instance['title']);
		$_post_count = !empty($instance['_post_count']) ? strip_tags($instance['_post_count']) : "-1";
	    $_post_categories = !empty($instance['_post_categories']) ? $instance['_post_categories']: array();?>
        
        <!-- Form -->
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:','painting');?> </label>
		   <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
            type="text" value="<?php echo esc_attr($title); ?>" /></p>
           
	    <p><label for="<?php echo esc_attr($this->get_field_id('_post_categories')); ?>">
			<?php esc_html_e('Choose the categories you want to display (multiple selection possible)','painting');?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('_post_categories')).'[]';?>" 
            	name="<?php echo esc_attr($this->get_field_name('_post_categories')).'[]';?>" multiple="multiple">
                <option value=""><?php esc_html_e("Select",'painting');?></option>
           	<?php $cats = get_categories( 'orderby=name&hide_empty=0' );
			foreach ($cats as $cat):
				$id = esc_attr($cat->term_id);
				$selected = ( in_array($id,$_post_categories)) ? 'selected="selected"' : '';
				$title = esc_html($cat->name);
				echo "<option value='{$id}' {$selected}>{$title}</option>";
			endforeach;?>
            </select></p>

	    <p><label for="<?php echo esc_attr($this->get_field_id('_post_count')); ?>"><?php esc_html_e('No.of posts to show:','painting');?></label>
		   <input id="<?php echo esc_attr($this->get_field_id('_post_count')); ?>" name="<?php echo esc_attr($this->get_field_name('_post_count')); ?>" value="<?php echo esc_attr($_post_count); ?>" /></p>
           
        <!-- Form end-->
<?php
	}
	#3.processes & saves the twitter widget option
	function update( $new_instance,$old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['_post_count'] = strip_tags($new_instance['_post_count']);
		$instance['_post_categories'] = $new_instance['_post_categories'];
	return $instance;
	}
	
	#4.output in front-end
	function widget($args, $instance) {
		extract($args);
		global $post;
		
		$_show_viewall = 	empty($instance['_show_viewall']) ? false : true;
		$title = empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$_post_count = isset($instance['_post_count']) ? (int) $instance['_post_count'] : -1;
		$_post_categories = "";
		if(!empty($instance['_post_categories']))
			$_post_categories = is_array($instance['_post_categories']) ? implode(",",$instance['_post_categories']) : $instance['_post_categories'];
		$arg = empty($_post_categories) ? "posts_per_page={$_post_count}":"cat={$_post_categories}&posts_per_page={$_post_count}";

		
		$title = apply_filters('widget_title', $title );
		echo painting_wp_kses($before_widget);
		if ( !empty( $title ) ) echo painting_wp_kses($before_title.$title.$after_title);
		
		echo "<div class='recent-post-widget'><ul>";	
			 $the_query = new WP_Query($arg);
			 if($the_query->have_posts()) :
				 while($the_query->have_posts()):
					$the_query->the_post();
				
					$link = get_permalink();
					$author_id = get_the_author_meta('ID');
					$title = get_the_title();
					
					$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'painting-70x70',false);
					$image = ( $image != false)? $image[0]:'http'.painting_ssl().'://placehold.it/85x85';
					
					echo '<li><a href="'.get_permalink().'" class="thumb"><img src="'.$image.'" alt="'.$title.'"/></a>
							<h6><a href="'.get_permalink().'">'.$title.'</a></h6>
							<div class="entry-meta"> 
								<p><span class="icon icon-Time"></span>'.get_the_date("dMY").'</p>
								<p><span class="icon icon-User"></span><a href="'.get_author_posts_url(get_the_author_meta('ID')).'">'.get_the_author().'</a></p>
							</div>
						</li>';
				 endwhile;
			 else:
				echo "<li><h4>".esc_html__('No Posts found','painting')."</h4></li>";
			 endif;
			 wp_reset_postdata();
		echo "</ul>";
		echo "</div>";	
				 
		echo painting_wp_kses($after_widget);
	}
}?>