<!doctype html>
<!--[if IE 7 ]>    <html lang="en-gb" class="isie ie7 oldie no-js"> <![endif]-->
<!--[if IE 8 ]>    <html lang="en-gb" class="isie ie8 oldie no-js"> <![endif]-->
<!--[if IE 9 ]>    <html lang="en-gb" class="isie ie9 no-js"> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php painting_responsive(); ?>
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	
    <?php do_action( 'painting_hook_top' ); ?>
    
    <?php 
	if(painting_option('general','enable-preloader') == 'true') { ?>
        <div class="loader-wrapper">
            <img src="<?php echo PAINTING_URI; ?>/images/loader.gif" alt="<?php echo esc_html__('Loader', 'painting'); ?>" />
        </div>    
	<?php 
	}
   
    if(!is_user_logged_in()){ 
		$picker = painting_option('general','enable-stylepicker');
		if(isset($picker)) { painting_color_picker(); }
	}
    ?>

    <div class="wrapper">
        <div class="inner-wrapper">
            <?php
			do_action( 'painting_hook_content_before' );
			if( is_page_template('tpl-comingsoon.php') ) { 
				?>
                <div id="main">
                <?php
			} else {
				
				$enable_topbar = painting_enabledisable_topbar();
				if($enable_topbar == 'true') { require_once(PAINTING_DIR.'/framework/headers/topbar.php'); }
				
				$headertype = painting_get_header_type();
				require_once(PAINTING_DIR.'/framework/headers/'.$headertype.'.php');
				?>
				<div id="main">
					<?php
					echo painting_slider();
					
					require_once( PAINTING_DIR."/framework/sub-title.php");
					if(!is_page_template('tpl-fullwidth.php') && !is_page_template('tpl-portfolio-fullwidth.php')) {
						?>
						<div class="dt-sc-margin80"></div>
						<div class="container">
						<?php
					}
			}
			?>