<?php 
get_header();

$page_layout 	= painting_option('pageoptions','post-archives-page-layout');
if($GLOBALS['force_enable'] == true) {
	$page_layout = painting_option('general', 'global-page-layout');
	$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
}

$show_sidebar = false;
$sidebar_class = $sidebar_id = "";

switch ( $page_layout ) {
	case 'with-left-sidebar':
		$page_class = "page-with-sidebar with-left-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-left-sidebar";
		$sidebar_id = "left";
	break;

	case 'with-right-sidebar':
		$page_class = "page-with-sidebar with-right-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-right-sidebar";
		$sidebar_id = "right";
	break;

	case 'content-full-width':
	default:
		$page_class = "content-full-width";
	break;
}
?>

<section id="primary" class="<?php echo esc_attr($page_class);?>">

	<?php
    
	$post_layout = painting_option('pageoptions','post-archives-post-layout'); 
	$post_layout = !empty($post_layout) ? $post_layout : "one-column";
	$post_class = $container_class = "";

	switch($post_layout):
		case 'one-column':
			$post_class = $show_sidebar ? " column dt-sc-one-column with-sidebar blog-fullwidth" : " column dt-sc-one-column blog-fullwidth";
			$columns = 1;
		break;

		case 'one-half-column';
			$post_class = $show_sidebar ? " column dt-sc-one-half with-sidebar" : " column dt-sc-one-half";
			$columns = 2;
			$container_class = "apply-isotope";
		break;

		case 'one-third-column':
			$post_class = $show_sidebar ? " column dt-sc-one-third with-sidebar" : " column dt-sc-one-third";
			$columns = 3;
			$container_class = "apply-isotope";
		break;
	endswitch;
    
    if( have_posts() ):
		echo '<div class="blog-items '.$container_class.'">';
			$i = 1;
			while( have_posts() ):
				the_post();
				$temp_class = "";
				if($i == 1) $temp_class = $post_class." first"; else $temp_class = $post_class;
				if($i == $columns) $i = 1; else $i = $i + 1;
				$format = get_post_format(  get_the_id() );?>
				<div class="<?php echo esc_attr($temp_class);?>"><?php  get_template_part( 'framework/loops/content-archive');?></div>
				<?php 
			endwhile;
			echo '</div>';
		painting_post_navigation();
	else:
		echo '<h2>'.esc_html__('Nothing found!', 'painting').'</h2>';	
		echo '<h5>'.esc_html__('Please perform search with different keywords.', 'painting').'</h5>';	
    endif;
	?>
	
	<div class="dt-sc-hr-invisible"></div> 

</section>

<?php if ( $show_sidebar ): ?>
	<section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class); ?>"><?php get_sidebar($sidebar_id); ?></section>
<?php endif; ?>

<?php get_footer(); ?>