<?php
/*Template Name: Appointment Template*/

get_header();

$tpl_default_settings = get_post_meta( $post->ID, '_tpl_default_settings', TRUE );
$tpl_default_settings = is_array( $tpl_default_settings ) ? $tpl_default_settings  : array();

$page_layout  = array_key_exists( "layout", $tpl_default_settings ) ? $tpl_default_settings['layout'] : "content-full-width";
if($GLOBALS['force_enable'] == true) {
	$page_layout = painting_option('general', 'global-page-layout');
	$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
}

$show_sidebar = false;
$sidebar_class = $sidebar_id = "";

switch ( $page_layout ) {
	case 'with-left-sidebar':
		$page_class = "page-with-sidebar with-left-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-left-sidebar";
		$sidebar_id = "left";
	break;

	case 'with-right-sidebar':
		$page_class = "page-with-sidebar with-right-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-right-sidebar";
		$sidebar_id = "right";
	break;

	case 'content-full-width':
	default:
		$page_class = "content-full-width";
	break;
}
?>
<!-- ** Primary Section ** -->
<section id="primary" class="<?php echo esc_attr($page_class); ?>">
    <?php
	if(class_exists('DTAppointmentAddon')) {
		
		$staffids = isset($_REQUEST['staffids']) ? $_REQUEST['staffids'] : '';
		$serviceids = isset($_REQUEST['serviceids']) ? $_REQUEST['serviceids'] : '';
		
		$firstname = isset($_REQUEST['firstname']) ? $_REQUEST['firstname'] : '';
		$lastname = isset($_REQUEST['lastname']) ? $_REQUEST['lastname'] : '';
		$phone = isset($_REQUEST['phone']) ? $_REQUEST['phone'] : '';
		$emailid = isset($_REQUEST['emailid']) ? $_REQUEST['emailid'] : '';
		$address = isset($_REQUEST['address']) ? $_REQUEST['address'] : '';
		
		if($firstname == '') { 
			$from_step1 = 'true'; 
			$servicebox_style = 'style="display:none;"'; 
			$contactbox_style = ''; 
			$gobackbox_style = 'style="display:none;"'; 
			$step_value = 1; 
			$current_step1 = 'dt-sc-current-step';
			$current_step2 = '';
			$completed_step = '';
		} else { 
			$from_step1 = 'false'; 
			$servicebox_style = ''; 
			$contactbox_style = 'style="display:none;"'; 
			$gobackbox_style = ''; 
			$step_value = 2; 
			$current_step1 = '';
			$current_step2 = 'dt-sc-current-step';
			$completed_step = 'dt-sc-completed-step';

			$contact_info_data = '<ul>';
				if($firstname != '') { $contact_info_data .= '<li>'.$firstname.' '.$lastname.'</li>'; }
				if($phone != '') { $contact_info_data .= '<li>'.$phone.'</li>'; }
				if($emailid != '') { $contact_info_data .= '<li>'.$emailid.'</li>'; }
				if($address != '') { $contact_info_data .= '<li>'.$address.'</li>'; }
			$contact_info_data .= '</ul>';
		}
		?>
		
        <div class="dt-sc-schedule-progress-wrapper">
            <div class="dt-sc-schedule-progress step1 <?php echo esc_attr($current_step1.' '.$completed_step); ?>">
            	<div class="dt-sc-progress-step">
                	<span>1</span>
                </div>
                <h4><?php echo esc_html__('Fill Contact Details', 'painting'); ?></h4>
                <p><?php echo esc_html__('Please fill in the basic contact details here.', 'painting'); ?></p>
            </div>
            <div class="dt-sc-schedule-progress step2 <?php echo esc_attr($current_step2); ?>">
            	<div class="dt-sc-progress-step">
                	<span>2</span>
                </div>
                <h4><?php echo esc_html__('Select Timings', 'painting'); ?></h4>
                <p><?php echo esc_html__('Please select your convenient date and time.', 'painting'); ?></p>
            </div>
            <div class="dt-sc-schedule-progress step3">
            	<div class="dt-sc-progress-step">
                	<span>3</span>
                </div>
                <h4><?php echo esc_html__('About Your Project', 'painting'); ?></h4>
                <p><?php echo esc_html__('Please provide the basic details of your project here.', 'painting'); ?></p>
            </div>
            <div class="dt-sc-schedule-progress step4">
            	<div class="dt-sc-progress-step">
                	<span>4</span>
                </div>
                <h4><?php echo esc_html__('Confirmation', 'painting'); ?></h4>
                <p><?php echo esc_html__('Our painting prefessional will get in touch with you soon.', 'painting'); ?></p>
            </div>
        </div>
        <div class="dt-sc-margin30"></div>
        <div class="clear"></div>
        
		<div class="dt-sc-goback-box" <?php echo painting_wp_kses($gobackbox_style); ?>>
			<input class="appointment-goback" value="<?php echo esc_html__('Go Back', 'painting'); ?>" type="button" />
            <input type="hidden" value="<?php echo esc_attr($from_step1); ?>" name="appointment-step-checker"  id="appointment-step-checker"  />
			<input type="hidden" value="<?php echo esc_attr($step_value); ?>" name="appointment-step"  id="appointment-step"  />
		</div> 
		
		
		<div class="dt-sc-contactdetails-box steps step1" <?php echo painting_wp_kses($contactbox_style); ?>>
		
        	<div class="border-title"><h2><?php echo esc_html__('Please provide us your contact details', 'painting'); ?></h2></div>
			<div class="dt-sc-margin15"></div>
            
			<form class="dt-sc-appointment-contactdetails-form" name="dt-sc-appointment-contactdetails-form" method="post" >
			
				<div class="column dt-sc-one-half first"><input type="text" id="firstname" name="firstname" value="<?php echo esc_attr($firstname); ?>" placeholder="<?php echo esc_html__('First Name', 'painting'); ?>" required /></div>
				<div class="column dt-sc-one-half"><input type="text" id="lastname" name="lastname" value="<?php echo esc_attr($lastname); ?>" placeholder="<?php echo esc_html__('Last Name', 'painting'); ?>" required /></div>
				
				<div class="column dt-sc-one-half first"><input type="text" id="phone" name="phone" value="<?php echo esc_attr($phone); ?>" placeholder="<?php echo esc_html__('Phone', 'painting'); ?>" required /></div>
				<div class="column dt-sc-one-half"><input type="text" id="emailid" name="emailid" value="<?php echo esc_attr($emailid); ?>" placeholder="<?php echo esc_html__('Email', 'painting'); ?>" required /></div>
				
				<div class="column dt-sc-one-column first"><textarea id="address" name="address" placeholder="<?php echo esc_html__('Address', 'painting'); ?>" required><?php echo esc_attr($address); ?></textarea></div>
				
				<div class="dt-sc-margin10"></div>
				
				<input class="fullwidth generate-servicebox" value="<?php echo esc_html__('Next', 'painting'); ?>" type="submit" />	

				<?php 
			        $check = apply_filters('dt_sc_reservation_form_elements', $privacy, $attrs ); 
			    ?>
			    <p><?php echo $check; ?></p>	

			</form>
			
		</div>
		
			
		<div class="dt-sc-schedule-box steps step2" <?php echo painting_wp_kses($servicebox_style); ?>>
		
			<div class="border-title"><h2><?php echo esc_html__('Please choose your convenient time', 'painting'); ?></h2></div>
            <div class="dt-sc-margin15"></div>

			<div class="dt-sc-service-box" <?php echo painting_wp_kses($servicebox_style); ?>>
			
				<form class="dt-sc-appointment-scheduler-form" name="dt-sc-appointment-scheduler-form" method="post">
					<div class="column dt-sc-one-third first">
						<label class="dt-sc-margin10"><span class="fa fa-paper-plane"></span><?php echo esc_html__('Services', 'painting'); ?></label>
						<select name="serviceid" id="serviceid" class="dt-select-service">
							<option value=""><?php echo esc_html__('All Services', 'painting'); ?></option>
								<?php
								$services_args = array('post_type'=>'dt_services', 'posts_per_page'=>'-1' , 'suppress_filters' => false );
								
								if($serviceids != '') {
									$serviceids_arr = explode(',', $serviceids);
									$services_args['post__in'] = $serviceids_arr;
								}
								
								$cp_services = get_posts( $services_args );
								if( $cp_services ){
									foreach( $cp_services as $cp_service ){
										$id = $cp_service->ID; 
										$title = $cp_service->post_title;
										?>
										<option value="<?php echo esc_attr($id); ?>" <?php if(isset($_REQUEST['serviceid'])) { echo selected($_REQUEST['serviceid'], $id, false); } ?>><?php echo esc_html($title); ?></option>
										<?php
									}
								}
								?>
						</select>
					</div>
	
					<div class="column dt-sc-one-third">
						<label class="dt-sc-margin10"><span class="fa fa-user"></span><?php echo esc_html__('Staffs', 'painting'); ?></label>
						<select name="staffid" id="staffid" class="dt-select-staff">
							<option value=""><?php echo esc_html__('All Staffs','painting'); ?></option>
							<?php
							$staffs_args = array(
								'post_type' => 'dt_staffs',
								'posts_per_page' => '-1',
								'meta_query'=>array()
								);
							if($staffids != '') {
								$staffids_arr = explode(',', $staffids);
								$staffs_args['post__in'] = $staffids_arr;
							}
							if(isset($_REQUEST['serviceid'])) {
								$staffs_args['meta_query'][] = array(
															'key'     => '_services',
															'value'   =>  $_REQUEST['serviceid'],
															'compare' => 'LIKE'
															);
							}
							
							$cp_staffs = get_posts( $staffs_args );
							if( $cp_staffs ){
								foreach( $cp_staffs as $cp_staff ){
									$id = $cp_staff->ID;
									$title = $cp_staff->post_title;
									?>
									<option value="<?php echo esc_attr($id); ?>" <?php if(isset($_REQUEST['staffid'])) { echo selected($_REQUEST['staffid'], $id, false); } ?>><?php echo esc_html($title); ?></option>
									<?php
								}
							}
							?>
						</select>
					</div>
	
					<div class="column dt-sc-one-third">
						<label><span class="fa fa-calendar"></span><?php echo esc_html__('Date', 'painting'); ?></label>
						<input type="text" id="aptdatepicker" name="date" value="<?php if(isset($_REQUEST['date'])) echo esc_attr($_REQUEST['date']); else echo date('Y-m-d'); ?>" />
					</div>
                    
                    <div class="dt-sc-margin25"></div>
                    <input class="generate-schedule" value="<?php echo esc_html__('Check available time', 'painting'); ?>" type="button" />
                    <input type="hidden" id="staffids" name="staffids" value="<?php echo esc_attr($staffids); ?>" />
                    <input type="hidden" id="serviceids" name="serviceids" value="<?php echo esc_attr($serviceids); ?>" />

				</form>
				<div class="dt-sc-margin50"> </div> 
				
			</div>
			
			<div class="dt-sc-timeslot-box" <?php echo painting_wp_kses($servicebox_style); ?>>
				<div class="appointment-ajax-holder"></div>
			</div>
		
		</div>
		
		
		<div class="dt-sc-aboutproject-box steps step3" style="display:none;">
		
			<input type="hidden" id="hid_firstname" name="hid_firstname" value="<?php echo esc_attr($firstname); ?>" />
			<input type="hidden" id="hid_lastname" name="hid_lastname" value="<?php echo esc_attr($lastname); ?>" />
			<input type="hidden" id="hid_phone" name="hid_phone" value="<?php echo esc_attr($phone); ?>" />
			<input type="hidden" id="hid_emailid" name="hid_emailid" value="<?php echo esc_attr($emailid); ?>" />
			<input type="hidden" id="hid_address" name="hid_address" value="<?php echo esc_attr($address); ?>" />

			<div id="dt-sc-ajax-load-image" style="display:none;"><img src="<?php echo  plugin_dir_url ( __FILE__ ).'images/loading.png'; ?>" alt="" /></div>
			
			<div id="personalinfo" class="dt-sc-personal-info">
			
				<div class="border-title"><h2><?php echo esc_html__('Tell Us About Your Project', 'painting'); ?></h2></div>
                <div class="dt-sc-margin15"></div>
				
				<form class="dt-sc-about-project-form" name="dt-sc-about-project-form" method="post">
					<textarea name="about_your_project" placeholder="" required></textarea>
					<input class="schedule-it" value="<?php echo esc_html__('Schedule It', 'painting'); ?>" type="submit" />
					
				</form>
				
			</div>    

		</div>
		
		
		<div class="dt-sc-notification-box steps step4" style="display:none;">
		
			<div class="column dt-sc-one-third dt-sc-notification-details dt-sc-notification-contactbox first">
				<h3 class="dt-sc-margin10"><?php echo esc_html__('Contact Information', 'painting'); ?></h3>
				<div class="dt-sc-contact-info" id="dt-sc-contact-info"><?php echo painting_wp_kses($contact_info_data); ?></div>
			</div>
			
			<div class="column dt-sc-one-third dt-sc-notification-details dt-sc-notification-schedulebox">
				<h3 class="dt-sc-margin10"><?php echo esc_html__('Schedule Details', 'painting'); ?></h3>
				<div class="dt-sc-schedule-details" id="dt-sc-schedule-details"></div>
			</div>

			<div class="column dt-sc-one-third dt-sc-notification-details dt-sc-notification-aboutprojectbox">
				<h3 class="dt-sc-margin10"><?php echo esc_html__('About Your Project', 'painting'); ?></h3>
				<div class="dt-sc-about-project" id="dt-sc-about-project"></div>
			</div>
		
			<div class="dt-sc-margin25"></div>
			<div class="clear"></div>
			 
			<div class="dt-sc-apt-success-box" style="display:none;">
				<?php
				$success = painting_option('appointments', 'success_message');
				$success = stripslashes($success);
				echo do_shortcode($success);
				?>
			</div>
			<div class="dt-sc-apt-error-box" style="display:none;">
				<?php
				$error= painting_option('appointments', 'error_message');
				$error = stripslashes($error);
				echo do_shortcode($error);
				?>
			</div>
		</div>
		
		<?php

	} else {
		?>
        <div class="dt-sc-info-box"><?php echo esc_html__('Please install and activate the BuddhaThemes Appointment Addon!', 'painting'); ?></div>
        <?php
	}
    ?>
</section><!-- ** Primary Section End ** -->
    
<?php if ( $show_sidebar ): ?>
	<!-- Secondary Sidebar -->
	<section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class); ?>"><?php get_sidebar($sidebar_id); ?></section>
	<!-- Secondary Sidebar End -->
<?php endif; ?>
<div class="dt-sc-hr-invisible"></div>

<?php get_footer(); ?>