<?php /*Template Name: Blog Template*/?>
<?php get_header();

	$tpl_default_settings = get_post_meta( $post->ID, '_tpl_default_settings', TRUE );
	$tpl_default_settings = is_array( $tpl_default_settings ) ? $tpl_default_settings  : array();

	$page_layout  = array_key_exists( "layout", $tpl_default_settings ) ? $tpl_default_settings['layout'] : "content-full-width";
	if($GLOBALS['force_enable'] == true) {
		$page_layout = painting_option('general', 'global-page-layout');
		$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
	}
	$show_sidebar = false;
	$sidebar_class = $sidebar_id = "";

	switch ( $page_layout ) {
		case 'with-left-sidebar':
			$page_class = "page-with-sidebar with-left-sidebar";
			$show_sidebar = true;
			$sidebar_class = "secondary-has-left-sidebar";
			$sidebar_id = "left";
		break;

		case 'with-right-sidebar':
			$page_class = "page-with-sidebar with-right-sidebar";
			$show_sidebar = true;
			$sidebar_class = "secondary-has-right-sidebar";
			$sidebar_id = "right";
		break;

		case 'content-full-width':
		default:
			$page_class = "content-full-width";
		break;
	}

?>

<!-- ** Primary Section ** -->
<section id="primary" class="<?php echo esc_attr($page_class);?>">

    <?php if( have_posts() ):
        while( have_posts() ):
            the_post();
            the_content();
            if(get_the_content() != '') echo '<div class="dt-sc-clear"></div>';
        endwhile;
    endif;?>
    
    <?php 
	get_template_part( 'framework/loops/content', 'tpl-blog' );
	wp_link_pages( array('before' => '<div class="page-link">','after' =>'</div>', 'link_before' => '<span>', 'link_after' => '</span>', 'next_or_number' => 'number', 'pagelink' => '%', 'echo' => 1 ) );
	edit_post_link(esc_html__( ' Edit ','painting' ),'','',$post->ID); 
	?>
    
    <div class="dt-sc-hr-invisible"></div>
    
</section><!-- ** Primary Section End ** -->

<?php if ( $show_sidebar ): ?>
    <!-- Secondary Sidebar -->
    <section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class); ?>"><?php get_sidebar($sidebar_id); ?></section>
    <!-- Secondary Sidebar End -->
<?php endif; ?>

<?php get_footer(); ?>