<?php
/**
 * Cross-sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cross-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$product		    		= painting_get_global_variables('product'); 
$woocommerce_loop		    = painting_get_global_variables('woocommerce_loop'); 

if ( $cross_sells ) : ?>
	
    <div class="dt-sc-margin50"></div>

	<div class="cross-sells">

        <div class="hr-title dt-sc-hr-invisible-small">
            <h3><?php esc_html_e( 'Products you might be interested in', 'painting' ) ?></h3>
            <div class="title-sep-container"><div class="title-sep"> </div></div>
        </div>

		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $cross_sells as $cross_sell ) : ?>

				<?php
			 	$post_object = get_post( $cross_sell->get_id() );

				setup_postdata( $GLOBALS['post'] =& $post_object );

				wc_get_template_part( 'content', 'product' ); 
				?>

			<?php endforeach; ?>			

		<?php woocommerce_product_loop_end(); ?>

	</div>

<?php endif;

wp_reset_query();
