<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$product = painting_get_global_variables('product'); 
$woocommerce_loop = painting_get_global_variables('woocommerce_loop'); 
$post = painting_get_global_variables('post'); 

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

$classes = array('product-wrapper');	

switch($woocommerce_loop['columns']) {
	case 2:
		$classes[] = 'product-two-column';
		break;

	case 3:
		$classes[] = 'product-three-column';
		break;

	case 4:
		$classes[] = 'product-four-column';
		break;
	
	default:
		$classes[] = 'product-four-column';
		break;
}

if( ! $product->is_in_stock() || in_array( $product->get_type(), array('external','grouped','variable') ) ){
	$add_to_cart = '<a href="'. get_permalink() .'" rel="nofollow" data-product_id="'.$product->get_id().'" class="product_type_'.$product->get_type().'"><span class="fa fa-sliders"></span> '.esc_html__('View Details', 'painting').'</a>';
} else {
	$add_to_cart = '<a href="'. apply_filters( 'add_to_cart_url', esc_url( $product->add_to_cart_url() ) ) .'" rel="nofollow" data-product_id="'.$product->get_id().'" class="add_to_cart_button ajax_add_to_cart product_type_'.$product->get_type().'"><span class="fa fa-shopping-cart"></span> '.esc_html__('Add to Cart', 'painting').'</a>';
}

?>

<li>
	
    <div <?php post_class( $classes ); ?>>

        <div class="product-container">
        	<?php 
			if (has_post_thumbnail()) { 
				?>
                <a href="<?php the_permalink(); ?>">
                	<?php 
					if($product->is_featured()) echo apply_filters( 'woocommerce_sale_flash', '<div class="featured-tag"><div><i class="fa fa-thumb-tack"></i><span>'.esc_html__( 'Featured', 'painting' ).'</span></div></div>', $post, $product ); 
					if($product->is_on_sale() and $product->is_in_stock()) echo apply_filters('woocommerce_sale_flash', '<span class="onsale"><span>'.esc_html__( 'Sale!', 'painting' ).'</span></span>', $post, $product);
					elseif(!$product->is_in_stock()) echo apply_filters( 'woocommerce_sale_flash', '<span class="out-of-stock"><span>'.esc_html__( 'Out of Stock', 'painting' ).'</span></span>', $post, $product );
					?>
                	<div class="product-thumb">
                    	<?php
						$featureimg_id = get_post_thumbnail_id( $product->get_id() );
						$featureimg_attrs = wp_get_attachment_image_src($featureimg_id, 'shop_catalog');
						?>
                        <img src=" <?php echo esc_url($featureimg_attrs[0]); ?>" alt="<?php echo get_the_title(); ?>" title="<?php echo get_the_title(); ?>" class="primary-image" />
                    	<?php
						$attachment_ids = $product->get_gallery_image_ids();
						if(isset($attachment_ids[0])) {
							$attachmentimg_attrs = wp_get_attachment_image_src($attachment_ids[0], 'shop_catalog');
							?>
							<img src=" <?php echo esc_url($attachmentimg_attrs[0]); ?>" alt="<?php echo get_the_title(); ?>" title="<?php echo get_the_title(); ?>" class="secondary-image" />
							<?php
						}
						?>
                    </div>
                </a>
            <?php } ?>
            <div class="product-title"> 
                <?php echo ($add_to_cart != '') ? $add_to_cart : ''; ?>
                <?php if (shortcode_exists('yith_wcwl_add_to_wishlist')) echo do_shortcode('[yith_wcwl_add_to_wishlist /]'); ?>
            </div>
        </div>
        <div class="product-details"> 
            <h5> <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a> </h5>
            <?php woocommerce_template_loop_price(); ?>
        </div>
    
        <?php
    
            /**
             * woocommerce_after_shop_loop_item hook
             *
             * @hooked woocommerce_template_loop_add_to_cart - 10
             */
			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
        ?>
    
    </div>

</li>