<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$product = painting_get_global_variables('product'); 
$post = painting_get_global_variables('post'); 

$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

?>
<div class="project-details">

    <?php do_action( 'woocommerce_product_meta_start' ); ?>
    
    <ul class="client-details">
        <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
            <li>
                <p><span><?php esc_html_e( 'SKU:', 'painting' ); ?></span> <?php echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'painting' ); ?> </p>
            </li>
        <?php endif; ?>
        <li>
            <?php echo wc_get_product_category_list( $product->get_id(), ', ', '<p><span>' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'painting' ) . '</span>', '</p>' ); ?>
        </li>
        <li>
            <?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<p><span>' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'painting' ) . '</span>', '.</p>' ); ?>
        </li>
    </ul>

    <?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>