<?php
global $post;
$template_general_settings = get_post_meta ( $post->ID, '_template_general_settings', TRUE );
$template_general_settings = is_array($template_general_settings) ? $template_general_settings : array ();

wp_nonce_field( 'dtcore_plugin_template_metabox', 'dtcore_plugin_template_metabox_nonce' );
?>

<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Enable Custom General Settings','dt_plugins');?></label>
	</div>
	<div class="column five-sixth last">
		<?php
        $switchclass = array_key_exists ( "enable-general-settings", $template_general_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
        $checked = array_key_exists ( "enable-general-settings", $template_general_settings ) ? ' checked="checked"' : '';
        ?>
        <div data-for="dttheme-enable-general-settings" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
		<input id="dttheme-enable-general-settings" class="hidden" type="checkbox" name="dttheme-enable-general-settings" value="true" <?php echo esc_attr($checked);?> />
		<p class="note"> <?php esc_html_e('You can enable / disable custom general settings here. Note default options from Buddha Panel will be overwritten once enabled.','dt_plugins');?> </p>
	</div>
</div>

<div class="custom-box">
    <div class="column one-sixth">
        <label><?php esc_html_e('Logo','dt_plugins');?></label>
    </div>
    <div class="column five-sixth last">
        <?php $template_logo = array_key_exists('template-logo', $template_general_settings) ? $template_general_settings['template-logo'] : ''; ?>
        <input id="dttheme-template-logo" name="dttheme-template-logo" type="text" class="uploadfield large" value="<?php echo esc_url($template_logo); ?>"/>
        <input type="button" value="<?php esc_html_e('Upload', 'dt_plugins');?>" class="upload_image_button" />
        <input type="button" value="<?php esc_html_e('Remove', 'dt_plugins');?>" class="upload_image_reset" />
        <?php painting_adminpanel_image_preview($template_logo,false,'logo.png');?>
        <p class="note"> <?php esc_html_e('You can choose separate logo for this template.', 'dt_plugins');?></p>
    </div>
</div>

<div class="custom-box">
    <div class="column one-sixth">
        <label><?php esc_html_e('Retina Logo','dt_plugins');?></label>
    </div>
    <div class="column five-sixth last">
        <?php $template_retina_logo = array_key_exists('template-retina-logo', $template_general_settings) ? $template_general_settings['template-retina-logo'] : ''; ?>
        <input id="dttheme-template-retina-logo" name="dttheme-template-retina-logo" type="text" class="uploadfield large" value="<?php echo esc_url($template_retina_logo); ?>"/>
        <input type="button" value="<?php esc_html_e('Upload', 'dt_plugins');?>" class="upload_image_button" />
        <input type="button" value="<?php esc_html_e('Remove', 'dt_plugins');?>" class="upload_image_reset" />
        <?php painting_adminpanel_image_preview($template_retina_logo,false,'logo@2x.png');?>
        <p class="note"> <?php esc_html_e('You can choose separate retina logo for this template.', 'dt_plugins');?></p>
    </div>
</div>

<div class="custom-box">
    <div class="column one-half">
        <div class="column one-third">
            <label><?php esc_html_e('Retina Logo Width','dt_plugins');?></label>
        </div>
        <div class="column two-third last">
			<?php $retina_logo_width = array_key_exists('template-retina-logo-width', $template_general_settings) ? $template_general_settings['template-retina-logo-width'] : ''; ?>
            <input type="text" class="large" name="dttheme-template-retina-logo-width" value="<?php echo esc_attr($retina_logo_width); ?>" />
        </div>
    </div>
    <div class="column one-half last">
        <div class="column one-third">
            <label><?php esc_html_e('Retina Logo Height','dt_plugins');?></label>
        </div>
        <div class="column two-third last">
			<?php $retina_logo_height = array_key_exists('template-retina-logo-height', $template_general_settings) ? $template_general_settings['template-retina-logo-height'] : ''; ?>
            <input type="text" class="large" name="dttheme-template-retina-logo-height" value="<?php echo esc_attr($retina_logo_height); ?>" />
        </div>
    </div>
    <p class="note"> <?php esc_html_e('If retina logo is uploaded, enter the standard logo width and height in above respective boxes.', 'dt_plugins');?></p>
</div>

<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Header Types','dt_plugins');?></label>
	</div>
	<div class="column five-sixth last">
    	<?php $header_type = array_key_exists('header-type', $template_general_settings) ? $template_general_settings['header-type'] : 'default'; ?>
        <select id="dttheme-header-type" name="dttheme-header-type" class="dt-chosen-select">
            <?php 
			$headertypes = array('default' => 'Default', 'header2' => 'Header 2', 'header3' => 'Header 3', 'header4' => 'Header 4');
            foreach($headertypes as $headerkey => $headertype):
                $s = selected($header_type, $headerkey, false);
                echo '<option value="'.$headerkey.'" '.$s.' >'.$headertype.'</option>';
            endforeach;
            ?>
        </select>
		<p class="note"> <?php esc_html_e('Choose any one of the available Menu type for your page.','dt_plugins');?> </p>
	</div>
</div>

<div class="custom-box">
	<div class="column one-half">
        <div class="column one-third">
            <label><?php esc_html_e('Header Left Content','dt_plugins');?></label>
        </div>
        <div class="column two-third last">
            <?php $header_leftcontent = array_key_exists('header-leftcontent', $template_general_settings) ? $template_general_settings['header-leftcontent'] : ''; ?>
            <textarea id="dttheme-header-leftcontent" name="dttheme-header-leftcontent" style="width:420px; height:180px;"><?php echo stripslashes($header_leftcontent); ?></textarea>
            <p class="note"><?php esc_html_e("Content added here will appear in left side of header.",'dt_plugins');?></p>
        </div>
    </div>
	<div class="column one-half last">
        <div class="column one-third">
            <label><?php esc_html_e('Header Right Content','dt_plugins');?></label>
        </div>
        <div class="column two-third last">
            <?php $header_rightcontent = array_key_exists('header-rightcontent', $template_general_settings) ? $template_general_settings['header-rightcontent'] : ''; ?>
            <textarea id="dttheme-header-rightcontent" name="dttheme-header-rightcontent" style="width:420px; height:180px;"><?php echo stripslashes($header_rightcontent); ?></textarea>
            <p class="note"><?php esc_html_e("Content added here will appear in right side of header.",'dt_plugins');?></p>
        </div>
    </div>
</div>

<div class="custom-box">
	<div class="column one-sixth">
		<label><?php esc_html_e('Enable Top Bar','dt_plugins');?></label>
	</div>
	<div class="column five-sixth last">
		<?php
        $switchclass = array_key_exists ( "enable-topbar", $template_general_settings ) ? 'checkbox-switch-on' : 'checkbox-switch-off';
        $checked = array_key_exists ( "enable-topbar", $template_general_settings ) ? ' checked="checked"' : '';
        ?>
        <div data-for="dttheme-enable-topbar" class="dt-checkbox-switch <?php echo esc_attr($switchclass);?>"></div>
		<input id="dttheme-enable-topbar" class="hidden" type="checkbox" name="dttheme-enable-topbar" value="true" <?php echo esc_attr($checked);?> />
		<p class="note"> <?php esc_html_e('If you wish you can enable top bar for this page.','dt_plugins');?> </p>
	</div>
</div>