<?php 
get_header();

$page_layout 	= dttheme_option('pageoptions','portfolio-archives-page-layout');
$page_layout 	= !empty($page_layout) ? $page_layout : "content-full-width";
if($GLOBALS['force_enable'] == true) {
	$page_layout = dttheme_option('general', 'global-page-layout');
	$page_layout = !empty($page_layout) ? $page_layout : "content-full-width";
}

$show_sidebar = $show_left_sidebar = $show_right_sidebar =  false;
$sidebar_class = $sidebar_id = "";

switch ( $page_layout ) {
	case 'with-left-sidebar':
		$page_class = "page-with-sidebar with-left-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-left-sidebar";
		$sidebar_id = "left";
	break;

	case 'with-right-sidebar':
		$page_class = "page-with-sidebar with-right-sidebar";
		$show_sidebar = true;
		$sidebar_class = "secondary-has-right-sidebar";
		$sidebar_id = "right";
	break;

	case 'content-full-width':
	default:
		$page_class = "content-full-width";
	break;
}

$post_layout = dttheme_option('pageoptions','portfolio-archives-post-layout'); 
$post_layout = !empty($post_layout) ? $post_layout : "one-fourth-column";
$post_class = "";

#TO SET POST LAYOUT
switch($post_layout):

	case 'one-column':
		$post_class = " portfolio column dt-sc-one-column ";
		$columns = 1;
	break;

	case 'one-half-column';
		$post_class = " portfolio column dt-sc-one-half ";
		$columns = 2;
	break;
	
	case 'one-third-column':
		$post_class = " portfolio column dt-sc-one-third ";
		$columns = 3;
	break;

	case 'one-fourth-column':
		$post_class = "portfolio column dt-sc-one-fourth ";
		$columns = 4;
	break;
endswitch;	

$portfolio_type = dttheme_option('pageoptions','portfolio-archives-layout-type');
?>

<section id="primary" class="<?php echo esc_attr($page_class);?>">

	<div class="portfolio-container <?php echo esc_attr($portfolio_type); ?>">
		
		<?php

		global $wp_query;
		
		if( have_posts() ):
			$i = 1;
			while( have_posts() ):
				the_post();

				$temp_class = "";
				if($i == 1) $temp_class = $post_class." first"; else $temp_class = $post_class;
				if($i == $columns) $i = 1; else $i = $i + 1;

				$the_id = get_the_ID();

				$portfolio_item_meta = get_post_meta($the_id,'_portfolio_settings',TRUE);
				$portfolio_item_meta = is_array($portfolio_item_meta) ? $portfolio_item_meta  : array();

				 $hover_color = array_key_exists('hover-color', $portfolio_item_meta) ? $portfolio_item_meta['hover-color'] : '';
				 $hover_style = '';
				 
				 if($hover_color != '') {
					 
					$hover_color_opacity = array_key_exists('hover-color-opacity', $portfolio_item_meta) ? $portfolio_item_meta['hover-color-opacity'] : '';
					
					$rgb = painting_hex2rgb($hover_color); 
					$hover_style = 'style="background-color:rgba('.$rgb[0].','.$rgb[1].','.$rgb[2].','.$hover_color_opacity.');"';
					
				 }

				?>
				<div id="<?php echo "portfolio-{$the_id}";?>" class="<?php echo esc_attr($temp_class);?>">
                
                    <figure>
                        <?php 
                        $popup = 'http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title();
                        if( array_key_exists('items_name', $portfolio_item_meta) ) {
                            $item =  $portfolio_item_meta['items_name'][0];
                            $popup = $portfolio_item_meta['items'][0];
                            if( "video" === $item ) {
                                $items = array_diff( $portfolio_item_meta['items_name'] , array("video") );
                                if( !empty($items) ) {
                                    echo '<img src="'.esc_attr($portfolio_item_meta['items'][key($items)]).'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';	
                                } else {
                                    echo '<img src="http'.painting_ssl().'://placehold.it/1170x800&text='.get_the_title().'" width="1170" height="800" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                                }
                            } else {
                                $attachment_id = $portfolio_item_meta['items_id'][0];
                                $img_attributes = wp_get_attachment_image_src($attachment_id, 'painting-1200x800');
                                echo '<img src="'.esc_attr($img_attributes[0]).'" width="'.esc_attr($img_attributes[1]).'" height="'.esc_attr($img_attributes[2]).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                            }
                            
                        } else {
                            echo '<img src="'.esc_attr($popup).'" alt="'.get_the_title().'" title="'.get_the_title().'" />';
                        }
						if($portfolio_type == 'type2') echo '<div class="fhover"></div>';
                        ?>
                        <figcaption <?php echo painting_wp_kses($hover_style); ?>>
                            <div class="fig-content-wrapper">
                                <div class="fig-content">
                                    <h5><a href="<?php the_permalink();?>"><?php echo get_the_title(); ?></a></h5>
                                    <?php echo get_the_term_list($the_id, 'portfolio_entries', '<p>', ', ', '</p>'); ?>     
                                    <div class="fig-overlay">
                                        <a class="zoom" href="<?php echo esc_url($popup);?>" data-gal="prettyPhoto[gallery]" title="<?php echo get_the_title(); ?>"> <span class="fa fa-plus"> </span> </a>
                                        <a class="link" href="<?php the_permalink();?>" title="<?php echo get_the_title(); ?>"> <span class="fa fa-link"> </span> </a>
                                    </div>
                                </div>
                            </div>  
                        </figcaption>
                    </figure>             
					
				</div>
				<?php 
			endwhile;
		endif;
		?>
	</div>

	<?php 
	if($wp_query->max_num_pages > 1): 
		?>
        <div class="pagination <?php echo painting_get_pagination_position(); ?>">
            <?php
            $pages = ($wp_query->max_num_pages) ? $wp_query->max_num_pages : 1;
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            if($paged > 1) echo '<div class="prev-post"><a href="'.get_pagenum_link($paged - 1).'"><span class="fa fa-caret-left"></span>&nbsp;'.esc_html__('Prev', 'dt_plugins').'</a></div>';
            echo paginate_links( array(
              'base' 		 => add_query_arg('paged','%#%'),
              'format' 		 => '',
              'current' 	 => $paged,
              'type'     	 => 'list',
              'end_size'     => 2,
              'mid_size'     => 3,
              'prev_next'    => false,
              'total' 		 => $wp_query->max_num_pages )
            );
            if ($paged < $pages) echo '<div class="next-post"><a href="'.get_pagenum_link($paged + 1).'">'.esc_html__('Next', 'dt_plugins').'&nbsp;<span class="fa fa-caret-right"></span></a></div>';
            ?>
        </div>
		<?php
    endif; 
	?>     
          
    <div class="dt-sc-margin80"></div>

</section>
<?php if ( $show_sidebar ): ?>
	<section id="secondary-<?php echo esc_attr($sidebar_id); ?>" class="secondary-sidebar <?php echo esc_attr($sidebar_class); ?>"><?php get_sidebar($sidebar_id); ?></section>
<?php endif; ?>
<?php get_footer(); ?>