<?php
if (! class_exists ( 'DTCoreShortcodes' )) {
	
	/**
	 * Used to "Loades Core Shortcodes & Add button to tinymce"
	 *
	 * @author iamdesigning11
	 */
	class DTCoreShortcodes {
		
		/**
		 * Constructor for DTCoreShortcodes
		 */
		function __construct() {
			define ( 'DESIGNTHEMES_TINYMCE_URL', plugin_dir_url ( __FILE__ ) . 'tinymce' );
			define ( 'DESIGNTHEMES_TINYMCE_PATH', plugin_dir_path ( __FILE__ ) . 'tinymce' );
			
			require_once plugin_dir_path ( __FILE__ ) . 'shortcodes.php';
			
			// Add Hook into the 'init()' action
			add_action ( 'init', array ( $this,'dt_init') );
			
			// Add Hook into the 'wp_enqueue_scripts()' action
			add_action ( 'wp_enqueue_scripts', array ( $this, 'dt_plugin_scripts') );
			
			// Add Hook into the 'admin_init()' action
			add_action ( 'admin_init', array ($this,'dt_admin_init') );
			  
			add_filter ( 'the_content', array ($this,'dt_the_content_filter') );
		}
		
		/**
		 * A function hook that the WordPress core launches at 'init' points
		 */
		function dt_init() {
			
			if (! current_user_can ( 'edit_posts' ) && ! current_user_can ( 'edit_pages' )) {
				return;
			}
			
			if ("true" === get_user_option ( 'rich_editing' )) {
				add_filter ( 'mce_buttons', array (
						$this,
						'dt_register_rich_buttons' 
				) );
				
				add_filter ( 'mce_external_plugins', array (
						$this,
						'dt_add_external_plugins' 
				) );
			}
			
		}
		
		function dt_plugin_scripts() {
			
			/* Front End CSS & jQuery */
			wp_enqueue_style ( 'dt-animation', plugin_dir_url ( __FILE__ ) . 'css/animations.css' );
			wp_enqueue_style ( 'dt-jqueryui', plugin_dir_url ( __FILE__ ) . 'css/jquery-ui.css' );
			wp_enqueue_style ( 'dt-sc', plugin_dir_url ( __FILE__ ) . 'css/shortcodes.css' );
			
			wp_enqueue_script ( 'dt-sc-plugin-scripts', plugin_dir_url ( __FILE__ ) . 'js/jsscplugins.js', array('jquery'), false, true);
			wp_enqueue_script ( 'dt-sc-script', plugin_dir_url ( __FILE__ ) . 'js/shortcodes.js', array('jquery'), false, true );
			
			wp_localize_script ( 'dt-sc-script', 'DtObject', array (
				'ajaxError' => esc_html__('Something went wrong!', 'dt_plugins'),
				'expand' => esc_html__('Expand', 'dt_plugins'),
				'collapse' => esc_html__('Collapse', 'dt_plugins'),
			) );

		}
		
		/**
		 * A function hook that the WordPress core launches at 'admin_init' points
		 */
		function dt_admin_init() {
			wp_enqueue_style ( 'wp-color-picker' );
			wp_enqueue_script ( 'wp-color-picker' );
			
			// css
			wp_enqueue_style ( 'DTCorePlugin-sc-dialog', DESIGNTHEMES_TINYMCE_URL . '/css/styles.css', false, '1.0', 'all' );
			
			wp_localize_script ( 'jquery', 'DTCorePlugin', array (
					'plugin_folder' => WP_PLUGIN_URL . '/buddhathemes-core-features',
					'tinymce_folder' => DESIGNTHEMES_TINYMCE_URL 
			) );
			
		}
		
		/**
		 * A function hook that used to filter the content - to remove unwanted codes
		 *
		 * @param string $content        	
		 * @return string
		 */

		function dt_the_content_filter($content) {
			$dt_shortcodes = array("dt_sc_accordion_group","dt_sc_accordion_frame","dt_sc_button","dt_sc_blockquote","dt_sc_intro_box","dt_sc_one_column","dt_sc_full_width","dt_sc_one_half","dt_sc_one_third","dt_sc_one_fourth","dt_sc_one_fifth","dt_sc_one_sixth","dt_sc_two_sixth","dt_sc_two_third","dt_sc_three_fourth","dt_sc_two_fifth","dt_sc_three_fifth","dt_sc_four_four","dt_sc_four_fifth","dt_sc_three_sixth","dt_sc_four_sixth","dt_sc_five_sixth","dt_sc_one_half_inner","dt_sc_one_third_inner","dt_sc_one_fourth_inner","dt_sc_one_fifth_inner","dt_sc_one_sixth_inner","dt_sc_two_sixth_inner","dt_sc_two_third_inner","dt_sc_three_fourth_inner","dt_sc_two_fifth_inner","dt_sc_three_fifth_inner","dt_sc_four_four_inner","dt_sc_three_sixth_inner","dt_sc_four_sixth_inner","dt_sc_five_sixth_inner","dt_sc_four_fifth_inner","dt_sc_clear","dt_sc_hr_border","dt_sc_hr","dt_sc_hr_line_white","dt_sc_hr_top","dt_sc_hr_medium","dt_sc_hr_large","dt_sc_hr_invisible","dt_sc_hr_invisible_very_small","dt_sc_hr_invisible_small","dt_sc_patners_carousel","dt_sc_donutchart_small","dt_sc_donutchart_medium","dt_sc_icon_box","dt_sc_colored_box","dt_sc_code","dt_sc_fancy_ol","dt_sc_fancy_ul","dt_sc_pricing_table_item","dt_sc_progressbar","dt_sc_tab","dt_sc_tabs_horizontal","dt_sc_tabs_vertical","dt_sc_testimonial","dt_sc_testimonial_carousel","dt_sc_title","dt_sc_toggle_group","dt_sc_toggle_frame","dt_sc_titled_box","dt_sc_tooltip","dt_sc_pullquote","dt_sc_portfolio_item","dt_sc_portfolios","dt_sc_fullwidth_section","dt_sc_animation","dt_sc_post","dt_sc_recent_post","dt_sc_widgets","dt_sc_doshortcode","dt_sc_resizable","dt_sc_resizable_inner","dt_sc_space", "dt_sc_margin", "dt_sc_hr_line","dt_sc_team","dt_sc_team_carousel","dt_sc_image","dt_sc_newsletter_section","dt_sc_animate_number","dt_sc_woo_products","dt_sc_woo_featured_product","dt_sc_custom_menus","dt_sc_custom_menu_item","dt_sc_custom_menu_location","dt_sc_contact_details","dt_sc_social_links","dt_sc_post_carousel","dt_sc_contact_form_wrapper","dt_sc_contact_info","dt_sc_support_info","dt_sc_search_cart","dt_sc_popup_video","dt_sc_icon_box_wrapper","dt_sc_map_address_wrapper","dt_sc_content_carousel","dt_sc_schedule_appointment");

			$block = join("|", $dt_shortcodes );
			// opening tag
			$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);

			// closing tag
			$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
			
			return $rep;
		}

		/**
		 * Adds BuddhaThemes custom shortcode rich buttons to TinyMCE
		 *
		 * @param unknown $buttons        	
		 * @return unknown
		 */
		function dt_register_rich_buttons($buttons) {
			array_push ( $buttons, "|", "designthemes_sc_button" );
			return $buttons;
		}
		
		/**
		 * Adds BuddhaThemes javascript to TinyMCE
		 *
		 * @param unknown $plugins        	
		 * @return unknown
		 */
		function dt_add_external_plugins($plugins) {
			global $wp_version;
			
			if(  version_compare( $wp_version, '3.9' , '<') ) {
				$url = DESIGNTHEMES_TINYMCE_URL . '/plugin-wp-3.8.js';
			} else {
				$url = DESIGNTHEMES_TINYMCE_URL . '/plugin-wp-3.9.js';
			}
			$plugins ['DTCoreShortcodePlugin'] = $url;
			return $plugins;
		}
	}
}
?>